/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.EpollSelectionKeyImpl;
import gnu.java.nio.VMChannel;
import gnu.java.nio.VMChannelOwner;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EpollSelectorImpl
extends AbstractSelector {
    private static final int DEFAULT_EPOLL_SIZE = 128;
    private static final int sizeof_struct_epoll_event;
    private static final int OP_ACCEPT = 16;
    private static final int OP_CONNECT = 8;
    private static final int OP_READ = 1;
    private static final int OP_WRITE = 4;
    private int epoll_fd = EpollSelectorImpl.epoll_create(128);
    private final HashMap keys = new HashMap();
    private Set selectedKeys = null;
    private Thread waitingThread;
    private ByteBuffer events = ByteBuffer.allocateDirect(INITIAL_CAPACITY);
    private static final int INITIAL_CAPACITY;
    private static final int MAX_DOUBLING_CAPACITY;
    private static final int CAPACITY_INCREMENT;

    public EpollSelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
    }

    public Set keys() {
        return new HashSet(this.keys.values());
    }

    public int select() throws IOException {
        return this.doSelect(-1);
    }

    public int select(long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("timeout is too large");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("invalid timeout");
        }
        return this.doSelect((int)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doSelect(int n) throws IOException {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            Set<SelectionKey> set;
            Set<SelectionKey> set2 = set = this.cancelledKeys();
            synchronized (set2) {
                int n2;
                Object object;
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (EpollSelectionKeyImpl)iterator.next();
                    EpollSelectorImpl.epoll_delete(this.epoll_fd, ((EpollSelectionKeyImpl)object).fd);
                    ((EpollSelectionKeyImpl)object).valid = false;
                    this.keys.remove(((EpollSelectionKeyImpl)object).fd);
                    iterator.remove();
                    this.deregister((AbstractSelectionKey)object);
                }
                iterator = this.keys.values().iterator();
                while (iterator.hasNext()) {
                    object = (EpollSelectionKeyImpl)iterator.next();
                    SelectableChannel selectableChannel = ((EpollSelectionKeyImpl)object).channel();
                    if (!(selectableChannel instanceof VMChannelOwner) || ((VMChannelOwner)((Object)selectableChannel)).getVMChannel().getState().isValid()) continue;
                    iterator.remove();
                }
                if (this.keys.isEmpty()) {
                    return 0;
                }
                try {
                    this.begin();
                    this.waitingThread = Thread.currentThread();
                    n2 = EpollSelectorImpl.epoll_wait(this.epoll_fd, this.events, this.keys.size(), n);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    Thread.interrupted();
                    this.waitingThread = null;
                    this.end();
                    throw throwable;
                }
                Thread.interrupted();
                this.waitingThread = null;
                this.end();
                object = new HashSet(n2);
                for (int i = 0; i < n2; ++i) {
                    this.events.position(i * sizeof_struct_epoll_event);
                    ByteBuffer byteBuffer = this.events.slice();
                    int n3 = EpollSelectorImpl.selected_fd(byteBuffer);
                    EpollSelectionKeyImpl epollSelectionKeyImpl = (EpollSelectionKeyImpl)this.keys.get(n3);
                    if (epollSelectionKeyImpl == null) {
                        throw new IOException("fd was selected, but no key found");
                    }
                    epollSelectionKeyImpl.selectedOps = EpollSelectorImpl.selected_ops(byteBuffer) & epollSelectionKeyImpl.interestOps;
                    ((HashSet)object).add(epollSelectionKeyImpl);
                }
                this.reallocateBuffer();
                this.selectedKeys = object;
                return n2;
            }
        }
    }

    public Set selectedKeys() {
        if (this.selectedKeys == null) {
            return Collections.EMPTY_SET;
        }
        return this.selectedKeys;
    }

    public int selectNow() throws IOException {
        return this.doSelect(0);
    }

    public Selector wakeup() {
        try {
            this.waitingThread.interrupt();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this;
    }

    protected void implCloseSelector() throws IOException {
        VMChannel.close(this.epoll_fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        if (!(abstractSelectableChannel instanceof VMChannelOwner)) {
            throw new IllegalArgumentException("unsupported channel type");
        }
        VMChannel vMChannel = ((VMChannelOwner)((Object)abstractSelectableChannel)).getVMChannel();
        try {
            int n2 = vMChannel.getState().getNativeFD();
            HashMap hashMap = this.keys;
            synchronized (hashMap) {
                if (this.keys.containsKey(n2)) {
                    throw new IllegalArgumentException("channel already registered");
                }
                EpollSelectionKeyImpl epollSelectionKeyImpl = new EpollSelectionKeyImpl(this, abstractSelectableChannel, n2);
                if ((n & ~abstractSelectableChannel.validOps()) != 0) {
                    throw new IllegalArgumentException("invalid ops for channel");
                }
                epollSelectionKeyImpl.interestOps = n;
                epollSelectionKeyImpl.selectedOps = 0;
                epollSelectionKeyImpl.valid = true;
                epollSelectionKeyImpl.attach(object);
                epollSelectionKeyImpl.key = System.identityHashCode(epollSelectionKeyImpl);
                EpollSelectorImpl.epoll_add(this.epoll_fd, epollSelectionKeyImpl.fd, n);
                this.keys.put(n2, epollSelectionKeyImpl);
                this.reallocateBuffer();
                return epollSelectionKeyImpl;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    private void reallocateBuffer() {
        if (this.events.capacity() < this.keys.size() * sizeof_struct_epoll_event) {
            int n = this.events.capacity();
            n = n < MAX_DOUBLING_CAPACITY ? (n <<= 1) : (n += CAPACITY_INCREMENT);
            this.events = ByteBuffer.allocateDirect(n);
        } else if (this.events.capacity() > this.keys.size() * sizeof_struct_epoll_event * 2 + 1 && this.events.capacity() > INITIAL_CAPACITY) {
            int n = this.events.capacity() >>> 1;
            this.events = ByteBuffer.allocateDirect(n);
        }
    }

    void epoll_modify(EpollSelectionKeyImpl epollSelectionKeyImpl, int n) throws IOException {
        EpollSelectorImpl.epoll_modify(this.epoll_fd, epollSelectionKeyImpl.fd, n);
    }

    public static native boolean epoll_supported();

    private static native int sizeof_struct();

    private static native int epoll_create(int var0) throws IOException;

    private static native void epoll_add(int var0, int var1, int var2) throws IOException;

    private static native void epoll_modify(int var0, int var1, int var2) throws IOException;

    private static native void epoll_delete(int var0, int var1) throws IOException;

    private static native int epoll_wait(int var0, ByteBuffer var1, int var2, int var3) throws IOException;

    private static native int selected_fd(ByteBuffer var0);

    private static native int selected_ops(ByteBuffer var0);

    static {
        System.loadLibrary("javanio");
        sizeof_struct_epoll_event = EpollSelectorImpl.epoll_supported() ? EpollSelectorImpl.sizeof_struct() : -1;
        INITIAL_CAPACITY = 64 * sizeof_struct_epoll_event;
        MAX_DOUBLING_CAPACITY = 1024 * sizeof_struct_epoll_event;
        CAPACITY_INCREMENT = 128 * sizeof_struct_epoll_event;
    }
}

