/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.EpollSelectorImpl;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;

public class EpollSelectionKeyImpl
extends AbstractSelectionKey {
    final int fd;
    private final EpollSelectorImpl selector;
    private final SelectableChannel channel;
    int interestOps;
    int selectedOps;
    int key;
    boolean valid;
    boolean cancelled;

    EpollSelectionKeyImpl(EpollSelectorImpl epollSelectorImpl, SelectableChannel selectableChannel, int n) {
        this.selector = epollSelectorImpl;
        this.channel = selectableChannel;
        this.fd = n;
    }

    public SelectableChannel channel() {
        return this.channel;
    }

    public int interestOps() {
        return this.interestOps;
    }

    public SelectionKey interestOps(int n) {
        if (this.cancelled) {
            throw new CancelledKeyException();
        }
        if ((n & ~this.channel.validOps()) != 0) {
            throw new IllegalArgumentException("unsupported channel ops");
        }
        try {
            this.selector.epoll_modify(this, n);
            this.interestOps = n;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        return this;
    }

    public int readyOps() {
        return this.selectedOps;
    }

    public Selector selector() {
        return this.selector;
    }
}

