/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainDatagramSocketImpl;
import gnu.java.nio.NIODatagramSocket;
import gnu.java.nio.VMChannel;
import gnu.java.nio.VMChannelOwner;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;

public final class DatagramChannelImpl
extends DatagramChannel
implements VMChannelOwner {
    private NIODatagramSocket socket = new NIODatagramSocket(new PlainDatagramSocketImpl(), this);
    private VMChannel channel = new VMChannel();
    private boolean inChannelOperation;

    protected DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.channel.initSocket(false);
        this.configureBlocking(true);
    }

    public final boolean isInChannelOperation() {
        return this.inChannelOperation;
    }

    public final void setInChannelOperation(boolean bl) {
        this.inChannelOperation = bl;
    }

    public DatagramSocket socket() {
        return this.socket;
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.channel.close();
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.channel.setBlocking(bl);
    }

    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        try {
            this.channel.connect((InetSocketAddress)socketAddress, 0);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("unsupported socked address type");
        }
        return this;
    }

    public DatagramChannel disconnect() throws IOException {
        this.channel.disconnect();
        return this;
    }

    public boolean isConnected() {
        try {
            return this.channel.getPeerAddress() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.channel.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        return this.channel.writeGathering(byteBufferArray, n, n2);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.channel.read(byteBuffer);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        return this.channel.readScattering(byteBufferArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        SocketAddress socketAddress;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        try {
            this.begin();
            socketAddress = this.channel.receive(byteBuffer);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.end(true);
            throw throwable;
        }
        this.end(true);
        return socketAddress;
    }

    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IOException("can only send to inet socket addresses");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new IOException("Target address not resolved");
        }
        return this.channel.send(byteBuffer, inetSocketAddress);
    }

    public VMChannel getVMChannel() {
        return this.channel;
    }
}

