/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCookieManager
implements CookieManager {
    protected Map<String, Map<String, Cookie>> cookies = new HashMap<String, Map<String, Cookie>>();

    @Override
    public void setCookie(Cookie cookie) {
        String string = cookie.getDomain();
        Map<String, Cookie> map = this.cookies.get(string);
        if (map == null) {
            map = new HashMap<String, Cookie>();
            this.cookies.put(string, map);
        }
        String string2 = cookie.getName();
        map.put(string2, cookie);
    }

    @Override
    public Cookie[] getCookies(String string, boolean bl, String string2) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        Date date = new Date();
        if (Character.isLetter(string.charAt(0))) {
            int n = string.indexOf(46);
            while (n != -1) {
                this.addCookies(arrayList, string, bl, string2, date);
                string = string.substring(n);
                n = string.indexOf(46, 1);
            }
        }
        this.addCookies(arrayList, string, bl, string2, date);
        Cookie[] cookieArray = new Cookie[arrayList.size()];
        arrayList.toArray(cookieArray);
        return cookieArray;
    }

    private void addCookies(ArrayList<Cookie> arrayList, String string, boolean bl, String string2, Date date) {
        Map<String, Cookie> map = this.cookies.get(string);
        if (map != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Map.Entry<String, Cookie> entry : map.entrySet()) {
                Cookie cookie = entry.getValue();
                Date date2 = cookie.getExpiryDate();
                if (date2 != null && date2.before(date)) {
                    arrayList2.add(entry.getKey());
                    continue;
                }
                if (bl && !cookie.isSecure() || !string2.startsWith(cookie.getPath())) continue;
                arrayList.add(cookie);
            }
            Iterator<Map.Entry<String, Cookie>> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
        }
    }
}

