/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.lang.CPStringBuilder;
import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.http.HTTPDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Headers
implements Iterable<HeaderElement> {
    private final ArrayList<HeaderElement> headers = new ArrayList();
    private static final DateFormat dateFormat = new HTTPDateFormat();

    @Override
    public Iterator<HeaderElement> iterator() {
        return this.headers.iterator();
    }

    public String getValue(String string) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            HeaderElement headerElement = this.headers.get(i);
            if (!headerElement.name.equalsIgnoreCase(string)) continue;
            return headerElement.value;
        }
        return null;
    }

    public int getIntValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public long getLongValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public Date getDateValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return dateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void put(String string, String string2) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            HeaderElement headerElement = this.headers.get(i);
            if (!headerElement.name.equalsIgnoreCase(string)) continue;
            headerElement.value = string2;
            return;
        }
        this.addValue(string, string2);
    }

    public void putAll(Headers headers) {
        for (HeaderElement headerElement : headers) {
            this.remove(headerElement.name);
            this.addValue(headerElement.name, headerElement.value);
        }
    }

    public void remove(String string) {
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            HeaderElement headerElement = (HeaderElement)iterator.next();
            if (!headerElement.name.equalsIgnoreCase(string)) continue;
            iterator.remove();
        }
    }

    public void parse(InputStream inputStream) throws IOException {
        LineInputStream lineInputStream = inputStream instanceof LineInputStream ? (LineInputStream)inputStream : new LineInputStream(inputStream);
        String string = null;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (true) {
            int n;
            String string2;
            if ((string2 = lineInputStream.readLine()) == null) {
                if (string == null) break;
                this.addValue(string, cPStringBuilder.toString());
                break;
            }
            int n2 = string2.length();
            if (n2 < 2) {
                if (string == null) break;
                this.addValue(string, cPStringBuilder.toString());
                break;
            }
            char c = string2.charAt(0);
            if (c == ' ' || c == '\t') {
                n = n2 - 1;
                if (string2.charAt(n) != '\r') {
                    ++n;
                }
                cPStringBuilder.append(string2.substring(0, n));
                continue;
            }
            if (string != null) {
                this.addValue(string, cPStringBuilder.toString());
            }
            n = string2.indexOf(58);
            string = string2.substring(0, n);
            cPStringBuilder.setLength(0);
            while (++n < n2 && string2.charAt(n) == ' ') {
            }
            int n3 = n2 - 1;
            if (string2.charAt(n3) != '\r') {
                ++n3;
            }
            cPStringBuilder.append(string2.substring(n, n3));
        }
    }

    public void addValue(String string, String string2) {
        this.headers.add(this.headers.size(), new HeaderElement(string, string2));
    }

    public Map<String, List<String>> getAsMap() {
        ArrayList arrayList;
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (HeaderElement object : this.headers) {
            arrayList = (ArrayList)linkedHashMap.get(object.name);
            if (arrayList == null) {
                arrayList = new ArrayList(1);
                arrayList.add(object.value);
                linkedHashMap.put(object.name, arrayList);
                continue;
            }
            arrayList.add(0, object.value);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList = (List)entry.getValue();
            entry.setValue(Collections.unmodifiableList(arrayList));
        }
        return linkedHashMap;
    }

    public String getHeaderName(int n) {
        if (n >= this.headers.size() || n < 0) {
            return null;
        }
        return this.headers.get((int)n).name;
    }

    public String getHeaderValue(int n) {
        if (n >= this.headers.size() || n < 0) {
            return null;
        }
        return this.headers.get((int)n).value;
    }

    static class HeaderElement {
        String name;
        String value;

        HeaderElement(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

