/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import gnu.java.net.VMPlainSocketImpl;
import gnu.java.nio.SocketChannelImpl;
import gnu.java.nio.VMChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public class PlainSocketImpl
extends SocketImpl {
    protected VMPlainSocketImpl impl = new VMPlainSocketImpl();
    private InputStream in;
    private OutputStream out;
    private boolean inChannelOperation;
    SocketChannelImpl channel;

    public final boolean isInChannelOperation() {
        return this.inChannelOperation;
    }

    public final void setInChannelOperation(boolean bl) {
        this.inChannelOperation = bl;
    }

    public void setOption(int n, Object object) throws SocketException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 18: 
            case 32: 
            case 128: 
            case 4097: 
            case 4098: 
            case 4099: 
            case 4102: {
                this.impl.setOption(n, object);
                return;
            }
        }
        throw new SocketException("Unrecognized TCP option: " + n);
    }

    public Object getOption(int n) throws SocketException {
        if (n == 15) {
            try {
                return this.channel.getVMChannel().getLocalAddress().getAddress();
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException();
                socketException.initCause(iOException);
                throw socketException;
            }
        }
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 18: 
            case 32: 
            case 128: 
            case 4097: 
            case 4098: 
            case 4099: 
            case 4102: {
                return this.impl.getOption(n);
            }
        }
        throw new SocketException("Unrecognized TCP option: " + n);
    }

    public void shutdownInput() throws IOException {
        this.impl.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.impl.shutdownOutput();
    }

    protected synchronized void create(boolean bl) throws IOException {
        this.channel = new SocketChannelImpl(false);
        VMChannel vMChannel = this.channel.getVMChannel();
        vMChannel.initSocket(bl);
        this.channel.configureBlocking(true);
        this.impl.getState().setChannelFD(vMChannel.getState());
    }

    protected synchronized void connect(String string, int n) throws IOException {
        this.connect(InetAddress.getByName(string), n);
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.connect(new InetSocketAddress(inetAddress, n), 0);
    }

    protected synchronized void connect(SocketAddress socketAddress, int n) throws IOException {
        boolean bl;
        if (this.channel == null) {
            this.create(true);
        }
        if (!(bl = this.channel.connect(socketAddress, n))) {
            throw new SocketTimeoutException("connect timed out");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.address = inetSocketAddress.getAddress();
        this.port = inetSocketAddress.getPort();
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        if (this.channel == null) {
            this.create(true);
        }
        this.impl.bind(new InetSocketAddress(inetAddress, n));
        this.localport = this.channel.getVMChannel().getLocalAddress().getPort();
    }

    protected synchronized void listen(int n) throws IOException {
        this.impl.listen(n);
    }

    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        if (this.channel == null) {
            this.create(true);
        }
        if (!(socketImpl instanceof PlainSocketImpl)) {
            throw new IOException("incompatible SocketImpl: " + socketImpl.getClass().getName());
        }
        PlainSocketImpl plainSocketImpl = (PlainSocketImpl)socketImpl;
        VMChannel vMChannel = this.channel.getVMChannel().accept();
        plainSocketImpl.impl.getState().setChannelFD(vMChannel.getState());
        plainSocketImpl.channel = new SocketChannelImpl(vMChannel);
        plainSocketImpl.setOption(4, Boolean.TRUE);
        plainSocketImpl.setOption(4102, 0);
    }

    protected int available() throws IOException {
        if (this.channel == null) {
            throw new SocketException("not connected");
        }
        return this.channel.getVMChannel().available();
    }

    protected void close() throws IOException {
        if (this.impl.getState().isValid()) {
            this.impl.close();
        }
        this.address = null;
        this.port = -1;
    }

    public void sendUrgentData(int n) throws IOException {
        this.impl.sendUrgentData(n);
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new SocketInputStream();
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new SocketOutputStream();
        }
        return this.out;
    }

    public VMChannel getVMChannel() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getVMChannel();
    }

    protected InetAddress getInetAddress() {
        if (this.channel == null) {
            return null;
        }
        try {
            InetSocketAddress inetSocketAddress = this.channel.getVMChannel().getPeerAddress();
            if (inetSocketAddress == null) {
                return null;
            }
            if (this.address != null) {
                return this.address;
            }
            return inetSocketAddress.getAddress();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected int getLocalPort() {
        if (this.channel == null) {
            return -1;
        }
        try {
            InetSocketAddress inetSocketAddress = this.channel.getVMChannel().getLocalAddress();
            if (inetSocketAddress == null) {
                return -1;
            }
            return inetSocketAddress.getPort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public InetSocketAddress getLocalAddress() {
        if (this.channel == null) {
            return null;
        }
        try {
            return this.channel.getVMChannel().getLocalAddress();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected int getPort() {
        if (this.channel == null) {
            return -1;
        }
        try {
            InetSocketAddress inetSocketAddress = this.channel.getVMChannel().getPeerAddress();
            if (inetSocketAddress == null) {
                return -1;
            }
            return inetSocketAddress.getPort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    final class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        public void close() throws IOException {
            PlainSocketImpl.this.close();
        }

        public void write(int n) throws IOException {
            if (PlainSocketImpl.this.channel == null) {
                throw new SocketException("not connected");
            }
            while (true) {
                try {
                    PlainSocketImpl.this.channel.getVMChannel().write(n);
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (PlainSocketImpl.this.channel == null) {
                throw new SocketException("not connected");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            while (byteBuffer.hasRemaining()) {
                try {
                    if (PlainSocketImpl.this.channel.write(byteBuffer) != -1) continue;
                    throw new IOException("channel has been closed");
                }
                catch (InterruptedIOException interruptedIOException) {
                }
            }
        }
    }

    final class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        public int available() throws IOException {
            return PlainSocketImpl.this.available();
        }

        public void close() throws IOException {
            PlainSocketImpl.this.close();
        }

        public int read() throws IOException {
            if (PlainSocketImpl.this.channel == null) {
                throw new SocketException("not connected");
            }
            while (true) {
                try {
                    return PlainSocketImpl.this.channel.getVMChannel().read();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw socketTimeoutException;
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (PlainSocketImpl.this.channel == null) {
                throw new SocketException("not connected");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            while (true) {
                try {
                    return PlainSocketImpl.this.channel.read(byteBuffer);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw socketTimeoutException;
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }
    }
}

