/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import gnu.java.net.VMPlainSocketImpl;
import gnu.java.nio.VMChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public final class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private final VMChannel channel;
    private final VMPlainSocketImpl impl;
    private final Object RECEIVE_LOCK = new Object();
    private final Object SEND_LOCK = new Object();

    public PlainDatagramSocketImpl() throws IOException {
        this.channel = new VMChannel();
        this.impl = new VMPlainSocketImpl(this.channel);
    }

    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        try {
            this.impl.bind(new InetSocketAddress(inetAddress, n));
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    protected synchronized void create() throws SocketException {
        try {
            this.channel.initSocket(false);
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    protected void connect(InetAddress inetAddress, int n) throws SocketException {
        this.channel.connect(new InetSocketAddress(inetAddress, n), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        PlainDatagramSocketImpl plainDatagramSocketImpl = this;
        synchronized (plainDatagramSocketImpl) {
            try {
                if (this.channel.getState().isValid()) {
                    this.channel.disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected synchronized void setTimeToLive(int n) throws IOException {
        this.impl.setTimeToLive(n);
    }

    protected synchronized int getTimeToLive() throws IOException {
        return this.impl.getTimeToLive();
    }

    protected int getLocalPort() {
        if (this.channel == null) {
            return -1;
        }
        try {
            InetSocketAddress inetSocketAddress = this.channel.getLocalAddress();
            if (inetSocketAddress == null) {
                return -1;
            }
            return inetSocketAddress.getPort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(DatagramPacket datagramPacket) throws IOException {
        Object object = this.SEND_LOCK;
        synchronized (object) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            InetAddress inetAddress = datagramPacket.getAddress();
            int n = datagramPacket.getPort();
            if (inetAddress == null) {
                throw new NullPointerException();
            }
            if (n <= 0) {
                throw new SocketException("invalid port " + n);
            }
            while (true) {
                try {
                    this.channel.send(byteBuffer, new InetSocketAddress(inetAddress, n));
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(DatagramPacket datagramPacket) throws IOException {
        Object object = this.RECEIVE_LOCK;
        synchronized (object) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            SocketAddress socketAddress = null;
            while (true) {
                try {
                    socketAddress = this.channel.receive(byteBuffer);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw socketTimeoutException;
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
            if (socketAddress != null) {
                datagramPacket.setSocketAddress(socketAddress);
            }
            datagramPacket.setLength(byteBuffer.position() - datagramPacket.getOffset());
        }
    }

    public synchronized void setOption(int n, Object object) throws SocketException {
        switch (n) {
            case 16: 
            case 31: {
                this.impl.setMulticastInterface(n, (InetAddress)object);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 18: 
            case 32: 
            case 128: 
            case 4097: 
            case 4098: 
            case 4099: 
            case 4102: {
                this.impl.setOption(n, object);
                return;
            }
            default: {
                throw new SocketException("cannot set option " + n);
            }
        }
    }

    public synchronized Object getOption(int n) throws SocketException {
        if (n == 15) {
            try {
                InetSocketAddress inetSocketAddress = this.channel.getLocalAddress();
                if (inetSocketAddress == null) {
                    return null;
                }
                return inetSocketAddress.getAddress();
            }
            catch (SocketException socketException) {
                throw socketException;
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException();
                socketException.initCause(iOException);
                throw socketException;
            }
        }
        if (n == 16 || n == 31) {
            return this.impl.getMulticastInterface(n);
        }
        return this.impl.getOption(n);
    }

    protected synchronized void close() {
        try {
            if (this.channel.getState().isValid()) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected synchronized byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    protected synchronized void setTTL(byte by) throws IOException {
        this.setTimeToLive(by & 0xFF);
    }

    protected synchronized void join(InetAddress inetAddress) throws IOException {
        this.impl.join(inetAddress);
    }

    protected synchronized void leave(InetAddress inetAddress) throws IOException {
        this.impl.leave(inetAddress);
    }

    protected synchronized int peek(InetAddress inetAddress) throws IOException {
        throw new IOException("Not Implemented Yet");
    }

    public int peekData(DatagramPacket datagramPacket) {
        throw new InternalError("PlainDatagramSocketImpl::peekData is not implemented");
    }

    public void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("unknown address type");
        }
        this.impl.joinGroup((InetSocketAddress)socketAddress, networkInterface);
    }

    public void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("unknown address type");
        }
        this.impl.leaveGroup((InetSocketAddress)socketAddress, networkInterface);
    }
}

