/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMThreadMXBeanImpl;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.NotCompliantMBeanException;

public final class ThreadMXBeanImpl
extends BeanImpl
implements ThreadMXBean {
    private static final String CURRENT_THREAD_TIME_SUPPORT = "gnu.java.lang.management.CurrentThreadTimeSupport";
    private static final String THREAD_TIME_SUPPORT = "gnu.java.lang.management.ThreadTimeSupport";
    private static final String CONTENTION_SUPPORT = "gnu.java.lang.management.ThreadContentionSupport";
    private static final String TIME_ENABLED = "gnu.java.lang.management.ThreadTimeInitallyEnabled";
    private static final String MONITOR_SUPPORT = "gnu.java.lang.management.MonitorUsageMonitoringSupport";
    private static final String SYNCHRONIZER_SUPPORT = "gnu.java.lang.management.OwnableSynchronizerUsageMonitoringSupport";
    private boolean timeEnabled = Boolean.parseBoolean(SystemProperties.getProperty("gnu.java.lang.management.ThreadTimeInitallyEnabled"));
    private boolean contentionEnabled = false;

    public ThreadMXBeanImpl() throws NotCompliantMBeanException {
        super((Class)ThreadMXBean.class);
    }

    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2) {
        return this.getThreadInfo(this.getAllThreadIds(), bl, bl2);
    }

    public long[] findDeadlockedThreads() {
        this.checkMonitorPermissions();
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Ownable synchronizer usage monitoring is not provided by this VM.");
        }
        return VMThreadMXBeanImpl.findDeadlockedThreads();
    }

    public long[] findMonitorDeadlockedThreads() {
        this.checkMonitorPermissions();
        return VMThreadMXBeanImpl.findMonitorDeadlockedThreads();
    }

    public long[] getAllThreadIds() {
        this.checkMonitorPermissions();
        return VMThreadMXBeanImpl.getAllThreadIds();
    }

    public long getCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time not supported.");
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getCurrentThreadCpuTime();
    }

    public long getCurrentThreadUserTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread user time not supported.");
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getCurrentThreadUserTime();
    }

    public int getDaemonThreadCount() {
        return VMThreadMXBeanImpl.getDaemonThreadCount();
    }

    public int getPeakThreadCount() {
        return VMThreadMXBeanImpl.getPeakThreadCount();
    }

    public int getThreadCount() {
        return VMThreadMXBeanImpl.getThreadCount();
    }

    public long getThreadCpuTime(long l) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time not supported.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread id: " + l);
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getThreadCpuTime(l);
    }

    public ThreadInfo getThreadInfo(long l) {
        return this.getThreadInfo(l, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    public ThreadInfo getThreadInfo(long l, int n) {
        this.checkMonitorPermissions();
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread id: " + l);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid depth: " + n);
        }
        return VMThreadMXBeanImpl.getThreadInfoForId(l, n);
    }

    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        this.checkMonitorPermissions();
        if (n < 0) {
            throw new IllegalArgumentException("Invalid depth: " + n);
        }
        ThreadInfo[] threadInfoArray = new ThreadInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0L) {
                throw new IllegalArgumentException("Invalid thread id " + i + ": " + lArray[i]);
            }
            threadInfoArray[i] = VMThreadMXBeanImpl.getThreadInfoForId(lArray[i], n);
        }
        return threadInfoArray;
    }

    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2) {
        this.checkMonitorPermissions();
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitor usage monitoring is not provided by this VM.");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Ownable synchronizer usage monitoring is not provided by this VM.");
        }
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, Integer.MAX_VALUE);
        if (bl) {
            for (ThreadInfo threadInfo : threadInfoArray) {
                VMThreadMXBeanImpl.getMonitorInfo(threadInfo);
            }
        }
        if (bl2) {
            for (ThreadInfo threadInfo : threadInfoArray) {
                VMThreadMXBeanImpl.getLockInfo(threadInfo);
            }
        }
        return threadInfoArray;
    }

    public long getThreadUserTime(long l) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread user time not supported.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread id: " + l);
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getThreadUserTime(l);
    }

    public long getTotalStartedThreadCount() {
        return VMThreadMXBeanImpl.getTotalStartedThreadCount();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        if (this.isThreadCpuTimeSupported()) {
            return true;
        }
        return SystemProperties.getProperty(CURRENT_THREAD_TIME_SUPPORT) != null;
    }

    public boolean isObjectMonitorUsageSupported() {
        return SystemProperties.getProperty(MONITOR_SUPPORT) != null;
    }

    public boolean isSynchronizerUsageSupported() {
        return SystemProperties.getProperty(SYNCHRONIZER_SUPPORT) != null;
    }

    public boolean isThreadContentionMonitoringEnabled() {
        if (this.isThreadContentionMonitoringSupported()) {
            return this.contentionEnabled;
        }
        throw new UnsupportedOperationException("Contention monitoring not supported.");
    }

    public boolean isThreadContentionMonitoringSupported() {
        return SystemProperties.getProperty(CONTENTION_SUPPORT) != null;
    }

    public boolean isThreadCpuTimeEnabled() {
        if (this.isThreadCpuTimeSupported() || this.isCurrentThreadCpuTimeSupported()) {
            return this.timeEnabled;
        }
        throw new UnsupportedOperationException("Thread time not supported.");
    }

    public boolean isThreadCpuTimeSupported() {
        return SystemProperties.getProperty(THREAD_TIME_SUPPORT) != null;
    }

    public void resetPeakThreadCount() {
        this.checkControlPermissions();
        VMThreadMXBeanImpl.resetPeakThreadCount();
    }

    public void setThreadContentionMonitoringEnabled(boolean bl) {
        this.checkControlPermissions();
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Contention monitoring not supported.");
        }
        this.contentionEnabled = bl;
    }

    public void setThreadCpuTimeEnabled(boolean bl) {
        this.checkControlPermissions();
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread time not supported.");
        }
        this.timeEnabled = bl;
    }
}

