/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang;

import gnu.classpath.SystemProperties;
import gnu.java.lang.VMCPStringBuilder;
import java.io.Serializable;

public final class CPStringBuilder
implements Serializable,
CharSequence,
Appendable {
    private int count;
    private char[] value;
    private boolean allocated = false;
    private static final int DEFAULT_CAPACITY;

    public CPStringBuilder() {
        this(DEFAULT_CAPACITY);
    }

    public CPStringBuilder(int n) {
        this.value = new char[n];
    }

    public CPStringBuilder(String string) {
        this.count = string.length();
        this.value = new char[this.count + DEFAULT_CAPACITY];
        string.getChars(0, this.count, this.value, 0);
    }

    public CPStringBuilder(StringBuffer stringBuffer) {
        this.count = stringBuffer.length();
        this.value = new char[this.count + DEFAULT_CAPACITY];
        stringBuffer.getChars(0, this.count, this.value, 0);
    }

    public CPStringBuilder(StringBuilder stringBuilder) {
        this.count = stringBuilder.length();
        this.value = new char[this.count + DEFAULT_CAPACITY];
        stringBuilder.getChars(0, this.count, this.value, 0);
    }

    public CPStringBuilder(CharSequence charSequence) {
        int n = charSequence.length();
        this.count = n <= 0 ? 0 : n;
        this.value = new char[this.count + DEFAULT_CAPACITY];
        for (int i = 0; i < n; ++i) {
            this.value[i] = charSequence.charAt(i);
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = this.value.length;
        if (n > 0) {
            this.ensureCapacity(n);
        }
        if (n < n2) {
            this.count = n;
        } else {
            while (this.count < n) {
                this.value[this.count++] = '\u0000';
            }
        }
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public int codePointAt(int n) {
        return Character.codePointAt(this.value, n, this.count);
    }

    public int codePointBefore(int n) {
        if (n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBefore(this.value, n, 1);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n2 > this.count || n2 < n) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity(this.count);
        this.value[n] = c;
    }

    public CPStringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public CPStringBuilder append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = string.length();
        this.ensureCapacity(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPStringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n = stringBuffer.length();
            this.ensureCapacity(this.count + n);
            stringBuffer.getChars(0, n, this.value, this.count);
            this.count += n;
        }
        return this;
    }

    public CPStringBuilder append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public CPStringBuilder append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + n2);
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public CPStringBuilder append(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public CPStringBuilder append(char c) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public CPStringBuilder append(CharSequence charSequence) {
        return this.append(charSequence, 0, charSequence.length());
    }

    public CPStringBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return this.append("null");
        }
        if (n2 - n > 0) {
            this.ensureCapacity(this.count + n2 - n);
            while (n < n2) {
                this.value[this.count++] = charSequence.charAt(n);
                ++n;
            }
        }
        return this;
    }

    public CPStringBuilder append(int n) {
        return this.append(String.valueOf(n));
    }

    public CPStringBuilder append(long l) {
        return this.append(Long.toString(l, 10));
    }

    public CPStringBuilder append(float f) {
        return this.append(Float.toString(f));
    }

    public CPStringBuilder append(double d) {
        return this.append(Double.toString(d));
    }

    public CPStringBuilder appendCodePoint(int n) {
        int n2 = Character.charCount(n);
        this.ensureCapacity(this.count + n2);
        Character.toChars(n, this.value, this.count);
        this.count += n2;
        return this;
    }

    public CPStringBuilder delete(int n, int n2) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        this.ensureCapacity(this.count);
        if (this.count - n2 != 0) {
            System.arraycopy(this.value, n2, this.value, n, this.count - n2);
        }
        this.count -= n2 - n;
        return this;
    }

    public CPStringBuilder deleteCharAt(int n) {
        return this.delete(n, n + 1);
    }

    public CPStringBuilder replace(int n, int n2, String string) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n3 = string.length();
        int n4 = n3 - (n2 > this.count ? this.count : n2) + n;
        this.ensureCapacity(this.count + n4);
        if (n4 != 0 && n2 < this.count) {
            System.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        }
        string.getChars(0, n3, this.value, n);
        this.count += n4;
        return this;
    }

    public CPStringBuilder insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count || n3 < 0 || n2 < 0 || n2 > cArray.length - n3) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + n3);
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count += n3;
        return this;
    }

    public CPStringBuilder insert(int n, Object object) {
        return this.insert(n, object == null ? "null" : object.toString());
    }

    public CPStringBuilder insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.length();
        this.ensureCapacity(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public CPStringBuilder insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public CPStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n2 < 0 || n3 < 0 || n2 > n3 || n3 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        this.ensureCapacity(this.count + n4);
        System.arraycopy(this.value, n, this.value, n + n4, this.count - n);
        for (int i = n2; i < n3; ++i) {
            this.value[n++] = charSequence.charAt(i);
        }
        this.count += n4;
        return this;
    }

    public CPStringBuilder insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public CPStringBuilder insert(int n, boolean bl) {
        return this.insert(n, bl ? "true" : "false");
    }

    public CPStringBuilder insert(int n, char c) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public CPStringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public CPStringBuilder insert(int n, long l) {
        return this.insert(n, Long.toString(l, 10));
    }

    public CPStringBuilder insert(int n, float f) {
        return this.insert(n, Float.toString(f));
    }

    public CPStringBuilder insert(int n, double d) {
        return this.insert(n, Double.toString(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = string.length();
        int n3 = this.count - n2;
        String string2 = VMCPStringBuilder.toString(this.value, 0, this.count);
        while (n <= n3) {
            if (string2.regionMatches(n, string, 0, n2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count - string.length());
    }

    public int lastIndexOf(String string, int n) {
        String string2 = VMCPStringBuilder.toString(this.value, 0, this.count);
        int n2 = string.length();
        for (n = Math.min(n, this.count - string.length()); n >= 0; --n) {
            if (!string2.regionMatches(n, string, 0, n2)) continue;
            return n;
        }
        return -1;
    }

    public CPStringBuilder reverse() {
        this.ensureCapacity(this.count);
        int n = this.count >> 1;
        int n2 = this.count - n;
        while (--n >= 0) {
            char c = this.value[n];
            this.value[n] = this.value[n2];
            this.value[n2] = c;
            ++n2;
        }
        return this;
    }

    public void trimToSize() {
        int n = this.value.length - this.count;
        if (n < 20) {
            return;
        }
        if (n > 200 || n * 4 > this.value.length) {
            this.allocateArray(this.count);
        }
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 >= this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n < n2) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != n2 && n != n3 && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            ++n3;
        }
        return n3;
    }

    public int offsetByCodePoints(int n, int n2) {
        while (n2 > 0) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != this.count && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            --n2;
        }
        return n;
    }

    public void ensureCapacity(int n) {
        if (this.allocated || n > this.value.length) {
            int n2;
            n = n > this.value.length ? (n < (n2 = this.value.length * 2 + 2) ? n2 : n) : (n *= 2);
            this.allocateArray(n);
        }
    }

    private void allocateArray(int n) {
        char[] cArray = new char[n];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.allocated = false;
    }

    public int length() {
        return this.count;
    }

    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0 || n2 > this.count || n2 < n) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            return "";
        }
        this.allocated = true;
        return VMCPStringBuilder.toString(this.value, n, n3);
    }

    public String toString() {
        this.allocated = true;
        return VMCPStringBuilder.toString(this.value, 0, this.count);
    }

    static {
        String string = SystemProperties.getProperty("gnu.classpath.cpstringbuilder.capacity");
        DEFAULT_CAPACITY = string == null ? 32 : Integer.parseInt(string);
    }
}

