/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.io;

public class ObjectIdentityMap2Int {
    private static final int[] PRIMES = new int[]{31, 61, 127, 251, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final Object NIL = new Object();
    private Object[] objectTable;
    private int[] intTable;
    private int size = 0;
    private int cap = 0;
    private int limit = 0;

    public ObjectIdentityMap2Int() {
        this.alloc(0);
    }

    private void alloc(int n) {
        if (n >= PRIMES.length) {
            throw new InternalError("Hash table size overflow");
        }
        this.cap = n;
        int n2 = PRIMES[n];
        this.objectTable = new Object[n2];
        this.intTable = new int[n2];
        this.limit = n2 / 4 * 3;
        this.size = 0;
    }

    public void put(Object object, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("int argument must be postive: " + n);
        }
        object = object == null ? NIL : object;
        int n2 = this.slot(object);
        Object[] objectArray = this.objectTable;
        this.intTable[n2] = n;
        if (this.objectTable[n2] == null) {
            this.objectTable[n2] = object;
            ++this.size;
            if (this.size >= this.limit) {
                this.rehash();
            }
        }
    }

    private int slot(Object object) {
        int n;
        Object[] objectArray = this.objectTable;
        int n2 = System.identityHashCode(object);
        int n3 = n2 % (n = objectArray.length);
        n3 = n3 < 0 ? -n3 : n3;
        int n4 = 16 - (n2 & 0xF);
        Object object2 = objectArray[n3];
        while (object2 != null && object2 != object) {
            if ((n3 += n4) >= n) {
                n3 -= n;
            }
            object2 = objectArray[n3];
        }
        return n3;
    }

    private void rehash() {
        Object[] objectArray = this.objectTable;
        int[] nArray = this.intTable;
        this.alloc(this.cap + 1);
        for (int i = 0; i < objectArray.length; ++i) {
            this.put(objectArray[i], nArray[i]);
        }
    }

    public int get(Object object) {
        object = object == null ? NIL : object;
        int n = this.slot(object);
        return this.objectTable[n] == null ? -1 : this.intTable[n];
    }

    public void clear() {
        Object[] objectArray = this.objectTable;
        this.size = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
    }
}

