/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Writer;
import gnu.java.beans.encoder.elements.Element;
import java.beans.XMLEncoder;
import java.util.Iterator;
import java.util.Stack;

public class Root {
    private Stack parents = new Stack();
    private Element rootElement = this.current = new RootElement();
    private Element current;
    private boolean started;

    public void addChild(Element element) {
        this.current.addChild(element);
        this.parents.push(this.current);
        this.current = element;
    }

    public void end() {
        this.current = (Element)this.parents.pop();
    }

    public void deleteLast() {
        this.current = (Element)this.parents.pop();
        this.current.removeLast();
    }

    public void traverse(Writer writer) {
        if (!this.started) {
            writer.writePreamble();
            this.rootElement.writeStart(writer);
        }
        this.started = true;
        this.traverse(writer, this.rootElement.iterator());
        this.rootElement.clear();
        writer.flush();
    }

    public void close(Writer writer) {
        this.rootElement.writeEnd(writer);
        writer.close();
    }

    private void traverse(Writer writer, Iterator iterator) {
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.writeStart(writer);
            this.traverse(writer, element.iterator());
            element.writeEnd(writer);
            element.clear();
        }
    }

    static class RootElement
    extends Element {
        RootElement() {
        }

        public void writeStart(Writer writer) {
            writer.write("java", new String[]{"version", "class"}, new String[]{System.getProperty("java.version"), XMLEncoder.class.getName()}, false);
        }

        public void writeEnd(Writer writer) {
            writer.writeEnd(false);
        }
    }
}

