/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractObjectContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.MethodFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PropertyContext
extends AbstractObjectContext {
    private Object argument;
    private String propertyName;
    private String prefix = "get";
    private boolean methodCalled;

    PropertyContext(String string, String string2) {
        this.setId(string);
        this.propertyName = string2;
    }

    public void addParameterObject(Object object) throws AssemblyException {
        if (this.methodCalled) {
            throw new AssemblyException(new IllegalArgumentException("Cannot add parameter object when method was already called."));
        }
        if (this.argument != null) {
            throw new AssemblyException(new IllegalArgumentException("Property attribut allows zero or one argument only."));
        }
        this.argument = object;
        this.setStatement(true);
        this.prefix = "set";
    }

    public void notifyStatement(Context context) throws AssemblyException {
        Object[] objectArray;
        if (this.methodCalled) {
            return;
        }
        this.methodCalled = true;
        Object object = context.getResult();
        if (object == null) {
            throw new AssemblyException(new NullPointerException("No object to access property " + this.propertyName));
        }
        String string = this.prefix + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        if (this.argument != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.argument;
        } else {
            objectArray = null;
        }
        Object[] objectArray3 = objectArray;
        try {
            Method method = MethodFinder.getMethod(object.getClass(), string, objectArray3);
            this.setObject(method.invoke(object, objectArray3));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssemblyException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssemblyException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssemblyException(illegalAccessException);
        }
    }

    public Object endContext(Context context) throws AssemblyException {
        this.notifyStatement(context);
        return this.getResult();
    }

    public boolean subContextFailed() {
        return !this.methodCalled;
    }
}

