/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractCreatableObjectContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.MethodFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class MethodContext
extends AbstractCreatableObjectContext {
    private ArrayList arguments = new ArrayList();
    private String methodName;

    MethodContext(String string, String string2) {
        this.setId(string);
        this.setStatement(true);
        this.methodName = string2;
    }

    public void addParameterObjectImpl(Object object) {
        this.arguments.add(object);
    }

    protected Object createObject(Context context) throws AssemblyException {
        Object object = context.getResult();
        if (object == null) {
            throw new AssemblyException(new NullPointerException("No object to invoke method " + this.methodName));
        }
        Object[] objectArray = this.arguments.toArray();
        try {
            Method method = MethodFinder.getMethod(object.getClass(), this.methodName, objectArray);
            return method.invoke(object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssemblyException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssemblyException(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssemblyException(illegalAccessException);
        }
    }
}

