/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.ElementHandler;
import java.beans.ExceptionListener;
import org.xml.sax.Attributes;

abstract class AbstractElementHandler
implements ElementHandler {
    private Context context;
    private ElementHandler parent;
    private boolean hasFailed;
    private StringBuffer buffer = new StringBuffer();
    private boolean allowsSubelements;

    protected AbstractElementHandler(ElementHandler elementHandler, boolean bl) {
        this.parent = elementHandler;
        this.allowsSubelements = bl;
    }

    public final void start(Attributes attributes, ExceptionListener exceptionListener) {
        try {
            this.context = this.startElement(attributes, exceptionListener);
        }
        catch (AssemblyException assemblyException) {
            Throwable throwable = assemblyException.getCause();
            if (!(throwable instanceof Exception)) {
                throw new InternalError("Unexpected Throwable type in AssemblerException. Please file a bug report.");
            }
            exceptionListener.exceptionThrown((Exception)throwable);
            this.notifyContextFailed();
            return;
        }
    }

    protected abstract Context startElement(Attributes var1, ExceptionListener var2) throws AssemblyException;

    public final void end(ExceptionListener exceptionListener) {
        if (!this.hasFailed) {
            try {
                this.endElement(this.buffer.toString());
                if (this.context.isStatement()) {
                    this.parent.notifyStatement(exceptionListener);
                    if (this.parent.hasFailed()) {
                        return;
                    }
                }
                this.putObject(this.context.getId(), this.context.endContext(this.parent.getContext()));
                if (!this.context.isStatement()) {
                    this.parent.getContext().addParameterObject(this.context.getResult());
                }
            }
            catch (AssemblyException assemblyException) {
                Throwable throwable = assemblyException.getCause();
                if (!(throwable instanceof Exception)) {
                    throw (InternalError)new InternalError("Severe problem while decoding XML data.").initCause(throwable);
                }
                exceptionListener.exceptionThrown((Exception)throwable);
                this.notifyContextFailed();
            }
        }
    }

    public void notifyStatement(ExceptionListener exceptionListener) {
        try {
            if (this.context.isStatement()) {
                this.parent.notifyStatement(exceptionListener);
            }
            this.context.notifyStatement(this.parent.getContext());
        }
        catch (AssemblyException assemblyException) {
            Throwable throwable = assemblyException.getCause();
            if (!(throwable instanceof Exception)) {
                throw (InternalError)new InternalError("Severe problem while decoding XML data.").initCause(throwable);
            }
            exceptionListener.exceptionThrown((Exception)throwable);
            this.notifyContextFailed();
        }
    }

    public final void notifyContextFailed() {
        this.hasFailed = true;
        if (this.parent.getContext().subContextFailed()) {
            this.parent.notifyContextFailed();
        }
    }

    public final boolean hasFailed() {
        return this.hasFailed;
    }

    protected void endElement(String string) throws AssemblyException {
    }

    public final void characters(char[] cArray, int n, int n2) {
        this.buffer.append(cArray, n, n2);
    }

    public void putObject(String string, Object object) {
        if (string != null) {
            this.parent.putObject(string, object);
        }
    }

    public Object getObject(String string) throws AssemblyException {
        return string == null ? null : this.parent.getObject(string);
    }

    public Class instantiateClass(String string) throws ClassNotFoundException {
        return this.parent.instantiateClass(string);
    }

    public final boolean isSubelementAllowed(String string) {
        return this.allowsSubelements && !string.equals("java");
    }

    public final Context getContext() {
        return this.context;
    }

    public final ElementHandler getParent() {
        return this.parent;
    }
}

