/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.print;

import gnu.java.awt.print.PostScriptGraphics2D;
import gnu.java.awt.print.SpooledDocument;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.CancelablePrintJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.RequestingUserName;

public class JavaPrinterJob
extends PrinterJob {
    private PrintService printer = null;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private static PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.POSTSCRIPT, null);
    private DocPrintJob printJob;
    private Printable printable;
    private PageFormat pageFormat;
    private Pageable pageable = null;
    private boolean cancelled = false;
    private static final Class copyClass = new Copies(1).getClass();
    private static final Class jobNameClass = new JobName("", null).getClass();
    private static final Class userNameClass = new RequestingUserName("", null).getClass();

    public JavaPrinterJob() {
        this.setCopies(1);
        this.setJobName("Java Printing");
        this.pageFormat = new PageFormat();
    }

    private void getPageAttributes() {
        OrientationRequested orientationRequested = (OrientationRequested)this.attributes.get(OrientationRequested.LANDSCAPE.getCategory());
        if (orientationRequested == null) {
            return;
        }
        if (orientationRequested.equals(OrientationRequested.PORTRAIT)) {
            this.pageFormat.setOrientation(1);
        } else if (orientationRequested.equals(OrientationRequested.LANDSCAPE)) {
            this.pageFormat.setOrientation(0);
        } else if (orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE)) {
            this.pageFormat.setOrientation(2);
        }
    }

    public int getCopies() {
        return ((IntegerSyntax)((Object)this.attributes.get(jobNameClass))).getValue();
    }

    public void setCopies(int n) {
        this.attributes.add(new Copies(n));
    }

    public String getJobName() {
        return ((TextSyntax)((Object)this.attributes.get(jobNameClass))).getValue();
    }

    public void setJobName(String string) {
        this.attributes.add(new JobName(string, Locale.getDefault()));
    }

    public String getUserName() {
        return ((TextSyntax)((Object)this.attributes.get(userNameClass))).getValue();
    }

    public void cancel() {
        try {
            if (this.printJob != null && this.printJob instanceof CancelablePrintJob) {
                ((CancelablePrintJob)this.printJob).cancel();
                this.cancelled = true;
            }
        }
        catch (PrintException printException) {
            // empty catch block
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return new PageFormat();
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        return this.defaultPage(null);
    }

    public void print() throws PrinterException {
        if (this.printable == null && this.pageable == null) {
            return;
        }
        PostScriptGraphics2D postScriptGraphics2D = new PostScriptGraphics2D(this);
        SpooledDocument spooledDocument = postScriptGraphics2D.spoolPostScript(this.printable, this.pageFormat, this.pageable);
        this.cancelled = false;
        this.printJob = this.printer.createPrintJob();
        try {
            this.printJob.print(spooledDocument, this.attributes);
        }
        catch (PrintException printException) {
            PrinterException printerException = new PrinterException();
            printerException.initCause(printException);
            throw printerException;
        }
        this.printJob = null;
    }

    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        this.attributes = printRequestAttributeSet;
        this.print();
    }

    public boolean printDialog() throws HeadlessException {
        return this.printDialog(this.attributes);
    }

    public boolean printDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        PrintService printService = ServiceUI.printDialog(null, 50, 50, services, null, DocFlavor.INPUT_STREAM.POSTSCRIPT, printRequestAttributeSet);
        this.getPageAttributes();
        if (printService != null) {
            try {
                this.setPrintService(printService);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void setPageable(Pageable pageable) {
        if (pageable == null) {
            throw new NullPointerException("Pageable cannot be null.");
        }
        this.pageable = pageable;
    }

    public void setPrintable(Printable printable) {
        this.printable = printable;
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.printable = printable;
        this.pageFormat = pageFormat;
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        return pageFormat;
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        if (!printService.isDocFlavorSupported(DocFlavor.INPUT_STREAM.POSTSCRIPT)) {
            throw new PrinterException("This printer service is not supported.");
        }
        this.printer = printService;
    }
}

