/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextAreaPeer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;

public class SwingTextAreaPeer
extends SwingComponentPeer
implements TextAreaPeer {
    private SwingTextArea jTextArea = new SwingTextArea();

    public SwingTextAreaPeer(TextArea textArea) {
        SwingScrollPane swingScrollPane = new SwingScrollPane(this.jTextArea);
        this.init(textArea, swingScrollPane);
        JViewport jViewport = new JViewport(){

            public Image createImage(int n, int n2) {
                return SwingTextAreaPeer.this.awtComponent.createImage(n, n2);
            }
        };
        jViewport.setView(this.jTextArea);
        swingScrollPane.setViewport(jViewport);
        this.setText(textArea.getText());
        int n = textArea.getColumns();
        int n2 = textArea.getRows();
        if (n == 0 && n2 == 0) {
            n = 25;
            textArea.setColumns(n);
            n2 = 5;
            textArea.setRows(n2);
        }
        this.jTextArea.setColumns(n);
        this.jTextArea.setRows(n2);
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.jTextArea.getMinimumSize();
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.jTextArea.getPreferredSize();
    }

    public void insert(String string, int n) {
        this.jTextArea.insert(string, n);
    }

    public void insertText(String string, int n) {
        this.jTextArea.insert(string, n);
    }

    public Dimension minimumSize() {
        return this.jTextArea.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.jTextArea.getPreferredSize();
    }

    public Dimension minimumSize(int n, int n2) {
        return this.jTextArea.getMinimumSize();
    }

    public Dimension preferredSize(int n, int n2) {
        return this.jTextArea.getPreferredSize();
    }

    public void replaceRange(String string, int n, int n2) {
        this.jTextArea.replaceRange(string, n, n2);
    }

    public void replaceText(String string, int n, int n2) {
        this.jTextArea.replaceRange(string, n, n2);
    }

    public long filterEvents(long l) {
        return 0L;
    }

    public int getCaretPosition() {
        return this.jTextArea.getCaretPosition();
    }

    public Rectangle getCharacterBounds(int n) {
        try {
            return this.jTextArea.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            Rectangle rectangle = null;
            return rectangle;
        }
    }

    public int getIndexAtPoint(int n, int n2) {
        return this.jTextArea.viewToModel(new Point(n, n2));
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public int getSelectionEnd() {
        return this.jTextArea.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.jTextArea.getSelectionStart();
    }

    public String getText() {
        return this.jTextArea.getText();
    }

    public void select(int n, int n2) {
        this.jTextArea.select(n, n2);
    }

    public void setCaretPosition(int n) {
        this.jTextArea.setCaretPosition(n);
    }

    public void setEditable(boolean bl) {
        this.jTextArea.setEditable(bl);
    }

    public void setText(String string) {
        this.jTextArea.setText(string);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
            this.swingComponent.getJComponent().validate();
        }
    }

    private class SwingTextArea
    extends JTextArea {
        private SwingTextArea() {
        }

        protected final void processComponentKeyEvent(KeyEvent keyEvent) {
            super.processComponentKeyEvent(keyEvent);
        }

        protected final void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
        }

        protected final void processComponentEvent(ComponentEvent componentEvent) {
            super.processComponentEvent(componentEvent);
        }

        protected final void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
        }

        protected final void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
            super.processHierarchyBoundsEvent(hierarchyEvent);
        }

        protected final void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
            super.processHierarchyEvent(hierarchyEvent);
        }

        protected final void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
            super.processInputMethodEvent(inputMethodEvent);
        }

        protected final void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
        }

        protected final void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
            super.processMouseWheelEvent(mouseWheelEvent);
        }

        protected final void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
        }

        public void requestFocus() {
            SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean bl) {
            return SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, bl, true, 0L);
        }
    }

    private class SwingScrollPane
    extends JScrollPane
    implements SwingComponent {
        SwingTextArea textArea;

        SwingScrollPane(SwingTextArea swingTextArea) {
            super(swingTextArea, 22, 32);
            this.textArea = swingTextArea;
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent mouseEvent) {
            JViewport jViewport = this.getViewport();
            if (jViewport.contains(mouseEvent.getPoint())) {
                mouseEvent.setSource(this.textArea);
                this.textArea.dispatchEvent(mouseEvent);
            } else {
                mouseEvent.setSource(this);
                this.dispatchEvent(mouseEvent);
            }
        }

        public boolean isLightweight() {
            return false;
        }

        public void handleMouseMotionEvent(MouseEvent mouseEvent) {
            this.textArea.processMouseMotionEvent(mouseEvent);
        }

        public void handleKeyEvent(KeyEvent keyEvent) {
            this.textArea.processKeyEvent(keyEvent);
        }

        public void handleFocusEvent(FocusEvent focusEvent) {
            this.textArea.processFocusEvent(focusEvent);
        }

        public Point getLocationOnScreen() {
            return SwingTextAreaPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean bl = false;
            if (SwingTextAreaPeer.this.awtComponent != null) {
                bl = SwingTextAreaPeer.this.awtComponent.isShowing();
            }
            return bl;
        }

        public Image createImage(int n, int n2) {
            return SwingTextAreaPeer.this.createImage(n, n2);
        }

        public Graphics getGraphics() {
            return SwingTextAreaPeer.this.getGraphics();
        }

        public Container getParent() {
            Container container = null;
            if (SwingTextAreaPeer.this.awtComponent != null) {
                container = SwingTextAreaPeer.this.awtComponent.getParent();
            }
            return container;
        }

        public void requestFocus() {
            SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean bl) {
            return SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, bl, true, 0L);
        }
    }
}

