/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ListPeer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class SwingListPeer
extends SwingComponentPeer
implements ListPeer {
    private JList jList;
    private DefaultListModel listModel = new DefaultListModel();

    public SwingListPeer(List list2) {
        this.jList = new JList(this.listModel);
        SwingList swingList = new SwingList(this.jList);
        this.init(list2, swingList);
        String[] stringArray = list2.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addItem(stringArray[i], i);
        }
    }

    public void add(String string, int n) {
        if (this.listModel != null) {
            this.listModel.add(n, string);
        }
    }

    public void addItem(String string, int n) {
        if (this.listModel != null) {
            this.listModel.add(n, string);
        }
    }

    public void clear() {
        if (this.listModel != null) {
            this.listModel.clear();
        }
    }

    public void delItems(int n, int n2) {
        if (this.listModel != null) {
            this.listModel.removeRange(n, n2);
        }
    }

    public void deselect(int n) {
        if (this.jList != null) {
            this.jList.getSelectionModel().removeSelectionInterval(n, n);
        }
    }

    public Dimension getMinimumSize(int n) {
        Dimension dimension = null;
        if (this.jList != null) {
            dimension = this.jList.getComponent(n).getMinimumSize();
        }
        return dimension;
    }

    public Dimension getPreferredSize(int n) {
        Dimension dimension = null;
        if (this.jList != null) {
            dimension = this.jList.getComponent(n).getPreferredSize();
        }
        return dimension;
    }

    public int[] getSelectedIndexes() {
        int[] nArray = null;
        if (this.jList != null) {
            nArray = this.jList.getSelectedIndices();
        }
        return nArray;
    }

    public void makeVisible(int n) {
        if (this.jList != null) {
            Component component = this.jList.getComponent(n);
            this.jList.scrollRectToVisible(component.getBounds());
        }
    }

    public Dimension minimumSize(int n) {
        Dimension dimension = null;
        if (this.jList != null) {
            dimension = this.jList.getComponent(n).getMinimumSize();
        }
        return dimension;
    }

    public Dimension preferredSize(int n) {
        Dimension dimension = null;
        if (this.jList != null) {
            dimension = this.jList.getComponent(n).getPreferredSize();
        }
        return dimension;
    }

    public void removeAll() {
        if (this.jList != null) {
            this.jList.removeAll();
        }
    }

    public void select(int n) {
        if (this.jList != null) {
            this.jList.setSelectedIndex(n);
        }
    }

    public void setMultipleMode(boolean bl) {
        if (this.jList != null) {
            this.jList.setSelectionMode(bl ? 2 : 0);
        }
    }

    public void setMultipleSelections(boolean bl) {
        if (this.jList != null) {
            this.jList.setSelectionMode(bl ? 2 : 0);
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
            this.swingComponent.getJComponent().validate();
        }
    }

    protected void peerPaint(Graphics graphics, boolean bl) {
        super.peerPaint(graphics, bl);
        this.jList.doLayout();
        this.jList.list();
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.RED);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private class SwingList
    extends JScrollPane
    implements SwingComponent {
        SwingList(Component component) {
            super(component, 22, 32);
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent mouseEvent) {
            mouseEvent.setSource(this);
            this.dispatchEvent(mouseEvent);
        }

        public boolean isLightweight() {
            return false;
        }

        public void handleMouseMotionEvent(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        public void handleKeyEvent(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent);
        }

        public void handleFocusEvent(FocusEvent focusEvent) {
            this.processFocusEvent(focusEvent);
        }

        public Point getLocationOnScreen() {
            return SwingListPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean bl = false;
            if (SwingListPeer.this.awtComponent != null) {
                bl = SwingListPeer.this.awtComponent.isShowing();
            }
            return bl;
        }

        public Image createImage(int n, int n2) {
            return SwingListPeer.this.createImage(n, n2);
        }

        public Graphics getGraphics() {
            return SwingListPeer.this.getGraphics();
        }

        public Container getParent() {
            Container container = null;
            if (SwingListPeer.this.awtComponent != null) {
                container = SwingListPeer.this.awtComponent.getParent();
            }
            return container;
        }
    }
}

