/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.classpath.SystemProperties;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.LinkedList;

public class SwingContainerPeer
extends SwingComponentPeer
implements ContainerPeer {
    private LinkedList heavyweightDescendents = new LinkedList();
    private Image backbuffer;
    private Component focusOwner = null;

    public SwingContainerPeer(Container container) {
    }

    protected synchronized void addHeavyweightDescendent(Component component) {
        this.heavyweightDescendents.add(component);
        this.focusOwner = null;
    }

    protected synchronized void removeHeavyweightDescendent(Component component) {
        this.heavyweightDescendents.remove(component);
        this.focusOwner = null;
    }

    protected Component[] getHeavyweightDescendents() {
        Component[] componentArray = new Component[this.heavyweightDescendents.size()];
        componentArray = this.heavyweightDescendents.toArray((S[])componentArray);
        return componentArray;
    }

    public Insets insets() {
        Insets insets = this.swingComponent != null ? this.swingComponent.getJComponent().getInsets() : new Insets(0, 0, 0, 0);
        return insets;
    }

    public Insets getInsets() {
        return this.insets();
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public void beginLayout() {
    }

    public void endLayout() {
    }

    public boolean isPaintPending() {
        return false;
    }

    public boolean isRestackSupported() {
        return false;
    }

    public void cancelPendingPaint(int n, int n2, int n3, int n4) {
    }

    public void restack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void peerPaint(Graphics graphics, boolean bl) {
        if (this.isDoubleBuffering()) {
            int n = this.awtComponent.getWidth();
            int n2 = this.awtComponent.getHeight();
            if (this.backbuffer == null || this.backbuffer.getWidth(this.awtComponent) < n || this.backbuffer.getHeight(this.awtComponent) < n2) {
                this.backbuffer = this.awtComponent.createImage(n, n2);
            }
            Graphics graphics2 = this.backbuffer.getGraphics();
            Rectangle rectangle = graphics.getClipRect();
            try {
                graphics2.setClip(rectangle);
                super.peerPaint(graphics2, bl);
                this.peerPaintChildren(graphics2);
                Object var8_7 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                graphics2.dispose();
                throw throwable;
            }
            graphics.drawImage(this.backbuffer, 0, 0, this.awtComponent);
        } else {
            super.peerPaint(graphics, bl);
            this.peerPaintChildren(graphics);
        }
    }

    private boolean isDoubleBuffering() {
        String string = SystemProperties.getProperty("gnu.awt.swing.doublebuffering", "false");
        return string.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void peerPaintChildren(Graphics graphics) {
        for (Component component : this.heavyweightDescendents) {
            Object var7_6;
            ComponentPeer componentPeer = component.getPeer();
            if (!(componentPeer instanceof SwingComponentPeer) || !component.isVisible()) continue;
            Graphics graphics2 = graphics.create(component.getX(), component.getY(), component.getWidth(), component.getHeight());
            try {
                ((SwingComponentPeer)componentPeer).peerPaint(graphics2, false);
                var7_6 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                var7_6 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        Component component = this.awtComponent.getComponentAt(mouseEvent.getPoint());
        if (component == null) {
            component = this.awtComponent;
        }
        ComponentPeer componentPeer = component.getPeer();
        if (this.awtComponent != component && !component.isLightweight() && componentPeer instanceof SwingComponentPeer) {
            mouseEvent.translatePoint(component.getX(), component.getY());
            mouseEvent.setSource(component);
            ((SwingComponentPeer)componentPeer).handleMouseEvent(mouseEvent);
        }
    }

    protected void handleMouseMotionEvent(MouseEvent mouseEvent) {
        Component component = this.awtComponent.getComponentAt(mouseEvent.getPoint());
        if (component != null) {
            ComponentPeer componentPeer = component.getPeer();
            if (this.awtComponent != component && !component.isLightweight() && componentPeer instanceof SwingComponentPeer) {
                mouseEvent.translatePoint(component.getX(), component.getY());
                ((SwingComponentPeer)componentPeer).handleMouseMotionEvent(mouseEvent);
            }
        }
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        Component component = this.getFocusOwner();
        if (component != null) {
            component.getPeer().handleEvent(keyEvent);
        } else {
            super.handleKeyEvent(keyEvent);
        }
    }

    private Component getFocusOwner() {
        if (this.focusOwner == null) {
            for (Component component : this.heavyweightDescendents) {
                if (!component.isFocusable()) continue;
                this.focusOwner = component;
                break;
            }
        }
        return this.focusOwner;
    }
}

