/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.CheckboxPeer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

public class SwingCheckboxPeer
extends SwingComponentPeer
implements CheckboxPeer {
    public SwingCheckboxPeer(Checkbox checkbox) {
        SwingCheckbox swingCheckbox = new SwingCheckbox(checkbox);
        swingCheckbox.addItemListener(new SwingCheckboxListener(checkbox));
        this.init(checkbox, swingCheckbox);
        this.setLabel(checkbox.getLabel());
        this.setState(checkbox.getState());
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
    }

    public void setLabel(String string) {
        ((JToggleButton)((Object)this.swingComponent)).setText(string);
    }

    public void setState(boolean bl) {
        ((JToggleButton)((Object)this.swingComponent)).setSelected(bl);
    }

    class SwingCheckboxListener
    implements ItemListener {
        Checkbox awtCheckbox;

        SwingCheckboxListener(Checkbox checkbox) {
            this.awtCheckbox = checkbox;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.awtCheckbox.setState(itemEvent.getStateChange() == 1);
            ItemListener[] itemListenerArray = this.awtCheckbox.getItemListeners();
            if (itemListenerArray.length == 0) {
                return;
            }
            ItemEvent itemEvent2 = new ItemEvent(this.awtCheckbox, 701, this.awtCheckbox, itemEvent.getStateChange());
            for (int i = 0; i < itemListenerArray.length; ++i) {
                itemListenerArray[i].itemStateChanged(itemEvent2);
            }
        }
    }

    private class SwingCheckbox
    extends JCheckBox
    implements SwingComponent {
        Checkbox checkbox;

        SwingCheckbox(Checkbox checkbox) {
            this.checkbox = checkbox;
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent mouseEvent) {
            mouseEvent.setSource(this);
            this.processMouseEvent(mouseEvent);
        }

        public void handleMouseMotionEvent(MouseEvent mouseEvent) {
            mouseEvent.setSource(this);
            this.processMouseMotionEvent(mouseEvent);
        }

        public void handleKeyEvent(KeyEvent keyEvent) {
            keyEvent.setSource(this);
            this.processKeyEvent(keyEvent);
        }

        public void handleFocusEvent(FocusEvent focusEvent) {
            this.processFocusEvent(focusEvent);
        }

        public Point getLocationOnScreen() {
            return SwingCheckboxPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean bl = false;
            if (this.checkbox != null) {
                bl = this.checkbox.isShowing();
            }
            return bl;
        }

        public Image createImage(int n, int n2) {
            return SwingCheckboxPeer.this.createImage(n, n2);
        }

        public Graphics getGraphics() {
            return SwingCheckboxPeer.this.getGraphics();
        }

        public Container getParent() {
            Container container = null;
            if (this.checkbox != null) {
                container = this.checkbox.getParent();
            }
            return container;
        }

        public void requestFocus() {
            SwingCheckboxPeer.this.requestFocus(SwingCheckboxPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean bl) {
            return SwingCheckboxPeer.this.requestFocus(SwingCheckboxPeer.this.awtComponent, bl, true, 0L);
        }
    }
}

