/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Button;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ButtonPeer;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SwingButtonPeer
extends SwingComponentPeer
implements ButtonPeer {
    public SwingButtonPeer(Button button) {
        SwingButton swingButton = new SwingButton(button);
        swingButton.setText(button.getLabel());
        swingButton.addActionListener(new SwingButtonListener());
        this.init(button, swingButton);
    }

    public void setLabel(String string) {
        ((SwingButton)this.swingComponent).setText(string);
    }

    class SwingButtonListener
    implements ActionListener {
        SwingButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Button button = (Button)SwingButtonPeer.this.awtComponent;
            ActionListener[] actionListenerArray = button.getActionListeners();
            if (actionListenerArray.length == 0) {
                return;
            }
            ActionEvent actionEvent2 = new ActionEvent(button, 1001, button.getActionCommand());
            for (int i = 0; i < actionListenerArray.length; ++i) {
                actionListenerArray[i].actionPerformed(actionEvent2);
            }
        }
    }

    class SwingButton
    extends JButton
    implements SwingComponent {
        Button button;

        SwingButton(Button button) {
            this.button = button;
        }

        public Point getLocationOnScreen() {
            return SwingButtonPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean bl = false;
            if (this.button != null) {
                bl = this.button.isShowing();
            }
            return bl;
        }

        public Image createImage(int n, int n2) {
            return SwingButtonPeer.this.createImage(n, n2);
        }

        public Graphics getGraphics() {
            return SwingButtonPeer.this.getGraphics();
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent mouseEvent) {
            mouseEvent.setSource(this);
            this.processMouseEvent(mouseEvent);
        }

        public void handleMouseMotionEvent(MouseEvent mouseEvent) {
            mouseEvent.setSource(this);
            this.processMouseMotionEvent(mouseEvent);
        }

        public void handleKeyEvent(KeyEvent keyEvent) {
            keyEvent.setSource(this);
            this.processKeyEvent(keyEvent);
        }

        public Container getParent() {
            Container container = null;
            if (this.button != null) {
                container = this.button.getParent();
            }
            return container;
        }

        public void handleFocusEvent(FocusEvent focusEvent) {
            this.processFocusEvent(focusEvent);
        }

        public void requestFocus() {
            SwingButtonPeer.this.requestFocus(SwingButtonPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean bl) {
            return SwingButtonPeer.this.requestFocus(SwingButtonPeer.this.awtComponent, bl, true, 0L);
        }
    }
}

