/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QPainterPath;
import gnu.java.awt.peer.qt.QPen;
import gnu.java.awt.peer.qt.QtFontMetrics;
import gnu.java.awt.peer.qt.QtFontPeer;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QtGraphics
extends Graphics2D {
    protected long nativeObject;
    private static final AffineTransform identity = new AffineTransform();
    protected Font font;
    protected Color color;
    protected Color bgcolor;
    protected Shape clip;
    protected Shape initialClip;
    protected AffineTransform xform;
    protected Stroke currentStroke;
    protected boolean nativeStroking;
    protected Composite composite;
    protected double currentAlpha;
    protected Paint currentPaint;
    protected RenderingHints renderingHints;
    Graphics parent;

    QtGraphics() {
    }

    QtGraphics(QtGraphics qtGraphics) {
        this.cloneNativeContext(qtGraphics);
        this.setFont(qtGraphics.getFont());
        this.setAlpha(qtGraphics.currentAlpha);
        this.setBackground(qtGraphics.getBackground());
        this.setColor(qtGraphics.getColor());
        this.initialClip = qtGraphics.getClip();
        this.setClip(this.initialClip);
        this.setTransform(qtGraphics.getTransform());
        this.setStroke(qtGraphics.getStroke());
        this.setComposite(qtGraphics.getComposite());
        this.setPaint(qtGraphics.getPaint());
        this.setRenderingHints(qtGraphics.getRenderingHints());
    }

    protected void setup() {
        this.font = new Font("Dialog", 0, 12);
        this.setTransform(identity);
        this.setStroke(new BasicStroke());
        this.renderingHints = new RenderingHints(null);
    }

    public synchronized native void delete();

    @Override
    public void dispose() {
    }

    private void resetClip() {
        AffineTransform affineTransform = this.getTransform();
        this.setTransform(identity);
        this.setClip(this.initialClip);
        this.setTransform(affineTransform);
    }

    protected native void initImage(QtImage var1);

    protected native void initVolatileImage(QtVolatileImage var1);

    private native void cloneNativeContext(QtGraphics var1);

    private native void setColor(int var1, int var2, int var3, int var4);

    private native void drawNative(QPainterPath var1);

    private native void fillNative(QPainterPath var1);

    private native void setClipNative(QPainterPath var1);

    private native void setClipRectNative(int var1, int var2, int var3, int var4);

    private native void intersectClipNative(QPainterPath var1);

    private native void intersectClipRectNative(int var1, int var2, int var3, int var4);

    private native void setQtTransform(QMatrix var1);

    private native void setNativeStroke(QPen var1);

    private native void setNativeComposite(int var1);

    private native void drawStringNative(String var1, double var2, double var4);

    private native void setLinearGradient(int var1, int var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, boolean var15);

    private native void setAlphaNative(double var1);

    private native void setFontNative(QtFontPeer var1);

    private native QPainterPath getClipNative();

    void setAlpha(double d) {
        this.currentAlpha = d;
        this.setAlphaNative(this.currentAlpha);
    }

    @Override
    public abstract Graphics create();

    @Override
    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    @Override
    public abstract GraphicsConfiguration getDeviceConfiguration();

    @Override
    public Color getColor() {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            color = Color.white;
        }
        this.color = color;
        int n = (int)((double)color.getAlpha() * this.currentAlpha);
        this.setColor(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    @Override
    public void setBackground(Color color) {
        this.bgcolor = new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Color getBackground() {
        return new Color(this.bgcolor.getRed(), this.bgcolor.getGreen(), this.bgcolor.getBlue());
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            Shape shape2 = this.currentStroke.createStrokedShape(shape);
            return shape2.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return shape.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
        if (font.getPeer() != null && font.getPeer() instanceof QtFontPeer) {
            this.setFontNative((QtFontPeer)font.getPeer());
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return new QtFontMetrics(font, (Graphics)this);
    }

    @Override
    public void clip(Shape shape) {
        this.intersectClipNative(new QPainterPath(shape));
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.intersectClipRectNative(n, n2, n3, n4);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClipRectNative(n, n2, n3, n4);
    }

    @Override
    public Shape getClip() {
        return this.getClipNative().getPath();
    }

    @Override
    public native Rectangle getClipBounds();

    @Override
    public void setClip(Shape shape) {
        if (shape == null) {
            this.resetClip();
        } else {
            this.setClipNative(new QPainterPath(shape));
        }
    }

    @Override
    public void draw(Shape shape) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(shape));
        } else {
            this.fillNative(new QPainterPath(this.currentStroke.createStrokedShape(shape)));
        }
    }

    @Override
    public void fill(Shape shape) {
        this.fillNative(new QPainterPath(shape));
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(n, n2, n3, n4, true));
        } else {
            this.draw(new Line2D.Double(n, n2, n3, n4));
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(n, n2, n3, n4));
        } else {
            this.fillNative(new QPainterPath(this.currentStroke.createStrokedShape(new Rectangle2D.Double(n, n2, n3, n4))));
        }
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillNative(new QPainterPath(n, n2, n3, n4));
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.color;
        this.setColor(this.bgcolor);
        this.fillRect(n, n2, n3, n4);
        this.setColor(color);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Double(n, n2, n3, n4));
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Double(n, n2, n3, n4));
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 1));
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n - 1; ++i) {
            this.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
        }
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    @Override
    public native void fill3DRect(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public native void draw3DRect(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawStringNative(string, n, n2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.drawStringNative(string, f, f2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        String string = "";
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            string = string + c;
            c = attributedCharacterIterator.next();
        }
        this.drawString(string, n, n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        String string = "";
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            string = string + c;
            c = attributedCharacterIterator.next();
        }
        this.drawString(string, f, f2);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, new QMatrix(affineTransform), imageObserver);
        }
        return new QtImage(image.getSource()).drawImage(this, new QMatrix(affineTransform), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, n, n2, color, imageObserver);
        }
        return new QtImage(image.getSource()).drawImage(this, n, n2, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        return new QtImage(image.getSource()).drawImage(this, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, n, n2, n3, n4, color, imageObserver);
        }
        return new QtImage(image.getSource()).drawImage(this, n, n2, n3, n4, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.xform);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.xform = new AffineTransform(affineTransform);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void rotate(double d) {
        this.xform.rotate(d);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.xform.rotate(d, d2, d3);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void scale(double d, double d2) {
        this.xform.scale(d, d2);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void shear(double d, double d2) {
        this.xform.shear(d, d2);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.xform.concatenate(affineTransform);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void translate(double d, double d2) {
        this.xform.translate(d, d2);
        this.setQtTransform(new QMatrix(this.xform));
    }

    @Override
    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    @Override
    public void setStroke(Stroke stroke) {
        try {
            QPen qPen = new QPen(stroke);
            this.nativeStroking = true;
            this.setNativeStroke(qPen);
            this.setColor(this.color);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.nativeStroking = false;
        }
        this.currentStroke = stroke;
    }

    @Override
    public Stroke getStroke() {
        return this.currentStroke;
    }

    @Override
    public void setComposite(Composite composite) {
        if (composite == null) {
            this.setNativeComposite(3);
            return;
        }
        if (composite instanceof AlphaComposite) {
            if (((AlphaComposite)composite).getRule() != 12) {
                this.setAlpha(((AlphaComposite)composite).getAlpha());
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AWTPermission("readDisplayPixels"));
            }
            throw new UnsupportedOperationException("We don't support custom composites yet.");
        }
        this.setNativeComposite(((AlphaComposite)composite).getRule());
        this.composite = composite;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.currentPaint = paint;
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            this.setLinearGradient(gradientPaint.getColor1().getRed(), gradientPaint.getColor1().getGreen(), gradientPaint.getColor1().getBlue(), gradientPaint.getColor2().getRed(), gradientPaint.getColor2().getGreen(), gradientPaint.getColor2().getBlue(), gradientPaint.getPoint1().getX(), gradientPaint.getPoint1().getY(), gradientPaint.getPoint2().getX(), gradientPaint.getPoint2().getY(), gradientPaint.isCyclic());
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        throw new UnsupportedOperationException("We don't support custom paints yet.");
    }

    @Override
    public Paint getPaint() {
        return this.currentPaint;
    }

    public void addRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.putAll(map);
        this.updateRenderingHints();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
        this.updateRenderingHints();
    }

    private void updateRenderingHints() {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

