/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.ComponentGraphics;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class VolatileImageGraphics
extends ComponentGraphics {
    private GtkVolatileImage owner;
    private BufferedImage buffer;

    public VolatileImageGraphics(GtkVolatileImage gtkVolatileImage) {
        this.owner = gtkVolatileImage;
        this.cairo_t = this.initFromVolatile(this.owner.nativePointer);
        this.setup(this.cairo_t);
    }

    private VolatileImageGraphics(VolatileImageGraphics volatileImageGraphics) {
        this.owner = volatileImageGraphics.owner;
        this.cairo_t = this.initFromVolatile(this.owner.nativePointer);
        this.copy(volatileImageGraphics, this.cairo_t);
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.owner.copyArea(n, n2, n3, n4, n5, n6);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.owner.component == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        GraphicsConfiguration graphicsConfiguration = this.owner.component.getGraphicsConfiguration();
        return graphicsConfiguration;
    }

    public Graphics create() {
        return new VolatileImageGraphics(this);
    }

    public void draw(Shape shape) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(shape);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setColor(this.getColor());
            graphics2D.setStroke(this.getStroke());
            graphics2D.draw(shape);
            this.drawComposite(shape.getBounds2D(), null);
        }
    }

    public void fill(Shape shape) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(shape);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setColor(this.getColor());
            graphics2D.fill(shape);
            this.drawComposite(shape.getBounds2D(), null);
        }
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(glyphVector, f, f2);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setColor(this.getColor());
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            rectangle2D = new Rectangle2D.Double((double)f + rectangle2D.getX(), (double)f2 + rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.drawComposite(rectangle2D, null);
        }
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        Object object;
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            return super.drawImage(image, affineTransform, color, imageObserver);
        }
        if (!(image instanceof BufferedImage)) {
            object = image.getSource();
            if (object == null) {
                return false;
            }
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
        }
        object = (BufferedImage)image;
        Point2D point2D = new Point2D.Double(((BufferedImage)object).getMinX(), ((BufferedImage)object).getMinY());
        Point2D point2D2 = new Point2D.Double(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
        if (affineTransform != null) {
            point2D = affineTransform.transform(point2D, point2D);
            point2D2 = affineTransform.transform(point2D2, point2D2);
        }
        this.createBuffer();
        Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
        graphics2D.setRenderingHints(this.getRenderingHints());
        graphics2D.drawImage(image, affineTransform, imageObserver);
        return this.drawComposite(new Rectangle2D.Double((int)point2D.getX(), (int)point2D.getY(), (int)point2D2.getX(), (int)point2D2.getY()), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof GtkVolatileImage && (this.comp == null || this.comp instanceof AlphaComposite)) {
            this.owner.drawVolatile(((GtkVolatileImage)image).nativePointer, n, n2, ((GtkVolatileImage)image).width, ((GtkVolatileImage)image).height);
            return true;
        }
        return super.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (image instanceof GtkVolatileImage && (this.comp == null || this.comp instanceof AlphaComposite)) {
            this.owner.drawVolatile(((GtkVolatileImage)image).nativePointer, n, n2, n3, n4);
            return true;
        }
        return super.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.owner.width, this.owner.height);
    }

    private boolean drawComposite(Rectangle2D rectangle2D, ImageObserver imageObserver) {
        Rectangle rectangle = this.getClipBounds();
        Rectangle2D.intersect(rectangle2D, rectangle, rectangle2D);
        BufferedImage bufferedImage = this.buffer;
        if (!rectangle2D.equals(bufferedImage.getRaster().getBounds())) {
            bufferedImage = bufferedImage.getSubimage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        BufferedImage bufferedImage2 = this.owner.getSnapshot();
        double[] dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
        this.transform.transform(dArray, 0, dArray, 0, 2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        Rectangle2D.intersect(double_, this.getClipInDevSpace(), double_);
        bufferedImage2 = bufferedImage2.getSubimage((int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
        this.compCtx.compose(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage.getRaster());
        Composite composite = this.comp;
        this.comp = null;
        boolean bl = super.drawImage((Image)bufferedImage, AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY()), null, null);
        this.comp = composite;
        return bl;
    }

    private void createBuffer() {
        if (this.buffer == null) {
            WritableRaster writableRaster = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.owner.width, this.owner.height), new Point(0, 0));
            this.buffer = new BufferedImage(GtkVolatileImage.gdkColorModel, writableRaster, GtkVolatileImage.gdkColorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
    }

    protected ColorModel getNativeCM() {
        return CairoSurface.cairoCM_pre;
    }
}

