/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.AWTUtilities;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.EmbeddedWindow;
import gnu.java.awt.dnd.GtkMouseDragGestureRecognizer;
import gnu.java.awt.dnd.peer.gtk.GtkDragSourceContextPeer;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.EmbeddedWindowPeer;
import gnu.java.awt.peer.gtk.AsyncImage;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import gnu.java.awt.peer.gtk.GdkGraphicsEnvironment;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GdkRobotPeer;
import gnu.java.awt.peer.gtk.GtkButtonPeer;
import gnu.java.awt.peer.gtk.GtkCanvasPeer;
import gnu.java.awt.peer.gtk.GtkCheckboxMenuItemPeer;
import gnu.java.awt.peer.gtk.GtkCheckboxPeer;
import gnu.java.awt.peer.gtk.GtkChoicePeer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkCursor;
import gnu.java.awt.peer.gtk.GtkDialogPeer;
import gnu.java.awt.peer.gtk.GtkEmbeddedWindowPeer;
import gnu.java.awt.peer.gtk.GtkFileDialogPeer;
import gnu.java.awt.peer.gtk.GtkFramePeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkLabelPeer;
import gnu.java.awt.peer.gtk.GtkListPeer;
import gnu.java.awt.peer.gtk.GtkMainThread;
import gnu.java.awt.peer.gtk.GtkMenuBarPeer;
import gnu.java.awt.peer.gtk.GtkMenuItemPeer;
import gnu.java.awt.peer.gtk.GtkMenuPeer;
import gnu.java.awt.peer.gtk.GtkMouseInfoPeer;
import gnu.java.awt.peer.gtk.GtkPanelPeer;
import gnu.java.awt.peer.gtk.GtkPopupMenuPeer;
import gnu.java.awt.peer.gtk.GtkScrollPanePeer;
import gnu.java.awt.peer.gtk.GtkScrollbarPeer;
import gnu.java.awt.peer.gtk.GtkTextAreaPeer;
import gnu.java.awt.peer.gtk.GtkTextFieldPeer;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.IIORegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkToolkit
extends ClasspathToolkit {
    static final Object GTK_LOCK;
    private static EventQueue q;
    private static boolean initializedGlobalIDs;
    private LRUCache<Map, ClasspathFontPeer> fontCache = new LRUCache(50);
    private LRUCache<Object, Image> imageCache = new LRUCache(50);

    static native void gtkInit(int var0, Object var1);

    static native void gtkMain();

    static native void gtkQuit();

    private static native void initIDs();

    static synchronized void initializeGlobalIDs() {
        if (!initializedGlobalIDs) {
            GtkToolkit.initIDs();
            initializedGlobalIDs = true;
        }
    }

    @Override
    public native void beep();

    private native void getScreenSizeDimensions(int[] var1);

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        int n3 = 35;
        if (image instanceof GtkImage) {
            return ((GtkImage)image).checkImage(imageObserver);
        }
        if (image instanceof AsyncImage) {
            return ((AsyncImage)image).checkImage(imageObserver);
        }
        if (imageObserver != null) {
            imageObserver.imageUpdate(image, n3, -1, -1, image.getWidth(imageObserver), image.getHeight(imageObserver));
        }
        return n3;
    }

    static Image imageOrError(Image image) {
        if (image == null) {
            return GtkImage.getErrorImage();
        }
        return image;
    }

    @Override
    public Image createImage(String string) {
        BufferedImage bufferedImage;
        if (string.length() == 0) {
            return new GtkImage();
        }
        try {
            bufferedImage = CairoSurface.getBufferedImage(new GtkImage(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bufferedImage = null;
        }
        return GtkToolkit.imageOrError(bufferedImage);
    }

    @Override
    public Image createImage(URL uRL) {
        return new AsyncImage(uRL);
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        BufferedImage bufferedImage;
        if (imageProducer == null) {
            return null;
        }
        try {
            bufferedImage = CairoSurface.getBufferedImage(new GtkImage(imageProducer));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bufferedImage = null;
        }
        return GtkToolkit.imageOrError(bufferedImage);
    }

    @Override
    public Image createImage(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            bufferedImage = CairoSurface.getBufferedImage(new GtkImage(byArray2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bufferedImage = null;
        }
        return GtkToolkit.imageOrError(bufferedImage);
    }

    public ImageProducer createImageProducer(URL uRL) {
        return this.createImage(uRL).getSource();
    }

    @Override
    public ColorModel getColorModel() {
        return new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    }

    @Override
    public String[] getFontList() {
        return new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return ((GdkFontPeer)font.getPeer()).getFontMetrics(font);
    }

    @Override
    public Image getImage(String string) {
        if (this.imageCache.containsKey(string)) {
            return (Image)this.imageCache.get(string);
        }
        Image image = this.createImage(string);
        this.imageCache.put(string, image);
        return image;
    }

    @Override
    public Image getImage(URL uRL) {
        if (this.imageCache.containsKey(uRL)) {
            return (Image)this.imageCache.get(uRL);
        }
        Image image = this.createImage(uRL);
        this.imageCache.put(uRL, image);
        return image;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return null;
    }

    @Override
    public native int getScreenResolution();

    @Override
    public Dimension getScreenSize() {
        int[] nArray = new int[2];
        this.getScreenSizeDimensions(nArray);
        return new Dimension(nArray[0], nArray[1]);
    }

    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        return GtkClipboard.getClipboardInstance();
    }

    @Override
    public Clipboard getSystemSelection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        return GtkClipboard.getSelectionInstance();
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof GtkImage) {
            return (((GtkImage)image).checkImage(imageObserver) & 0x20) != 0;
        }
        if (image instanceof AsyncImage) {
            AsyncImage asyncImage = (AsyncImage)image;
            asyncImage.addObserver(imageObserver);
            return asyncImage.realImage != null;
        }
        return true;
    }

    @Override
    public native void sync();

    protected void setComponentState(Component component, GtkComponentPeer gtkComponentPeer) {
        if (component.getForeground() == null) {
            component.setForeground(gtkComponentPeer.getForeground());
        }
        if (component.getBackground() == null) {
            component.setBackground(gtkComponentPeer.getBackground());
        }
        if (!(component instanceof Window)) {
            gtkComponentPeer.setCursor(component.getCursor());
            Rectangle rectangle = component.getBounds();
            gtkComponentPeer.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            gtkComponentPeer.setVisible(component.isVisible());
        }
    }

    @Override
    protected ButtonPeer createButton(Button button) {
        this.checkHeadless();
        return new GtkButtonPeer(button);
    }

    @Override
    protected CanvasPeer createCanvas(Canvas canvas) {
        this.checkHeadless();
        return new GtkCanvasPeer(canvas);
    }

    @Override
    protected CheckboxPeer createCheckbox(Checkbox checkbox) {
        this.checkHeadless();
        return new GtkCheckboxPeer(checkbox);
    }

    @Override
    protected CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        this.checkHeadless();
        return new GtkCheckboxMenuItemPeer(checkboxMenuItem);
    }

    @Override
    protected ChoicePeer createChoice(Choice choice) {
        this.checkHeadless();
        return new GtkChoicePeer(choice);
    }

    @Override
    protected DialogPeer createDialog(Dialog dialog) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkDialogPeer(dialog);
    }

    @Override
    protected FileDialogPeer createFileDialog(FileDialog fileDialog) {
        this.checkHeadless();
        return new GtkFileDialogPeer(fileDialog);
    }

    @Override
    protected FramePeer createFrame(Frame frame) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkFramePeer(frame);
    }

    @Override
    protected LabelPeer createLabel(Label label) {
        this.checkHeadless();
        return new GtkLabelPeer(label);
    }

    @Override
    protected ListPeer createList(List list2) {
        this.checkHeadless();
        return new GtkListPeer(list2);
    }

    @Override
    protected MenuPeer createMenu(Menu menu) {
        this.checkHeadless();
        return new GtkMenuPeer(menu);
    }

    @Override
    protected MenuBarPeer createMenuBar(MenuBar menuBar) {
        this.checkHeadless();
        return new GtkMenuBarPeer(menuBar);
    }

    @Override
    protected MenuItemPeer createMenuItem(MenuItem menuItem) {
        this.checkHeadless();
        return new GtkMenuItemPeer(menuItem);
    }

    @Override
    protected PanelPeer createPanel(Panel panel) {
        this.checkHeadless();
        return new GtkPanelPeer(panel);
    }

    @Override
    protected PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        this.checkHeadless();
        return new GtkPopupMenuPeer(popupMenu);
    }

    @Override
    protected ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        this.checkHeadless();
        return new GtkScrollPanePeer(scrollPane);
    }

    @Override
    protected ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        this.checkHeadless();
        return new GtkScrollbarPeer(scrollbar);
    }

    @Override
    protected TextAreaPeer createTextArea(TextArea textArea) {
        this.checkHeadless();
        return new GtkTextAreaPeer(textArea);
    }

    @Override
    protected TextFieldPeer createTextField(TextField textField) {
        this.checkHeadless();
        return new GtkTextFieldPeer(textField);
    }

    @Override
    protected WindowPeer createWindow(Window window) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkWindowPeer(window);
    }

    @Override
    public EmbeddedWindowPeer createEmbeddedWindow(EmbeddedWindow embeddedWindow) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkEmbeddedWindowPeer(embeddedWindow);
    }

    @Override
    protected FontPeer getFontPeer(String string, int n) {
        return this.getFontPeer(string, n, 12);
    }

    private FontPeer getFontPeer(String string, int n, int n2) {
        HashMap hashMap = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(n, hashMap);
        ClasspathFontPeer.copySizeToAttrs(n2, hashMap);
        return this.getClasspathFontPeer(string, hashMap);
    }

    @Override
    public ClasspathFontPeer getClasspathFontPeer(String string, Map<?, ?> map) {
        HashMap hashMap = new HashMap(map);
        hashMap.put("GtkToolkit.RequestedFontName", string);
        if (this.fontCache.containsKey(hashMap)) {
            return (ClasspathFontPeer)this.fontCache.get(hashMap);
        }
        GdkFontPeer gdkFontPeer = new GdkFontPeer(string, map);
        this.fontCache.put(hashMap, gdkFontPeer);
        return gdkFontPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EventQueue getSystemEventQueueImpl() {
        Class<GtkToolkit> clazz = GtkToolkit.class;
        synchronized (GtkToolkit.class) {
            if (q == null) {
                q = new EventQueue();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return q;
        }
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) {
        return new GtkCursor(image, point, string);
    }

    @Override
    protected native void loadSystemColors(int[] var1);

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new InvalidDnDOperationException();
        }
        return new GtkDragSourceContextPeer(dragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (clazz.getName().equals("java.awt.dnd.MouseDragGestureRecognizer") && !GraphicsEnvironment.isHeadless()) {
            GtkMouseDragGestureRecognizer gtkMouseDragGestureRecognizer = new GtkMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
            gtkMouseDragGestureRecognizer.registerListeners();
            return (T)((DragGestureRecognizer)clazz.cast(gtkMouseDragGestureRecognizer));
        }
        return null;
    }

    @Override
    public Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        throw new Error("not implemented");
    }

    public Rectangle getBounds() {
        int[] nArray = new int[2];
        this.getScreenSizeDimensions(nArray);
        return new Rectangle(0, 0, nArray[0], nArray[1]);
    }

    @Override
    public GraphicsEnvironment getLocalGraphicsEnvironment() {
        return new GdkGraphicsEnvironment();
    }

    @Override
    public Font createFont(int n, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RobotPeer createRobot(GraphicsDevice graphicsDevice) throws AWTException {
        return new GdkRobotPeer(graphicsDevice);
    }

    @Override
    public boolean getLockingKeyState(int n) {
        int n2 = this.getLockState(n);
        if (n2 != -1) {
            return n2 == 1;
        }
        if (AWTUtilities.isValidKey(n)) {
            throw new UnsupportedOperationException("cannot get locking state of key code " + n);
        }
        throw new IllegalArgumentException("invalid key code " + n);
    }

    protected native int getLockState(int var1);

    @Override
    public void registerImageIOSpis(IIORegistry iIORegistry) {
        GdkPixbufDecoder.registerSpis(iIORegistry);
    }

    @Override
    protected MouseInfoPeer getMouseInfoPeer() {
        return new GtkMouseInfoPeer();
    }

    @Override
    public boolean isFrameStateSupported(int n) {
        return n == 0 || n == 1 || n == 6;
    }

    private void checkHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    @Override
    public native int getMouseNumberOfButtons();

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return false;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return false;
    }

    static {
        initializedGlobalIDs = false;
        System.loadLibrary("gtkpeer");
        GtkToolkit.initializeGlobalIDs();
        String string = System.getProperty("gnu.classpath.awt.gtk.portable.native.sync");
        int n = string == null ? -1 : (Boolean.valueOf(string) != false ? 1 : 0);
        GTK_LOCK = new String("GTK LOCK");
        GtkToolkit.gtkInit(n, GTK_LOCK);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        int max_entries;

        public LRUCache(int n) {
            super(n, 0.75f, true);
            this.max_entries = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.max_entries;
        }
    }
}

