/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkSelection
implements Transferable {
    private static Object requestLock = new Object();
    private final boolean clipboard;
    private boolean requestInProgress;
    private boolean mimeTypesDelivered;
    private DataFlavor[] dataFlavors;
    private boolean textDelivered;
    private String text;
    private boolean imageDelivered;
    private Pointer imagePointer;
    private Image image;
    private boolean urisDelivered;
    private List<File> uris;
    private boolean bytesDelivered;
    private byte[] bytes;

    GtkSelection(GtkClipboard gtkClipboard) {
        this.clipboard = gtkClipboard == GtkClipboard.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        Object object = requestLock;
        synchronized (object) {
            if (this.mimeTypesDelivered) {
                dataFlavorArray = (DataFlavor[])this.dataFlavors.clone();
            } else {
                while (this.requestInProgress) {
                    try {
                        requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.mimeTypesDelivered) {
                    this.requestInProgress = true;
                    this.requestMimeTypes(this.clipboard);
                    while (!this.mimeTypesDelivered) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.requestInProgress = false;
                }
                dataFlavorArray = this.dataFlavors;
                if (!GtkClipboard.canCache) {
                    this.dataFlavors = null;
                    this.mimeTypesDelivered = false;
                }
                requestLock.notifyAll();
            }
        }
        return dataFlavorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mimeTypesAvailable(String[] stringArray) {
        Object object = requestLock;
        synchronized (object) {
            if (stringArray == null) {
                this.dataFlavors = new DataFlavor[0];
            } else {
                ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(stringArray.length + 1);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        if (stringArray[i] == GtkClipboard.stringMimeType) {
                            arrayList.add(DataFlavor.stringFlavor);
                            arrayList.add(DataFlavor.plainTextFlavor);
                            continue;
                        }
                        if (stringArray[i] == GtkClipboard.imageMimeType) {
                            arrayList.add(DataFlavor.imageFlavor);
                            continue;
                        }
                        if (stringArray[i] == GtkClipboard.filesMimeType) {
                            arrayList.add(DataFlavor.javaFileListFlavor);
                            continue;
                        }
                        DataFlavor dataFlavor = new DataFlavor(stringArray[i]);
                        if (arrayList.contains(dataFlavor)) continue;
                        arrayList.add(dataFlavor);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        nullPointerException.printStackTrace();
                    }
                }
                this.dataFlavors = new DataFlavor[arrayList.size()];
                arrayList.toArray(this.dataFlavors);
            }
            this.mimeTypesDelivered = true;
            requestLock.notifyAll();
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText() {
        String string;
        Object object = requestLock;
        synchronized (object) {
            if (this.textDelivered) {
                string = this.text;
            } else {
                while (this.requestInProgress) {
                    try {
                        requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.textDelivered) {
                    this.requestInProgress = true;
                    this.requestText(this.clipboard);
                    while (!this.textDelivered) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.requestInProgress = false;
                }
                string = this.text;
                if (!GtkClipboard.canCache) {
                    this.text = null;
                    this.textDelivered = false;
                }
                requestLock.notifyAll();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void textAvailable(String string) {
        Object object = requestLock;
        synchronized (object) {
            this.text = string;
            this.textDelivered = true;
            requestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage() {
        Image image;
        Object object = requestLock;
        synchronized (object) {
            if (this.imageDelivered) {
                image = this.image;
            } else {
                while (this.requestInProgress) {
                    try {
                        requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.imageDelivered) {
                    this.requestInProgress = true;
                    this.requestImage(this.clipboard);
                    while (!this.imageDelivered) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.requestInProgress = false;
                }
                if (this.imagePointer != null) {
                    this.image = new GtkImage(this.imagePointer);
                }
                this.imagePointer = null;
                image = this.image;
                if (!GtkClipboard.canCache) {
                    this.image = null;
                    this.imageDelivered = false;
                }
                requestLock.notifyAll();
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageAvailable(Pointer pointer) {
        Object object = requestLock;
        synchronized (object) {
            this.imagePointer = pointer;
            this.imageDelivered = true;
            requestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getURIs() {
        List<File> list2;
        Object object = requestLock;
        synchronized (object) {
            if (this.urisDelivered) {
                list2 = this.uris;
            } else {
                while (this.requestInProgress) {
                    try {
                        requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.urisDelivered) {
                    this.requestInProgress = true;
                    this.requestURIs(this.clipboard);
                    while (!this.urisDelivered) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.requestInProgress = false;
                }
                list2 = this.uris;
                if (!GtkClipboard.canCache) {
                    this.uris = null;
                    this.urisDelivered = false;
                }
                requestLock.notifyAll();
            }
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urisAvailable(String[] stringArray) {
        Object object = requestLock;
        synchronized (object) {
            if (stringArray != null && stringArray.length != 0) {
                ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        URI uRI = new URI(stringArray[i]);
                        if (!uRI.getScheme().equals("file")) continue;
                        arrayList.add(new File(uRI));
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                this.uris = arrayList;
            }
            this.urisDelivered = true;
            requestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(String string) {
        byte[] byArray;
        Object object = requestLock;
        synchronized (object) {
            while (this.requestInProgress) {
                try {
                    requestLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.requestInProgress = true;
            this.requestBytes(this.clipboard, string);
            while (!this.bytesDelivered) {
                try {
                    requestLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            byArray = this.bytes;
            this.bytes = null;
            this.bytesDelivered = false;
            this.requestInProgress = false;
            requestLock.notifyAll();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesAvailable(byte[] byArray) {
        Object object = requestLock;
        synchronized (object) {
            this.bytes = byArray;
            this.bytesDelivered = true;
            requestLock.notifyAll();
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        Object object;
        if (dataFlavor.equals(DataFlavor.stringFlavor) && (object = this.getText()) != null) {
            return object;
        }
        if (dataFlavor.equals(DataFlavor.plainTextFlavor) && (object = this.getText()) != null) {
            return new StringBufferInputStream((String)object);
        }
        if (dataFlavor.equals(DataFlavor.imageFlavor) && (object = this.getImage()) != null) {
            return object;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor) && (object = this.getURIs()) != null) {
            return object;
        }
        object = this.getBytes(dataFlavor.getMimeType());
        if (object == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.isMimeTypeSerializedObject()) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            return new ByteArrayInputStream((byte[])object);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private native void requestText(boolean var1);

    private native void requestImage(boolean var1);

    private native void requestURIs(boolean var1);

    private native void requestBytes(boolean var1, String var2);

    private native void requestMimeTypes(boolean var1);
}

