/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.nio.ByteOrder;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkImageConsumer
implements ImageConsumer {
    private GtkImage target;
    private int width;
    private int height;
    private Hashtable<?, ?> properties;
    private int[] pixelCache = null;
    private ImageProducer source;

    public GtkImageConsumer(GtkImage gtkImage, ImageProducer imageProducer) {
        this.target = gtkImage;
        this.source = imageProducer;
    }

    @Override
    public synchronized void imageComplete(int n) {
        if (!(this.source instanceof MemoryImageSource)) {
            this.source.removeConsumer(this);
        }
        this.target.setImage(this.width, this.height, this.pixelCache, this.properties);
    }

    @Override
    public synchronized void setColorModel(ColorModel colorModel) {
    }

    @Override
    public synchronized void setDimensions(int n, int n2) {
        this.pixelCache = new int[n * n2];
        this.width = n;
        this.height = n2;
    }

    @Override
    public synchronized void setHints(int n) {
    }

    @Override
    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        this.setPixels(n, n2, n3, n4, colorModel, this.convertPixels(byArray), n5, n6);
    }

    @Override
    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.pixelCache == null) {
            return;
        }
        if (colorModel.equals(GtkImage.nativeModel)) {
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(nArray, n5 + i * n6, this.pixelCache, (n2 + i) * this.width + n, n3);
            }
        } else if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n7 = colorModel.getRGB(nArray[n5 + i * n6 + n + j]);
                    int n8 = (n7 & 0xFF000000) >> 24 & 0xFF;
                    int n9 = (n7 & 0xFFFFFF) << 8;
                    this.pixelCache[(n2 + i) * this.width + n + j] = n7 = n9 | n8;
                }
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n10 = colorModel.getRGB(nArray[n5 + i * n6 + n + j]);
                    byte by = (byte)(n10 & 0xFF);
                    byte by2 = (byte)((n10 & 0xFF0000) >> 16 & 0xFF);
                    n10 &= 0xFF00FF00;
                    n10 |= (by & 0xFF) << 16;
                    this.pixelCache[(n2 + i) * this.width + n + j] = n10 |= by2 & 0xFF;
                }
            }
        }
    }

    private int[] convertPixels(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    @Override
    public synchronized void setProperties(Hashtable<?, ?> hashtable) {
        this.properties = hashtable;
    }
}

