/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.font.opentype.NameDecoder;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.gtk.FreetypeGlyphVector;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.lang.CPStringBuilder;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GdkFontPeer
extends ClasspathFontPeer {
    static final FontRenderContext DEFAULT_CTX = new FontRenderContext(null, false, false);
    HashMap<String, TextLayout> textLayoutCache = new GtkToolkit.LRUCache<String, TextLayout>(500);
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private HashMap<Integer, GlyphMetrics> metricsCache;
    private static final int FONT_METRICS_ASCENT = 0;
    private static final int FONT_METRICS_MAX_ASCENT = 1;
    private static final int FONT_METRICS_DESCENT = 2;
    private static final int FONT_METRICS_MAX_DESCENT = 3;
    private static final int FONT_METRICS_MAX_ADVANCE = 4;
    private static final int FONT_METRICS_HEIGHT = 5;
    private static final int FONT_METRICS_UNDERLINE_OFFSET = 6;
    private static final int FONT_METRICS_UNDERLINE_THICKNESS = 7;
    float ascent;
    float descent;
    float maxAscent;
    float maxDescent;
    float maxAdvance;
    float height;
    float underlineOffset;
    float underlineThickness;
    GdkFontMetrics metrics;
    private ByteBuffer nameTable = null;
    private Pointer nativeFont;

    static native void initStaticState();

    private native void initState();

    private native void dispose();

    private native void setFont(String var1, int var2, int var3);

    synchronized native void getFontMetrics(double[] var1);

    synchronized native void getTextMetrics(String var1, double[] var2);

    native void releasePeerGraphicsResource();

    protected void finalize() {
        this.releasePeerGraphicsResource();
        this.dispose();
    }

    private String buildString(CharacterIterator characterIterator) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        char c = characterIterator.first();
        while (c != '\uffff') {
            cPStringBuilder.append(c);
            c = characterIterator.next();
        }
        return cPStringBuilder.toString();
    }

    private String buildString(CharacterIterator characterIterator, int n, int n2) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n3 = 0;
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (n <= n3) {
                cPStringBuilder.append(c);
            }
            if (n2 <= n3) break;
            c = characterIterator.next();
            ++n3;
        }
        return cPStringBuilder.toString();
    }

    private String buildString(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2 - n);
    }

    public GdkFontPeer(String string, int n) {
        this(string, n, 12);
    }

    public GdkFontPeer(String string, int n, int n2) {
        super(string, n, n2);
        this.initState();
        this.setFont(this.familyName, this.style, (int)this.size);
        this.metricsCache = new HashMap();
        this.setupMetrics();
    }

    public GdkFontPeer(String string, Map map) {
        super(string, map);
        this.initState();
        this.setFont(this.familyName, this.style, (int)this.size);
        this.metricsCache = new HashMap();
        this.setupMetrics();
    }

    static Font initFont(Font font) {
        if (font == null) {
            return new Font("Dialog", 0, 12);
        }
        if (font.getPeer() instanceof GdkFontPeer) {
            return font;
        }
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        return classpathToolkit.getFont(font.getName(), font.getAttributes());
    }

    private void setupMetrics() {
        double[] dArray = new double[8];
        this.getFontMetrics(dArray);
        this.ascent = (float)dArray[0];
        this.maxAscent = (float)dArray[1];
        this.descent = (float)dArray[2];
        this.maxDescent = (float)dArray[3];
        this.maxAdvance = (float)dArray[4];
        this.height = (float)dArray[5];
        this.underlineOffset = (float)dArray[6];
        this.underlineThickness = (float)dArray[7];
    }

    public String getSubFamilyName(Font font, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getName(2, locale)) == null && "Regular".equals(string = this.getName(2, Locale.ENGLISH))) {
            string = null;
        }
        return string;
    }

    private native byte[] getTrueTypeTable(byte var1, byte var2, byte var3, byte var4);

    public String getPostScriptName(Font font) {
        String string = this.getName(6, null);
        if (string == null) {
            return this.familyName;
        }
        return string;
    }

    private String getName(int n, Locale locale) {
        if (this.nameTable == null) {
            byte[] byArray = this.getTrueTypeTable((byte)110, (byte)97, (byte)109, (byte)101);
            if (byArray == null) {
                return null;
            }
            this.nameTable = ByteBuffer.wrap(byArray);
        }
        return NameDecoder.getName(this.nameTable, n, locale);
    }

    public boolean canDisplay(Font font, int n) {
        return true;
    }

    public int canDisplayUpTo(Font font, CharacterIterator characterIterator, int n, int n2) {
        return -1;
    }

    public GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new FreetypeGlyphVector(font, this.buildString(characterIterator), fontRenderContext);
    }

    public GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray) {
        return new FreetypeGlyphVector(font, nArray, fontRenderContext);
    }

    public byte getBaselineFor(Font font, char c) {
        return 0;
    }

    public LineMetrics getLineMetrics(Font font, CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return new GdkFontLineMetrics(this, n2 - n);
    }

    public Rectangle2D getMaxCharBounds(Font font, FontRenderContext fontRenderContext) {
        throw new UnsupportedOperationException();
    }

    public int getMissingGlyphCode(Font font) {
        throw new UnsupportedOperationException();
    }

    public String getGlyphName(Font font, int n) {
        throw new UnsupportedOperationException();
    }

    public int getNumGlyphs(Font font) {
        byte[] byArray = this.getTrueTypeTable((byte)109, (byte)97, (byte)120, (byte)112);
        if (byArray == null) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return byteBuffer.getShort(4);
    }

    public boolean hasUniformLineMetrics(Font font) {
        return true;
    }

    public GlyphVector layoutGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        return new FreetypeGlyphVector(font, cArray, n, n2 - n, fontRenderContext, n3);
    }

    public LineMetrics getLineMetrics(Font font, String string, FontRenderContext fontRenderContext) {
        return new GdkFontLineMetrics(this, string.length());
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.metrics == null) {
            this.metrics = new GdkFontMetrics(font);
        }
        return this.metrics;
    }

    GlyphMetrics getGlyphMetrics(int n) {
        return this.metricsCache.get(new Integer(n));
    }

    void putGlyphMetrics(int n, GlyphMetrics glyphMetrics) {
        this.metricsCache.put(new Integer(n), glyphMetrics);
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkFontPeer.initStaticState();
    }

    private class GdkFontLineMetrics
    extends LineMetrics {
        private int nchars;

        public GdkFontLineMetrics(GdkFontPeer gdkFontPeer2, int n) {
            this.nchars = n;
        }

        public float getAscent() {
            return GdkFontPeer.this.ascent;
        }

        public int getBaselineIndex() {
            return 0;
        }

        public float[] getBaselineOffsets() {
            return new float[3];
        }

        public float getDescent() {
            return GdkFontPeer.this.descent;
        }

        public float getHeight() {
            return GdkFontPeer.this.height;
        }

        public float getLeading() {
            return GdkFontPeer.this.height - (GdkFontPeer.this.ascent + GdkFontPeer.this.descent);
        }

        public int getNumChars() {
            return this.nchars;
        }

        public float getStrikethroughOffset() {
            return GdkFontPeer.this.ascent / 2.0f;
        }

        public float getStrikethroughThickness() {
            return 1.0f;
        }

        public float getUnderlineOffset() {
            return GdkFontPeer.this.underlineOffset;
        }

        public float getUnderlineThickness() {
            return GdkFontPeer.this.underlineThickness;
        }
    }

    private class GdkFontMetrics
    extends FontMetrics {
        public GdkFontMetrics(Font font) {
            super(GdkFontPeer.initFont(font));
        }

        public int stringWidth(String string) {
            TextLayout textLayout = GdkFontPeer.this.textLayoutCache.get(string);
            if (textLayout == null) {
                textLayout = new TextLayout(string, this.font, DEFAULT_CTX);
                GdkFontPeer.this.textLayoutCache.put(string, textLayout);
            }
            return (int)textLayout.getAdvance();
        }

        public int charWidth(char c) {
            return this.stringWidth(new String(new char[]{c}));
        }

        public int charsWidth(char[] cArray, int n, int n2) {
            return this.stringWidth(new String(cArray, n, n2));
        }

        public int getHeight() {
            return (int)GdkFontPeer.this.height;
        }

        public int getLeading() {
            return (int)(GdkFontPeer.this.height - (GdkFontPeer.this.ascent + GdkFontPeer.this.descent));
        }

        public int getAscent() {
            return (int)GdkFontPeer.this.ascent;
        }

        public int getMaxAscent() {
            return (int)GdkFontPeer.this.ascent;
        }

        public int getDescent() {
            return (int)GdkFontPeer.this.descent;
        }

        public int getMaxDescent() {
            return (int)GdkFontPeer.this.maxDescent;
        }

        public int getMaxAdvance() {
            return (int)GdkFontPeer.this.maxAdvance;
        }
    }
}

