/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class FreetypeGlyphVector
extends GlyphVector {
    private Font font;
    private GdkFontPeer peer;
    private Rectangle2D logicalBounds;
    private float[] glyphPositions;
    private String s;
    private FontRenderContext frc;
    private int nGlyphs;
    private int[] glyphCodes;
    private long[] fontSet = null;
    private AffineTransform[] glyphTransforms;
    private GlyphMetrics[] metricsCache;

    private native void dispose(long[] var1);

    private native long getNativeFontPointer(int var1);

    public FreetypeGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this(font, string.toCharArray(), 0, string.length(), fontRenderContext, 0);
    }

    public FreetypeGlyphVector(Font font, char[] cArray, int n, int n2, FontRenderContext fontRenderContext, int n3) {
        this.s = new String(cArray, n, n2);
        this.font = font;
        this.frc = fontRenderContext;
        if (!(this.font.getPeer() instanceof GdkFontPeer)) {
            throw new IllegalArgumentException("Not a valid font.");
        }
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.getGlyphs();
        if (n3 == 1) {
            int[] nArray = new int[this.nGlyphs];
            for (int i = 0; i < this.nGlyphs; ++i) {
                nArray[i] = this.glyphCodes[this.nGlyphs - i - 1];
            }
            this.glyphCodes = nArray;
        }
        this.performDefaultLayout();
    }

    public FreetypeGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        if (!(this.font.getPeer() instanceof GdkFontPeer)) {
            throw new IllegalArgumentException("Not a valid font.");
        }
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.glyphCodes = new int[nArray.length];
        System.arraycopy(nArray, 0, this.glyphCodes, 0, nArray.length);
        this.nGlyphs = this.glyphCodes.length;
        if (this.fontSet == null) {
            this.fontSet = new long[this.nGlyphs];
            Arrays.fill(this.fontSet, this.getNativeFontPointer(this.nGlyphs));
        }
        this.performDefaultLayout();
    }

    private FreetypeGlyphVector(FreetypeGlyphVector freetypeGlyphVector) {
        this.font = freetypeGlyphVector.font;
        this.peer = freetypeGlyphVector.peer;
        this.frc = freetypeGlyphVector.frc;
        this.s = freetypeGlyphVector.s;
        this.nGlyphs = freetypeGlyphVector.nGlyphs;
        this.logicalBounds = freetypeGlyphVector.logicalBounds.getBounds2D();
        if (freetypeGlyphVector.metricsCache != null) {
            this.metricsCache = new GlyphMetrics[this.nGlyphs];
            System.arraycopy(freetypeGlyphVector.metricsCache, 0, this.metricsCache, 0, this.nGlyphs);
        }
        this.glyphCodes = new int[this.nGlyphs];
        this.fontSet = new long[this.nGlyphs];
        this.glyphPositions = new float[(this.nGlyphs + 1) * 2];
        this.glyphTransforms = new AffineTransform[this.nGlyphs];
        Arrays.fill(this.glyphTransforms, null);
        for (int i = 0; i < this.nGlyphs; ++i) {
            if (freetypeGlyphVector.glyphTransforms[i] != null) {
                this.glyphTransforms[i] = new AffineTransform(freetypeGlyphVector.glyphTransforms[i]);
            }
            this.glyphCodes[i] = freetypeGlyphVector.glyphCodes[i];
        }
        System.arraycopy(freetypeGlyphVector.glyphPositions, 0, this.glyphPositions, 0, this.glyphPositions.length);
        System.arraycopy(freetypeGlyphVector.glyphCodes, 0, this.glyphCodes, 0, this.nGlyphs);
        System.arraycopy(freetypeGlyphVector.fontSet, 0, this.fontSet, 0, this.nGlyphs);
    }

    public void finalize() {
        this.dispose(this.fontSet);
    }

    private void getGlyphs() {
        this.nGlyphs = this.s.codePointCount(0, this.s.length());
        this.glyphCodes = new int[this.nGlyphs];
        this.fontSet = new long[this.nGlyphs];
        int[] nArray = new int[this.nGlyphs];
        int n = 0;
        for (int i = 0; i < this.nGlyphs; ++i) {
            nArray[i] = this.s.codePointAt(n);
            if (nArray[i] != this.s.charAt(n)) {
                ++n;
            }
            ++n;
            if (!Character.isISOControl(nArray[i])) continue;
            nArray[i] = 8202;
        }
        this.getGlyphs(nArray, this.glyphCodes, this.fontSet);
    }

    public native void getGlyphs(int[] var1, int[] var2, long[] var3);

    private native void getKerning(int var1, int var2, long var3, float[] var5);

    private native double[] getMetricsNative(int var1, long var2);

    private native GeneralPath getGlyphOutlineNative(int var1, long var2);

    public Object clone() {
        return new FreetypeGlyphVector(this);
    }

    public boolean equals(GlyphVector glyphVector) {
        if (!(glyphVector instanceof FreetypeGlyphVector)) {
            return false;
        }
        return ((FreetypeGlyphVector)glyphVector).font.equals(this.font) && ((FreetypeGlyphVector)glyphVector).frc.equals(this.frc) && ((FreetypeGlyphVector)glyphVector).s.equals(this.s);
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.glyphTransforms = new AffineTransform[this.nGlyphs];
        Arrays.fill(this.glyphTransforms, null);
        this.glyphPositions = new float[(this.nGlyphs + 1) * 2];
        GlyphMetrics glyphMetrics = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[]{0.0f, 0.0f};
        for (int i = 0; i < this.nGlyphs; ++i) {
            glyphMetrics = this.getGlyphMetrics(i);
            this.glyphPositions[i * 2] = f;
            this.glyphPositions[i * 2 + 1] = f2;
            f += glyphMetrics.getAdvanceX();
            f2 += glyphMetrics.getAdvanceY();
            if (i == this.nGlyphs - 1 || this.fontSet[i] != this.fontSet[i + 1]) continue;
            this.getKerning(this.glyphCodes[i], this.glyphCodes[i + 1], this.fontSet[i], fArray);
            f += fArray[0];
            f2 += fArray[1];
        }
        this.glyphPositions[this.nGlyphs * 2] = f;
        this.glyphPositions[this.nGlyphs * 2 + 1] = f2;
        TransformAttribute transformAttribute = (TransformAttribute)this.font.getAttributes().get(TextAttribute.TRANSFORM);
        if (transformAttribute != null) {
            AffineTransform affineTransform = transformAttribute.getTransform();
            affineTransform.transform(this.glyphPositions, 0, this.glyphPositions, 0, this.glyphPositions.length / 2);
            double[] dArray = new double[4];
            affineTransform.getMatrix(dArray);
            AffineTransform affineTransform2 = new AffineTransform(dArray);
            if (!affineTransform2.isIdentity()) {
                Arrays.fill(this.glyphTransforms, affineTransform2);
            }
        }
    }

    public int getGlyphCode(int n) {
        return this.glyphCodes[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray == null || nArray.length < n2 ? new int[n2] : nArray;
        System.arraycopy(this.glyphCodes, n, nArray2, 0, n2);
        return nArray2;
    }

    protected long[] getGlyphFonts(int n, int n2, long[] lArray) {
        long[] lArray2 = lArray == null || lArray.length < n2 ? new long[n2] : lArray;
        System.arraycopy(this.fontSet, n, lArray2, 0, n2);
        return lArray2;
    }

    public Shape getGlyphLogicalBounds(int n) {
        GlyphMetrics glyphMetrics = this.getGlyphMetrics(n);
        if (glyphMetrics == null) {
            return null;
        }
        Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
        Point2D point2D = this.getGlyphPosition(n);
        double[] dArray = new double[]{point2D.getX() + rectangle2D.getX() - (double)glyphMetrics.getLSB(), point2D.getY() + rectangle2D.getY(), point2D.getX() + rectangle2D.getX() - (double)glyphMetrics.getLSB() + (double)glyphMetrics.getAdvanceX(), point2D.getY() + rectangle2D.getY() + rectangle2D.getHeight()};
        if (this.glyphTransforms[n] != null) {
            this.glyphTransforms[n].transform(dArray, 0, dArray, 0, 2);
        }
        return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
    }

    public void setupGlyphMetrics() {
        this.metricsCache = new GlyphMetrics[this.nGlyphs];
        for (int i = 0; i < this.nGlyphs; ++i) {
            GlyphMetrics glyphMetrics = this.peer.getGlyphMetrics(this.glyphCodes[i]);
            if (glyphMetrics == null) {
                double[] dArray = this.getMetricsNative(this.glyphCodes[i], this.fontSet[i]);
                if (dArray == null) {
                    glyphMetrics = null;
                } else {
                    glyphMetrics = new GlyphMetrics(true, (float)dArray[1], (float)dArray[2], new Rectangle2D.Double(dArray[3], dArray[4], dArray[5], dArray[6]), 0);
                    this.peer.putGlyphMetrics(this.glyphCodes[i], glyphMetrics);
                }
            }
            this.metricsCache[i] = glyphMetrics;
        }
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        if (this.metricsCache == null) {
            this.setupGlyphMetrics();
        }
        return this.metricsCache[n];
    }

    public Shape getGlyphOutline(int n) {
        GeneralPath generalPath = this.getGlyphOutlineNative(this.glyphCodes[n], this.fontSet[n]);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.glyphPositions[n * 2], this.glyphPositions[n * 2 + 1]);
        if (this.glyphTransforms[n] != null) {
            affineTransform.concatenate(this.glyphTransforms[n]);
        }
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Point2D getGlyphPosition(int n) {
        return new Point2D.Float(this.glyphPositions[n * 2], this.glyphPositions[n * 2 + 1]);
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (fArray == null || fArray.length < n2 * 2) {
            fArray = new float[n2 * 2];
        }
        System.arraycopy(this.glyphPositions, n * 2, fArray, 0, n2 * 2);
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        return this.glyphTransforms[n];
    }

    protected boolean hasTransforms() {
        for (int i = 0; i < this.glyphTransforms.length; ++i) {
            if (this.glyphTransforms[i] == null) continue;
            return true;
        }
        return false;
    }

    public Shape getGlyphVisualBounds(int n) {
        return this.getGlyphOutline(n).getBounds2D();
    }

    public Rectangle2D getLogicalBounds() {
        if (this.nGlyphs == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        if (this.logicalBounds != null) {
            return this.logicalBounds;
        }
        Rectangle2D rectangle2D = (Rectangle2D)this.getGlyphLogicalBounds(0);
        for (int i = 1; i < this.nGlyphs; ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)this.getGlyphLogicalBounds(i);
            rectangle2D = rectangle2D.createUnion(rectangle2D2);
        }
        this.logicalBounds = rectangle2D;
        return rectangle2D;
    }

    public int getNumGlyphs() {
        return this.glyphCodes.length;
    }

    public Shape getOutline() {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            generalPath.append(this.getGlyphOutline(i), false);
        }
        return generalPath;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return null;
    }

    public Shape getOutline(float f, float f2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        GeneralPath generalPath = (GeneralPath)this.getOutline();
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Rectangle2D getVisualBounds() {
        return this.getOutline().getBounds2D();
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.glyphPositions[n * 2] = (float)point2D.getX();
        this.glyphPositions[n * 2 + 1] = (float)point2D.getY();
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (affineTransform != null && affineTransform.isIdentity()) {
            affineTransform = null;
        }
        if (this.glyphTransforms[n] == null && affineTransform == null) {
            return;
        }
        if (affineTransform != null && affineTransform.equals(this.glyphTransforms[n])) {
            return;
        }
        this.logicalBounds = null;
        this.glyphTransforms[n] = affineTransform;
    }
}

