/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.Buffers;
import gnu.java.awt.peer.gtk.CairoSurfaceGraphics;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Hashtable;

public class CairoSurface
extends WritableRaster {
    int width = -1;
    int height = -1;
    long surfacePointer;
    boolean sharedBuffer;
    static ColorModel cairoColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    static ColorModel cairoCM_pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, Buffers.smallestAppropriateTransferType(32));
    static ColorModel cairoCM_opaque = new DirectColorModel(24, 0xFF0000, 65280, 255);

    private native void create(int var1, int var2, int var3, int[] var4);

    private native void destroy(long var1, int[] var3);

    public native void nativeDrawSurface(long var1, long var3, double[] var5, double var6, int var8);

    native void syncNativeToJava(long var1, int[] var3);

    native void syncJavaToNative(long var1, int[] var3);

    native long getFlippedBuffer(long var1);

    public CairoSurface(int n, int n2) {
        this(0, 0, n, n2);
    }

    public CairoSurface(int n, int n2, int n3, int n4) {
        super(CairoSurface.createCairoSampleModel(n3, n4), null, new Point(n, n2));
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Image must be at least 1x1 pixels.");
        }
        this.width = n3;
        this.height = n4;
        this.dataBuffer = new DataBufferInt(n3 * n4);
        this.create(n3, n4, n3, this.getData());
        if (this.surfacePointer == 0L) {
            throw new Error("Could not allocate bitmap.");
        }
    }

    public CairoSurface(SampleModel sampleModel, CairoSurface cairoSurface, Rectangle rectangle, Point point) {
        super(sampleModel, cairoSurface.dataBuffer, rectangle, point, cairoSurface);
        this.width = ((WritableRaster)this).width;
        this.height = ((WritableRaster)this).height;
        this.surfacePointer = cairoSurface.surfacePointer;
        this.sharedBuffer = cairoSurface.sharedBuffer;
        this.dataBuffer = cairoSurface.dataBuffer;
    }

    CairoSurface(GtkImage gtkImage) {
        this(gtkImage.width, gtkImage.height);
        int[] nArray = gtkImage.getPixels();
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i] & 0xFF;
                nArray[i] = n == 0 ? 0 : nArray[i] >>> 8 | n << 24;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i] & 0xFF000000;
                if (n == 0) {
                    nArray[i] = 0;
                    continue;
                }
                int n2 = (nArray[i] & 0xFF0000) >> 16;
                int n3 = nArray[i] & 0xFF00;
                int n4 = (nArray[i] & 0xFF) << 16;
                nArray[i] = n | n4 | n3 | n2;
            }
        }
        System.arraycopy(nArray, 0, this.getData(), 0, nArray.length);
    }

    public void dispose() {
        if (this.surfacePointer != 0L && this.parent == null) {
            this.destroy(this.surfacePointer, this.getData());
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public GtkImage getGtkImage() {
        return new GtkImage(this.width, this.height, this.getFlippedBuffer(this.surfacePointer));
    }

    public int[] getData() {
        return ((DataBufferInt)this.dataBuffer).getData();
    }

    public static BufferedImage getBufferedImage(int n, int n2) {
        return CairoSurface.getBufferedImage(new CairoSurface(n, n2));
    }

    public static BufferedImage getBufferedImage(GtkImage gtkImage) {
        return CairoSurface.getBufferedImage(new CairoSurface(gtkImage));
    }

    public static BufferedImage getBufferedImage(CairoSurface cairoSurface) {
        return new BufferedImage(cairoColorModel, cairoSurface, cairoColorModel.isAlphaPremultiplied(), new Hashtable());
    }

    public Graphics2D getGraphics() {
        return new CairoSurfaceGraphics(this);
    }

    native long nativeNewCairoContext(long var1);

    public long newCairoContext() {
        return this.nativeNewCairoContext(this.surfacePointer);
    }

    public void copyAreaNative(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.copyAreaNative2(this.surfacePointer, n, n2, n3, n4, n5, n6, n7);
    }

    native void copyAreaNative2(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    protected static SampleModel createCairoSampleModel(int n, int n2) {
        return new SinglePixelPackedSampleModel(3, n, n2, new int[]{0xFF0000, 65280, 255, -16777216});
    }

    public static boolean isCompatibleColorModel(ColorModel colorModel) {
        return colorModel.equals(cairoCM_pre) || colorModel.equals(cairoCM_opaque) || colorModel.equals(cairoColorModel);
    }

    public static boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getDataType() == 3 && Arrays.equals(((SinglePixelPackedSampleModel)sampleModel).getBitMasks(), new int[]{0xFF0000, 65280, 255, -16777216});
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new CairoSurface(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2, int n3, int n4) {
        return new CairoSurface(n, n2, n3, n4);
    }

    public Raster createTranslatedChild(int n, int n2) {
        return this.createWritableTranslatedChild(n, n2);
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX || n + n3 > this.minX + this.width || n2 < this.minY || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("Child raster extends beyond parent");
        }
        SampleModel sampleModel = nArray == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(nArray);
        return new CairoSurface(sampleModel, this, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n5 - n, this.sampleModelTranslateY + n6 - n2));
    }

    public WritableRaster createWritableTranslatedChild(int n, int n2) {
        int n3 = this.sampleModelTranslateX - this.minX + n;
        int n4 = this.sampleModelTranslateY - this.minY + n2;
        return new CairoSurface(this.sampleModel, this, new Rectangle(n, n2, this.width, this.height), new Point(n3, n4));
    }
}

