/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.WeakHashMap;

public class BufferedImageGraphics
extends CairoGraphics2D {
    private BufferedImage image;
    private BufferedImage buffer;
    private int imageWidth;
    private int imageHeight;
    CairoSurface surface;
    static WeakHashMap<BufferedImage, CairoSurface> bufferedImages = new WeakHashMap();
    private long cairo_t;
    private boolean hasFastCM;
    private boolean hasAlpha;

    public BufferedImageGraphics(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.imageWidth = bufferedImage.getWidth();
        this.imageHeight = bufferedImage.getHeight();
        if (!(this.image.getSampleModel() instanceof SinglePixelPackedSampleModel)) {
            this.hasFastCM = false;
        } else if (bufferedImage.getColorModel().equals(CairoSurface.cairoCM_opaque)) {
            this.hasFastCM = true;
            this.hasAlpha = false;
        } else if (bufferedImage.getColorModel().equals(CairoSurface.cairoColorModel) || bufferedImage.getColorModel().equals(CairoSurface.cairoCM_pre)) {
            this.hasFastCM = true;
            this.hasAlpha = true;
        } else {
            this.hasFastCM = false;
        }
        if (bufferedImages.get(bufferedImage) != null) {
            this.surface = bufferedImages.get(bufferedImage);
        } else {
            this.surface = new CairoSurface(this.imageWidth, this.imageHeight);
            bufferedImages.put(bufferedImage, this.surface);
        }
        this.cairo_t = this.surface.newCairoContext();
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (this.hasFastCM) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.image.getSampleModel();
            int n = this.image.getRaster().getSampleModelTranslateX();
            int n2 = this.image.getRaster().getSampleModelTranslateY();
            int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
            if (singlePixelPackedSampleModel.getScanlineStride() != this.imageWidth || n != 0 || n2 != 0) {
                int[] nArray2 = new int[this.imageWidth * this.imageHeight];
                int n3 = singlePixelPackedSampleModel.getScanlineStride();
                for (int i = 0; i < this.imageHeight; ++i) {
                    System.arraycopy(nArray, (i - n2) * n3 - n, nArray2, i * this.imageWidth, this.imageWidth);
                }
                nArray = nArray2;
            }
            if (!this.hasAlpha) {
                int n4 = 0;
                while (n4 < nArray.length) {
                    int n5 = n4++;
                    nArray[n5] = nArray[n5] & 0xFFFFFFFF;
                }
            }
        } else {
            int[] nArray = CairoGraphics2D.findSimpleIntegerArray(this.image.getColorModel(), this.image.getData());
            if (nArray != null) {
                System.arraycopy(nArray, 0, this.surface.getData(), 0, nArray.length);
            }
        }
        this.setup(this.cairo_t);
        this.setClip(0, 0, this.imageWidth, this.imageHeight);
    }

    BufferedImageGraphics(BufferedImageGraphics bufferedImageGraphics) {
        this.image = bufferedImageGraphics.image;
        this.surface = bufferedImageGraphics.surface;
        this.cairo_t = this.surface.newCairoContext();
        this.imageWidth = bufferedImageGraphics.imageWidth;
        this.imageHeight = bufferedImageGraphics.imageHeight;
        this.hasFastCM = bufferedImageGraphics.hasFastCM;
        this.hasAlpha = bufferedImageGraphics.hasAlpha;
        this.copy(bufferedImageGraphics, this.cairo_t);
    }

    private void updateBufferedImage(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        rectangle = BufferedImageGraphics.getTransformedBounds(rectangle, this.transform).getBounds();
        n = rectangle.x;
        n2 = rectangle.y;
        n3 = rectangle.width;
        n4 = rectangle.height;
        int[] nArray = this.surface.getData();
        if (n > this.imageWidth || n2 > this.imageHeight) {
            return;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n + n3 > this.imageWidth) {
            n3 = this.imageWidth - n;
        }
        if (n2 + n4 > this.imageHeight) {
            n4 = this.imageHeight - n2;
        }
        if (!this.hasFastCM) {
            this.image.setRGB(n, n2, n3, n4, nArray, n + n2 * this.imageWidth, this.imageWidth);
        } else {
            int[] nArray2 = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.image.getSampleModel();
            int n5 = this.image.getRaster().getSampleModelTranslateX();
            int n6 = this.image.getRaster().getSampleModelTranslateY();
            if (singlePixelPackedSampleModel.getScanlineStride() == this.imageWidth && n5 == 0) {
                System.arraycopy(nArray, n2 * this.imageWidth, nArray2, (n2 - n6) * this.imageWidth, n4 * this.imageWidth);
            } else {
                int n7 = singlePixelPackedSampleModel.getScanlineStride();
                for (int i = n2; i < n4 + n2; ++i) {
                    System.arraycopy(nArray, i * this.imageWidth + n, nArray2, (i - n6) * n7 + n - n5, n3);
                }
            }
        }
    }

    public Graphics create() {
        return new BufferedImageGraphics(this);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.imageWidth, this.imageHeight);
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.surface.copyAreaNative(n, n2, n3, n4, n5, n6, this.surface.width);
        this.updateBufferedImage(n + n5, n2 + n6, n3, n4);
    }

    public void draw(Shape shape) {
        Rectangle rectangle = this.findStrokedBounds(shape);
        if (this.shiftDrawCalls) {
            ++rectangle.width;
            ++rectangle.height;
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(shape);
            this.updateBufferedImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setStroke(this.getStroke());
            graphics2D.setColor(this.getColor());
            graphics2D.setTransform(this.transform);
            graphics2D.draw(shape);
            this.drawComposite(rectangle.getBounds2D(), null);
        }
    }

    public void fill(Shape shape) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(shape);
            Rectangle rectangle = shape.getBounds();
            this.updateBufferedImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setColor(this.getColor());
            graphics2D.setTransform(this.transform);
            graphics2D.fill(shape);
            this.drawComposite(shape.getBounds2D(), null);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawRenderedImage(renderedImage, affineTransform);
            this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setRenderingHints(this.getRenderingHints());
            graphics2D.setTransform(this.transform);
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
            this.drawComposite(this.buffer.getRaster().getBounds(), null);
        }
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        Object object;
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            boolean bl = super.drawImage(image, affineTransform, color, imageObserver);
            this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
            return bl;
        }
        if (!(image instanceof BufferedImage)) {
            object = image.getSource();
            if (object == null) {
                return false;
            }
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
        }
        object = (BufferedImage)image;
        Rectangle2D rectangle2D = new Rectangle(((BufferedImage)object).getMinX(), ((BufferedImage)object).getMinY(), ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
        if (affineTransform != null) {
            rectangle2D = BufferedImageGraphics.getTransformedBounds(rectangle2D, affineTransform);
        }
        this.createBuffer();
        Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
        graphics2D.setRenderingHints(this.getRenderingHints());
        graphics2D.drawImage(image, affineTransform, imageObserver);
        return this.drawComposite(rectangle2D, imageObserver);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
        rectangle2D = new Rectangle2D.Double((double)f + rectangle2D.getX(), (double)f2 + rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(glyphVector, f, f2);
            rectangle2D = rectangle2D.getBounds();
            this.updateBufferedImage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setStroke(this.getStroke());
            graphics2D.setTransform(this.transform);
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            this.drawComposite(rectangle2D, null);
        }
    }

    private boolean drawComposite(Rectangle2D rectangle2D, ImageObserver imageObserver) {
        rectangle2D = BufferedImageGraphics.getTransformedBounds(rectangle2D, this.transform);
        Rectangle2D rectangle2D2 = this.getClipInDevSpace();
        Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        rectangle2D2 = new Rectangle(this.buffer.getMinX(), this.buffer.getMinY(), this.buffer.getWidth(), this.buffer.getHeight());
        Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = d + rectangle2D.getWidth();
        double d4 = d2 + rectangle2D.getHeight();
        d = Math.round(d);
        d2 = Math.round(d2);
        rectangle2D.setRect(d, d2, Math.round(d3 - d), Math.round(d4 - d2));
        BufferedImage bufferedImage = this.buffer;
        if (!rectangle2D.equals(bufferedImage.getRaster().getBounds())) {
            bufferedImage = bufferedImage.getSubimage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        BufferedImage bufferedImage2 = this.image;
        bufferedImage2 = bufferedImage2.getSubimage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        this.compCtx.compose(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage2.getRaster());
        Composite composite = this.comp;
        this.setComposite(AlphaComposite.Src);
        boolean bl = super.drawImage((Image)bufferedImage2, AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY()), null, null);
        this.setComposite(composite);
        this.updateColor();
        return bl;
    }

    private void createBuffer() {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        } else {
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
    }

    protected ColorModel getNativeCM() {
        return this.image.getColorModel();
    }

    protected ColorModel getBufferCM() {
        return ColorModel.getRGBdefault();
    }
}

