/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class AsyncImage
extends Image {
    Image realImage;
    HashSet<ImageObserver> observers = new HashSet();

    AsyncImage(URL uRL) {
        Loader loader = new Loader(uRL);
        Thread thread = new Thread(loader);
        thread.start();
    }

    public void flush() {
    }

    public Graphics getGraphics() {
        Image image = this.realImage;
        Graphics graphics = null;
        if (image != null) {
            graphics = image.getGraphics();
        }
        return graphics;
    }

    public int getHeight(ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        int n = 0;
        Image image = this.realImage;
        if (image != null) {
            n = image.getHeight(imageObserver);
        }
        return n;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        Image image = this.realImage;
        Object object = null;
        if (image != null) {
            object = image.getProperty(string, imageObserver);
        }
        return object;
    }

    public ImageProducer getSource() {
        Image image = this.realImage;
        ImageProducer imageProducer = image == null ? new NullImageSource() : image.getSource();
        return imageProducer;
    }

    public int getWidth(ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        int n = 0;
        Image image = this.realImage;
        if (image != null) {
            n = image.getWidth(imageObserver);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObserver(ImageObserver imageObserver) {
        if (imageObserver != null) {
            AsyncImage asyncImage = this;
            synchronized (asyncImage) {
                HashSet<ImageObserver> hashSet = this.observers;
                if (hashSet != null) {
                    hashSet.add(imageObserver);
                } else {
                    imageObserver.imageUpdate(this, 39, 0, 0, this.realImage.getWidth(null), this.realImage.getHeight(null));
                }
            }
        }
    }

    static Image realImage(Image image, ImageObserver imageObserver) {
        if (image instanceof AsyncImage) {
            ((AsyncImage)image).addObserver(imageObserver);
            Image image2 = ((AsyncImage)image).realImage;
            if (image2 != null) {
                image = image2;
            }
        }
        return image;
    }

    void notifyObservers(int n) {
        assert (Thread.holdsLock(this));
        HashSet<ImageObserver> hashSet = this.observers;
        if (hashSet != null) {
            Image image = this.realImage;
            for (ImageObserver imageObserver : hashSet) {
                imageObserver.imageUpdate(this, n, 0, 0, image.getWidth(null), image.getHeight(null));
            }
        }
    }

    int checkImage(ImageObserver imageObserver) {
        this.addObserver(imageObserver);
        int n = 0;
        if (this.realImage != null) {
            n = 39;
        }
        return n;
    }

    private class Loader
    implements Runnable {
        private URL url;

        Loader(URL uRL) {
            this.url = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedImage bufferedImage;
            Image image;
            try {
                image = new GtkImage(this.url);
                bufferedImage = CairoSurface.getBufferedImage(image);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bufferedImage = null;
            }
            AsyncImage.this.realImage = GtkToolkit.imageOrError(bufferedImage);
            image = AsyncImage.this;
            synchronized (image) {
                AsyncImage.this.notifyObservers(39);
                AsyncImage.this.observers = null;
            }
        }
    }

    private class NullImageSource
    implements ImageProducer {
        private ArrayList<ImageConsumer> consumers = new ArrayList();

        NullImageSource() {
        }

        public void addConsumer(ImageConsumer imageConsumer) {
            this.consumers.add(imageConsumer);
        }

        public boolean isConsumer(ImageConsumer imageConsumer) {
            return this.consumers.contains(imageConsumer);
        }

        public void removeConsumer(ImageConsumer imageConsumer) {
            this.consumers.remove(imageConsumer);
        }

        public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
            this.startProduction(imageConsumer);
        }

        public void startProduction(ImageConsumer imageConsumer) {
            this.consumers.add(imageConsumer);
            for (int i = this.consumers.size() - 1; i >= 0; --i) {
                ImageConsumer imageConsumer2 = this.consumers.get(i);
                imageConsumer2.setDimensions(1, 1);
                imageConsumer.imageComplete(2);
            }
        }
    }
}

