/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.ImagePaint;
import gnu.java.awt.java2d.Pixelizer;
import gnu.java.awt.java2d.ScanlineConverter;
import gnu.java.awt.java2d.ScanlineCoverage;
import gnu.java.awt.java2d.ShapeCache;
import gnu.java.awt.java2d.TextCacheKey;
import gnu.java.util.LRUCache;
import java.awt.AWTError;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.ReplicateScaleFilter;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractGraphics2D
extends Graphics2D
implements Cloneable,
Pixelizer {
    protected static final WeakHashMap<Image, HashMap<Dimension, Image>> imageCache = new WeakHashMap();
    private static final boolean DEFAULT_TEXT_AA = Boolean.getBoolean("gnu.java2d.default_text_aa");
    private static final Font FONT = new Font("SansSerif", 0, 12);
    private static final int GV_CACHE_SIZE = 50;
    private static final ShapeCache shapeCache = new ShapeCache();
    private static final LinkedList<ScanlineConverter> scanlineConverters = new LinkedList();
    private static final Map<TextCacheKey, GlyphVector> gvCache = Collections.synchronizedMap(new LRUCache(50));
    private static final TextCacheKey searchTextKey = new TextCacheKey();
    protected AffineTransform transform;
    private Paint paint;
    private PaintContext paintContext = null;
    private Color background = Color.WHITE;
    private Color foreground = Color.BLACK;
    private boolean isForegroundColorNull = true;
    private Font font;
    private Composite composite;
    private Stroke stroke;
    private Shape clip;
    private RenderingHints renderingHints;
    private WritableRaster destinationRaster;
    private boolean isOptimized = true;
    private static final BasicStroke STANDARD_STROKE = new BasicStroke();
    private static final HashMap<RenderingHints.Key, Object> STANDARD_HINTS;

    protected AbstractGraphics2D() {
        this.transform = new AffineTransform();
        this.background = Color.WHITE;
        this.composite = AlphaComposite.SrcOver;
        this.stroke = STANDARD_STROKE;
        this.renderingHints = new RenderingHints(STANDARD_HINTS);
    }

    public void draw(Shape shape) {
        Shape shape2 = this.stroke.createStrokedShape(shape);
        this.fillShape(shape2, false);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver));
        return this.drawImageImpl(image, affineTransform, imageObserver, rectangle);
    }

    private boolean drawImageImpl(Image image, AffineTransform affineTransform, ImageObserver imageObserver, Rectangle rectangle) {
        boolean bl;
        if (image == null) {
            bl = true;
        } else if (image instanceof RenderedImage) {
            this.drawRenderedImageImpl((RenderedImage)((Object)image), affineTransform, rectangle);
            bl = true;
        } else if (image instanceof RenderableImage) {
            this.drawRenderableImageImpl((RenderableImage)((Object)image), affineTransform, rectangle);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        this.drawRenderedImage(bufferedImage2, affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getHeight(), renderedImage.getWidth(), renderedImage.getHeight());
        this.drawRenderedImageImpl(renderedImage, affineTransform, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawRenderedImageImpl(RenderedImage renderedImage, AffineTransform affineTransform, Rectangle rectangle) {
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(-rectangle.x - renderedImage.getMinX(), -rectangle.y - renderedImage.getMinY());
        affineTransform2.concatenate(affineTransform);
        affineTransform2.concatenate(this.transform);
        AffineTransform affineTransform3 = null;
        try {
            affineTransform3 = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        if (affineTransform3 != null) {
            GeneralPath generalPath = new GeneralPath(rectangle);
            generalPath.transform(affineTransform);
            ImagePaint imagePaint = new ImagePaint(renderedImage, affineTransform3);
            Paint paint = this.paint;
            try {
                this.paint = imagePaint;
                this.fillShape(generalPath, false);
                Object var10_10 = null;
                this.paint = paint;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.paint = paint;
                throw throwable;
            }
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Rectangle rectangle = new Rectangle((int)renderableImage.getMinX(), (int)renderableImage.getHeight(), (int)renderableImage.getWidth(), (int)renderableImage.getHeight());
        this.drawRenderableImageImpl(renderableImage, affineTransform, rectangle);
    }

    private void drawRenderableImageImpl(RenderableImage renderableImage, AffineTransform affineTransform, Rectangle rectangle) {
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        this.drawRenderedImageImpl(renderedImage, affineTransform, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(String string, int n, int n2) {
        GlyphVector glyphVector;
        TextCacheKey textCacheKey = searchTextKey;
        synchronized (textCacheKey) {
            TextCacheKey textCacheKey2 = searchTextKey;
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            textCacheKey2.setString(string);
            textCacheKey2.setFont(this.font);
            textCacheKey2.setFontRenderContext(fontRenderContext);
            if (gvCache.containsKey(textCacheKey2)) {
                glyphVector = gvCache.get(textCacheKey2);
            } else {
                glyphVector = this.font.createGlyphVector(fontRenderContext, string.toCharArray());
                gvCache.put(new TextCacheKey(string, this.font, fontRenderContext), glyphVector);
            }
        }
        this.drawGlyphVector(glyphVector, n, n2);
    }

    public void drawString(String string, float f, float f2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, string.toCharArray());
        this.drawGlyphVector(glyphVector, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, f, f2);
    }

    public void fill(Shape shape) {
        this.fillShape(shape, false);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setComposite(Composite composite) {
        SecurityManager securityManager;
        if (!(composite instanceof AlphaComposite) && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new AWTPermission("readDisplayPixels"));
        }
        this.composite = composite;
        if (!composite.equals(AlphaComposite.SrcOver)) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (!(this.paint instanceof Color)) {
                this.isOptimized = false;
            } else {
                this.foreground = (Color)this.paint;
                this.isForegroundColorNull = false;
                this.updateOptimization();
            }
        } else {
            this.foreground = Color.BLACK;
            this.isForegroundColorNull = true;
        }
        if (this.paintContext != null) {
            this.paintContext.dispose();
        }
        this.paintContext = null;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (!this.stroke.equals(new BasicStroke())) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.renderingHints.clear();
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    public void addRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    public void translate(int n, int n2) {
        this.transform.translate(n, n2);
        if (this.clip != null) {
            if (this.clip instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)this.clip;
                rectangle.x -= n;
                rectangle.y -= n2;
                this.setClip(rectangle);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-n, -n2);
                this.updateClip(affineTransform);
            }
        }
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        if (this.clip != null) {
            if (this.clip instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)this.clip;
                rectangle.x = (int)((double)rectangle.x - d);
                rectangle.y = (int)((double)rectangle.y - d2);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-d, -d2);
                this.updateClip(affineTransform);
            }
        }
    }

    public void rotate(double d) {
        this.transform.rotate(d);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-d);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-d, d2, d3);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0 / d, 1.0 / d2);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.shear(-d, -d2);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            this.updateClip(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        this.updateOptimization();
    }

    public void setTransform(AffineTransform affineTransform) {
        this.updateClip(this.transform);
        this.transform.setTransform(affineTransform);
        try {
            this.updateClip(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        this.updateOptimization();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape shape) {
        if (this.clip == null) {
            this.setClip(shape);
        } else if (this.clip instanceof Rectangle && shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)this.clip;
            Rectangle rectangle2 = (Rectangle)shape;
            AbstractGraphics2D.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            this.setClip(rectangle);
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            Area area2 = shape instanceof Area ? (Area)shape : new Area(shape);
            area.intersect(area2);
            this.clip = area;
            this.isOptimized = false;
            this.setClip(this.clip);
        }
    }

    public FontRenderContext getFontRenderContext() {
        AffineTransform affineTransform = new AffineTransform(this.transform);
        return new FontRenderContext(affineTransform, false, true);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.translate(f, f2);
        this.fillShape(glyphVector.getOutline(), true);
        this.translate(-f, -f2);
    }

    public Graphics create() {
        AbstractGraphics2D abstractGraphics2D = (AbstractGraphics2D)this.clone();
        return abstractGraphics2D;
    }

    protected Object clone() {
        try {
            AbstractGraphics2D abstractGraphics2D = (AbstractGraphics2D)super.clone();
            abstractGraphics2D.clip = this.clip instanceof Rectangle ? new Rectangle((Rectangle)this.clip) : (this.clip != null ? new GeneralPath(this.clip) : null);
            abstractGraphics2D.renderingHints = new RenderingHints(null);
            abstractGraphics2D.renderingHints.putAll((Map<?, ?>)this.renderingHints);
            abstractGraphics2D.transform = new AffineTransform(this.transform);
            return abstractGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            AWTError aWTError = new AWTError("Unexpected exception while cloning");
            aWTError.initCause(cloneNotSupportedException);
            throw aWTError;
        }
    }

    public Color getColor() {
        if (this.isForegroundColorNull) {
            return null;
        }
        return this.foreground;
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void setPaintMode() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setXORMode(Color color) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = null;
        if (this.clip != null) {
            rectangle = this.clip.getBounds();
        }
        return rectangle;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(Shape shape) {
        this.clip = shape;
        if (!(this.clip instanceof Rectangle)) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isOptimized) {
            this.rawCopyArea(n, n2, n3, n4, n5, n6);
        } else {
            this.copyAreaImpl(n, n2, n3, n4, n5, n6);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            int n5 = (int)this.transform.getTranslateX();
            int n6 = (int)this.transform.getTranslateY();
            this.rawDrawLine(n + n5, n2 + n6, n3 + n5, n4 + n6);
        } else {
            ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
            if (shapeCache.line == null) {
                shapeCache.line = new Line2D.Float();
            }
            shapeCache.line.setLine(n, n2, n3, n4);
            this.draw(shapeCache.line);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            int n5 = (int)this.transform.getTranslateX();
            int n6 = (int)this.transform.getTranslateY();
            this.rawDrawRect(n + n5, n2 + n6, n3, n4);
        } else {
            ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
            if (shapeCache.rect == null) {
                shapeCache.rect = new Rectangle();
            }
            shapeCache.rect.setBounds(n, n2, n3, n4);
            this.draw(shapeCache.rect);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            this.rawFillRect(n + (int)this.transform.getTranslateX(), n2 + (int)this.transform.getTranslateY(), n3, n4);
        } else {
            ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
            if (shapeCache.rect == null) {
                shapeCache.rect = new Rectangle();
            }
            shapeCache.rect.setBounds(n, n2, n3, n4);
            this.fill(shapeCache.rect);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            this.rawClearRect(n, n2, n3, n4);
        } else {
            Paint paint = this.getPaint();
            this.setPaint(this.getBackground());
            this.fillRect(n, n2, n3, n4);
            this.setPaint(paint);
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.roundRect == null) {
            shapeCache.roundRect = new RoundRectangle2D.Float();
        }
        shapeCache.roundRect.setRoundRect(n, n2, n3, n4, n5, n6);
        this.draw(shapeCache.roundRect);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.roundRect == null) {
            shapeCache.roundRect = new RoundRectangle2D.Float();
        }
        shapeCache.roundRect.setRoundRect(n, n2, n3, n4, n5, n6);
        this.fill(shapeCache.roundRect);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.ellipse == null) {
            shapeCache.ellipse = new Ellipse2D.Float();
        }
        shapeCache.ellipse.setFrame(n, n2, n3, n4);
        this.draw(shapeCache.ellipse);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.ellipse == null) {
            shapeCache.ellipse = new Ellipse2D.Float();
        }
        shapeCache.ellipse.setFrame(n, n2, n3, n4);
        this.fill(shapeCache.ellipse);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.arc == null) {
            shapeCache.arc = new Arc2D.Float();
        }
        shapeCache.arc.setArc(n, n2, n3, n4, n5, n6, 0);
        this.draw(shapeCache.arc);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.arc == null) {
            shapeCache.arc = new Arc2D.Float();
        }
        shapeCache.arc.setArc(n, n2, n3, n4, n5, n6, 2);
        this.draw(shapeCache.arc);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.polyline == null) {
            shapeCache.polyline = new GeneralPath();
        }
        GeneralPath generalPath = shapeCache.polyline;
        generalPath.reset();
        if (n > 0) {
            generalPath.moveTo(nArray[0], nArray2[0]);
        }
        for (int i = 1; i < n; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        this.fill(generalPath);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.polygon == null) {
            shapeCache.polygon = new Polygon();
        }
        shapeCache.polygon.reset();
        shapeCache.polygon.xpoints = nArray;
        shapeCache.polygon.ypoints = nArray2;
        shapeCache.polygon.npoints = n;
        this.draw(shapeCache.polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.polygon == null) {
            shapeCache.polygon = new Polygon();
        }
        shapeCache.polygon.reset();
        shapeCache.polygon.xpoints = nArray;
        shapeCache.polygon.ypoints = nArray2;
        shapeCache.polygon.npoints = n;
        this.fill(shapeCache.polygon);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        boolean bl;
        if (this.isOptimized) {
            bl = this.rawDrawImage(image, n + (int)this.transform.getTranslateX(), n2 + (int)this.transform.getTranslateY(), imageObserver);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            bl = this.drawImage(image, affineTransform, imageObserver);
        }
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        if (n5 == n3 && n6 == n4) {
            return this.drawImage(image, n, n2, imageObserver);
        }
        Image image2 = AbstractGraphics2D.prepareImage(image, n3, n4);
        return this.drawImage(image2, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        double d = (double)image.getWidth(imageObserver) / (double)n3;
        double d2 = (double)image.getHeight(imageObserver) / (double)n4;
        affineTransform.scale(d, d2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        int n9 = Math.min(n5, n5);
        int n10 = Math.min(n6, n8);
        int n11 = Math.abs(n5 - n7);
        int n12 = Math.abs(n6 - n8);
        int n13 = Math.min(n, n);
        int n14 = Math.min(n2, n4);
        int n15 = Math.abs(n - n3);
        int n16 = Math.abs(n2 - n4);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n9 - n13, n10 - n14);
        double d = (double)n11 / (double)n15;
        double d2 = (double)n12 / (double)n16;
        affineTransform.scale(d, d2);
        Rectangle rectangle = new Rectangle(n9, n10, n11, n12);
        return this.drawImageImpl(image, affineTransform, imageObserver, rectangle);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public void dispose() {
    }

    protected void fillShape(Shape shape, boolean bl) {
        Object object;
        boolean bl2 = false;
        bl2 = bl ? (object = this.renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_ON || object == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT && DEFAULT_TEXT_AA : (object = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING)) == RenderingHints.VALUE_ANTIALIAS_ON;
        object = this.getScanlineConverter();
        int n = 0;
        int n2 = 0;
        if (bl2) {
            n = 2;
            n2 = 4;
        }
        ((ScanlineConverter)object).renderShape(this, shape, this.clip, this.transform, n, n2, this.renderingHints);
        this.freeScanlineConverter((ScanlineConverter)object);
    }

    protected abstract ColorModel getColorModel();

    protected abstract Rectangle getDeviceBounds();

    protected void rawDrawLine(int n, int n2, int n3, int n4) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.line == null) {
            shapeCache.line = new Line2D.Float();
        }
        shapeCache.line.setLine(n, n2, n3, n4);
        this.draw(shapeCache.line);
    }

    protected void rawDrawRect(int n, int n2, int n3, int n4) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.rect == null) {
            shapeCache.rect = new Rectangle();
        }
        shapeCache.rect.setBounds(n, n2, n3, n4);
        this.draw(shapeCache.rect);
    }

    protected void rawClearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        this.setPaint(this.getBackground());
        this.rawFillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    protected void rawFillRect(int n, int n2, int n3, int n4) {
        ShapeCache shapeCache = AbstractGraphics2D.shapeCache;
        if (shapeCache.rect == null) {
            shapeCache.rect = new Rectangle();
        }
        shapeCache.rect.setBounds(n, n2, n3, n4);
        this.fill(shapeCache.rect);
    }

    protected boolean rawDrawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    protected void rawCopyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaImpl(n, n2, n3, n4, n5, n6);
    }

    private void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void renderScanline(int n, ScanlineCoverage scanlineCoverage) {
        Object object;
        PaintContext paintContext = this.getPaintContext();
        int n2 = scanlineCoverage.getMinX();
        int n3 = scanlineCoverage.getMaxX();
        Raster raster = paintContext.getRaster(n2, n, n3 - n2, 1);
        float f = 0.0f;
        float f2 = scanlineCoverage.getMaxCoverage();
        ColorModel colorModel = paintContext.getColorModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        Point point = new Point(raster.getMinX(), raster.getMinY());
        SampleModel sampleModel = raster.getSampleModel();
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBuffer, point);
        WritableRaster writableRaster2 = colorModel.getAlphaRaster(writableRaster);
        ScanlineCoverage.Iterator iterator = scanlineCoverage.iterate();
        while (iterator.hasNext()) {
            object = iterator.next();
            f = (float)((ScanlineCoverage.Range)object).getCoverage() / f2;
            if (!((double)f < 1.0)) continue;
            for (int i = ((ScanlineCoverage.Range)object).getXPos(); i < ((ScanlineCoverage.Range)object).getXPosEnd(); ++i) {
                int n4 = writableRaster2.getSample(i, n, 0);
                n4 = (int)((float)n4 * f);
                writableRaster2.setSample(i, n, 0, n4);
            }
        }
        object = paintContext.getColorModel();
        CompositeContext compositeContext = this.composite.createContext((ColorModel)object, this.getColorModel(), this.renderingHints);
        WritableRaster writableRaster3 = this.getDestinationRaster();
        WritableRaster writableRaster4 = writableRaster3.createWritableTranslatedChild(-n2, -n);
        compositeContext.compose(raster, writableRaster4, writableRaster4);
        this.updateRaster(writableRaster3, n2, n, n3 - n2, 1);
        compositeContext.dispose();
    }

    protected void init() {
        this.setPaint(Color.BLACK);
        this.setFont(FONT);
        this.isOptimized = true;
    }

    protected WritableRaster getDestinationRaster() {
        Rectangle rectangle = this.getDeviceBounds();
        if (this.destinationRaster == null) {
            int[] nArray = new int[]{0xFF0000, 65280, 255};
            this.destinationRaster = Raster.createPackedRaster(3, rectangle.width, rectangle.height, nArray, null);
            int n = this.destinationRaster.getMinX();
            int n2 = this.destinationRaster.getWidth() + n;
            int n3 = this.destinationRaster.getMinY();
            int n4 = this.destinationRaster.getHeight() + n3;
            int n5 = this.destinationRaster.getNumBands();
            for (int i = n3; i < n4; ++i) {
                for (int j = n; j < n2; ++j) {
                    for (int k = 0; k < n5; ++k) {
                        this.destinationRaster.setSample(j, i, k, 255);
                    }
                }
            }
        }
        return this.destinationRaster;
    }

    protected void updateRaster(Raster raster, int n, int n2, int n3, int n4) {
    }

    private void updateOptimization() {
        int n = this.transform.getType();
        boolean bl = false;
        if (n == 0 || n == 1) {
            bl = true;
        }
        boolean bl2 = this.clip == null || this.clip instanceof Rectangle;
        this.isOptimized = bl2 && bl && this.paint instanceof Color && this.composite == AlphaComposite.SrcOver && this.stroke.equals(new BasicStroke());
    }

    private static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    private void updateClip(AffineTransform affineTransform) {
        if (!(this.clip instanceof GeneralPath)) {
            this.clip = new GeneralPath(this.clip);
        }
        GeneralPath generalPath = (GeneralPath)this.clip;
        generalPath.transform(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanlineConverter getScanlineConverter() {
        LinkedList<ScanlineConverter> linkedList = scanlineConverters;
        synchronized (linkedList) {
            ScanlineConverter scanlineConverter = scanlineConverters.size() > 0 ? scanlineConverters.removeFirst() : new ScanlineConverter();
            return scanlineConverter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeScanlineConverter(ScanlineConverter scanlineConverter) {
        LinkedList<ScanlineConverter> linkedList = scanlineConverters;
        synchronized (linkedList) {
            scanlineConverters.addLast(scanlineConverter);
        }
    }

    private PaintContext getPaintContext() {
        if (this.paintContext == null) {
            this.paintContext = this.foreground.createContext(this.getColorModel(), this.getDeviceBounds(), this.getClipBounds(), this.getTransform(), this.getRenderingHints());
        }
        return this.paintContext;
    }

    public static Image prepareImage(Image image, int n, int n2) {
        HashMap<Dimension, Image> hashMap = imageCache.get(image);
        Dimension dimension = new Dimension(n, n2);
        Image image2 = null;
        if (hashMap != null) {
            image2 = hashMap.get(dimension);
        }
        if (image2 == null) {
            Image image3;
            ImageProducer imageProducer = image.getSource();
            ReplicateScaleFilter replicateScaleFilter = new ReplicateScaleFilter(n, n2);
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, replicateScaleFilter);
            image2 = image3 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            if (hashMap == null) {
                hashMap = new HashMap();
                imageCache.put(image, hashMap);
            }
            hashMap.put(dimension, image3);
        }
        return image2;
    }

    static {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        STANDARD_HINTS = hashMap;
    }
}

