/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import java.awt.FontFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;

abstract class GlyphLocator {
    protected ByteBuffer glyfTable;

    GlyphLocator() {
    }

    public static GlyphLocator forTable(int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws FontFormatException {
        switch (n) {
            case 0: {
                return new TwoByte(byteBuffer, byteBuffer2);
            }
            case 1: {
                return new FourByte(byteBuffer, byteBuffer2);
            }
        }
        throw new FontFormatException("unsupported loca format");
    }

    public abstract ByteBuffer getGlyphData(int var1);

    private static final class FourByte
    extends GlyphLocator {
        final IntBuffer indexToLoc;

        FourByte(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            this.glyfTable = byteBuffer2;
            this.indexToLoc = byteBuffer.asIntBuffer();
        }

        public ByteBuffer getGlyphData(int n) {
            int n2;
            int n3 = this.indexToLoc.get(n);
            if (n3 >= (n2 = this.indexToLoc.get(n + 1))) {
                return null;
            }
            this.glyfTable.limit(n2).position(n3);
            return this.glyfTable;
        }
    }

    private static final class TwoByte
    extends GlyphLocator {
        final CharBuffer indexToLoc;

        TwoByte(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            this.glyfTable = byteBuffer2;
            this.indexToLoc = byteBuffer.asCharBuffer();
        }

        public ByteBuffer getGlyphData(int n) {
            int n2;
            int n3 = this.indexToLoc.get(n) << 1;
            if (n3 >= (n2 = this.indexToLoc.get(n + 1) << 1)) {
                return null;
            }
            this.glyfTable.limit(n2).position(n3);
            return this.glyfTable;
        }
    }
}

