/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.font.GNUGlyphVector;
import gnu.java.awt.font.autofit.AutoHinter;
import gnu.java.awt.font.opentype.CharGlyphMap;
import gnu.java.awt.font.opentype.GlyphNamer;
import gnu.java.awt.font.opentype.Hinter;
import gnu.java.awt.font.opentype.NameDecoder;
import gnu.java.awt.font.opentype.Scaler;
import gnu.java.awt.font.opentype.truetype.TrueTypeScaler;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.util.Locale;

public final class OpenTypeFont
implements FontDelegate {
    static final int TAG_OTTO = 0x4F54544F;
    static final int TAG_SFNT = 1936092788;
    static final int TAG_TRUE = 1953658213;
    static final int TAG_TTCF = 1953784678;
    static final int TAG_ZAPF = 1516335206;
    ByteBuffer buf;
    final int numGlyphs;
    int[] tableTag;
    int[] tableStart;
    int[] tableLength;
    private int version;
    public int unitsPerEm;
    private float emsPerUnit;
    private Scaler scaler;
    private CharGlyphMap cmap;
    private GlyphNamer glyphNamer;
    private Hinter hinter;
    private ByteBuffer nameTable;

    OpenTypeFont(ByteBuffer byteBuffer, int n) throws FontFormatException {
        this.buf = byteBuffer;
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.position(n);
        this.version = byteBuffer.getInt();
        switch (this.version) {
            case 65536: 
            case 0x4F54544F: 
            case 1936092788: 
            case 1953658213: 
            case 1954115633: {
                break;
            }
            default: {
                throw new FontFormatException("not in OpenType or TrueType format");
            }
        }
        int n2 = byteBuffer.getShort();
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        this.tableTag = new int[n2];
        this.tableStart = new int[n2];
        this.tableLength = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            this.tableTag[i] = byteBuffer.getInt();
            if (n3 >= this.tableTag[i]) {
                throw new FontFormatException("unordered OpenType table");
            }
            byteBuffer.getInt();
            this.tableStart[i] = byteBuffer.getInt();
            this.tableLength[i] = byteBuffer.getInt();
        }
        ByteBuffer byteBuffer2 = this.getFontTable(1751474532);
        if (byteBuffer2.getInt(0) != 65536 || byteBuffer2.getInt(12) != 1594834165) {
            throw new FontFormatException("unsupported head version");
        }
        this.unitsPerEm = byteBuffer2.getChar(18);
        this.emsPerUnit = 1.0f / (float)this.unitsPerEm;
        ByteBuffer byteBuffer3 = this.getFontTable(1835104368);
        int n4 = byteBuffer3.getInt(0);
        switch (n4) {
            case 20480: {
                this.numGlyphs = byteBuffer3.getChar(4);
                break;
            }
            case 65536: {
                this.numGlyphs = byteBuffer3.getChar(4);
                this.scaler = new TrueTypeScaler(this.unitsPerEm, this.getFontTable(1751672161), this.getFontTable(1752003704), this.getFontTable(1986553185), this.getFontTable(1986884728), byteBuffer3, this.getFontTable(1668707360), this.getFontTable(1718642541), byteBuffer2.getShort(50), this.getFontTable(1819239265), this.getFontTable(1735162214), this.getFontTable(1886545264));
                break;
            }
            default: {
                throw new FontFormatException("unsupported maxp version");
            }
        }
    }

    private int getTableIndex(int n) {
        for (int i = 0; i < this.tableTag.length; ++i) {
            if (this.tableTag[i] != n) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getFamilyName(Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getName(1, locale)) == null) {
            string = this.getName(1, Locale.ENGLISH);
        }
        if (string == null) {
            string = this.getName(1, null);
        }
        if (string == null) {
            string = this.getName(4, locale);
        }
        if (string == null) {
            string = this.getName(4, null);
        }
        return string;
    }

    public synchronized String getSubFamilyName(Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getName(2, locale)) == null && "Regular".equals(string = this.getName(2, Locale.ENGLISH))) {
            string = null;
        }
        if (string == null) {
            String string2 = locale.getLanguage();
            string = "de".equals(string2) ? "Standard" : ("fr".equals(string2) ? "Standard" : ("it".equals(string2) ? "Normale" : ("nl".equals(string2) ? "Normaal" : ("fi".equals(string2) ? "Normaali" : ("sv".equals(string2) ? "Normal" : "Regular")))));
        }
        return string;
    }

    public synchronized String getFullName(Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getName(4, locale)) == null) {
            string = this.getName(4, Locale.ENGLISH);
        }
        if (string == null) {
            string = this.getName(4, null);
        }
        return string;
    }

    public synchronized String getPostScriptName() {
        return this.getName(6, null);
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public int getMissingGlyphCode() {
        return 0;
    }

    private String getName(int n, Locale locale) {
        if (this.nameTable == null) {
            this.nameTable = this.getFontTable(1851878757);
        }
        return NameDecoder.getName(this.nameTable, n, locale);
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized ByteBuffer getFontTable(int n) {
        int n2 = this.getTableIndex(n);
        if (n2 < 0) {
            return null;
        }
        int n3 = this.tableStart[n2];
        int n4 = this.tableLength[n2];
        this.buf.limit(n3 + n4).position(n3);
        ByteBuffer byteBuffer = this.buf.slice();
        byteBuffer.limit(n4);
        return byteBuffer;
    }

    public int getFontTableSize(int n) {
        int n2 = this.getTableIndex(n);
        if (n2 == -1) {
            return n2;
        }
        return this.tableLength[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharGlyphMap getCharGlyphMap() {
        if (this.cmap != null) {
            return this.cmap;
        }
        OpenTypeFont openTypeFont = this;
        synchronized (openTypeFont) {
            if (this.cmap == null) {
                int n = this.getTableIndex(1668112752);
                int n2 = this.tableStart[n];
                this.buf.limit(n2 + this.tableLength[n]).position(n2);
                this.cmap = CharGlyphMap.forTable(this.buf);
            }
            return this.cmap;
        }
    }

    public int getGlyph(int n) {
        return this.getCharGlyphMap().getGlyph(n);
    }

    public synchronized GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        this.checkHinter(1);
        CharGlyphMap charGlyphMap = this.getCharGlyphMap();
        int n = characterIterator.getEndIndex() - characterIterator.getBeginIndex();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = characterIterator.first();
        while (n3 != 65535) {
            if (n3 >> 10 == 54) {
                n3 = ((n3 & 0x3FF) << 10 | characterIterator.next() & 0x3FF) + 65536;
            }
            nArray[n2] = charGlyphMap.getGlyph(n3);
            ++n2;
            n3 = characterIterator.next();
        }
        if (n2 != n) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return new GNUGlyphVector(this, font, fontRenderContext, nArray);
    }

    public int getGlyphIndex(int n) {
        return this.getCharGlyphMap().getGlyph(n);
    }

    public synchronized void getAdvance(int n, float f, AffineTransform affineTransform, boolean bl, boolean bl2, boolean bl3, Point2D point2D) {
        this.scaler.getAdvance(n, f, affineTransform, bl, bl2, bl3, point2D);
    }

    public synchronized GeneralPath getGlyphOutline(int n, float f, AffineTransform affineTransform, boolean bl, boolean bl2, int n2) {
        this.checkHinter(n2);
        return this.scaler.getOutline(n, f, affineTransform, bl, bl2, this.hinter, n2);
    }

    public synchronized Zone getRawGlyphOutline(int n, AffineTransform affineTransform) {
        return this.scaler.getRawOutline(n, affineTransform);
    }

    public synchronized String getGlyphName(int n) {
        if (this.glyphNamer == null) {
            this.glyphNamer = GlyphNamer.forTables(this.numGlyphs, this.getFontTable(1886352244), this.getFontTable(1516335206));
        }
        return this.glyphNamer.getGlyphName(n);
    }

    public synchronized float getAscent(float f, AffineTransform affineTransform, boolean bl, boolean bl2, boolean bl3) {
        return this.scaler.getAscent(f, affineTransform, bl, bl2, bl3);
    }

    public synchronized float getDescent(float f, AffineTransform affineTransform, boolean bl, boolean bl2, boolean bl3) {
        return this.scaler.getDescent(f, affineTransform, bl, bl2, bl3);
    }

    static String tagToString(int n) {
        char[] cArray = new char[]{(char)(n >> 24 & 0xFF), (char)(n >> 16 & 0xFF), (char)(n >> 8 & 0xFF), (char)(n & 0xFF)};
        return new String(cArray);
    }

    private void checkHinter(int n) {
        if (this.hinter == null) {
            try {
                this.hinter = new AutoHinter();
                this.hinter.init(this);
            }
            catch (Exception exception) {
                this.hinter = null;
                exception.printStackTrace();
            }
        }
        this.hinter.setFlags(n);
    }
}

