/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.AxisHints;
import gnu.java.awt.font.autofit.Constants;
import gnu.java.awt.font.autofit.Edge;
import gnu.java.awt.font.autofit.GlyphHints;
import gnu.java.awt.font.autofit.HintScaler;
import gnu.java.awt.font.autofit.LatinAxis;
import gnu.java.awt.font.autofit.LatinBlue;
import gnu.java.awt.font.autofit.LatinMetrics;
import gnu.java.awt.font.autofit.Script;
import gnu.java.awt.font.autofit.ScriptMetrics;
import gnu.java.awt.font.autofit.Segment;
import gnu.java.awt.font.autofit.Utils;
import gnu.java.awt.font.autofit.Width;
import gnu.java.awt.font.opentype.OpenTypeFont;
import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Point;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.geom.AffineTransform;
import java.util.HashSet;

class Latin
implements Script,
Constants {
    static final int MAX_WIDTHS = 16;
    private static final int MAX_TEST_CHARS = 12;
    private static final int CAPITAL_TOP = 0;
    private static final int CAPITAL_BOTTOM = 1;
    private static final int SMALL_F_TOP = 2;
    private static final int SMALL_TOP = 3;
    private static final int SMALL_BOTTOM = 4;
    private static final int SMALL_MINOR = 5;
    static final int BLUE_MAX = 6;
    private static final String[] TEST_CHARS = new String[]{"THEZOCQS", "HEZLOCUS", "fijkdbh", "xzroesc", "xzroesc", "pqgjy"};
    private static final AffineTransform IDENTITY = new AffineTransform();

    Latin() {
    }

    public void applyHints(GlyphHints glyphHints, Zone zone, ScriptMetrics scriptMetrics) {
        glyphHints.reload(zone);
        glyphHints.rescale(scriptMetrics);
        if (glyphHints.doHorizontal()) {
            this.detectFeatures(glyphHints, 0);
        }
        if (glyphHints.doVertical()) {
            this.detectFeatures(glyphHints, 1);
            this.computeBlueEdges(glyphHints, (LatinMetrics)scriptMetrics);
        }
        for (int i = 0; i < 2; ++i) {
            if ((i != 0 || !glyphHints.doHorizontal()) && (i != 1 || !glyphHints.doVertical())) continue;
            this.hintEdges(glyphHints, i);
            if (glyphHints.doAlignEdgePoints()) {
                glyphHints.alignEdgePoints(i);
            }
            if (glyphHints.doAlignStrongPoints()) {
                glyphHints.alignStrongPoints(i);
            }
            if (!glyphHints.doAlignWeakPoints()) continue;
            glyphHints.alignWeakPoints(i);
        }
    }

    private void hintEdges(GlyphHints glyphHints, int n) {
        Object object;
        Edge edge;
        int n2;
        AxisHints axisHints = glyphHints.axis[n];
        Edge[] edgeArray = axisHints.edges;
        int n3 = axisHints.numEdges;
        Edge edge2 = null;
        int n4 = 0;
        if (n == 1) {
            for (n2 = 0; n2 < n3; ++n2) {
                edge = edgeArray[n2];
                if ((edge.flags & 4) != 0) continue;
                object = edge.blueEdge;
                Edge edge3 = null;
                Edge edge4 = edge.link;
                if (object != null) {
                    edge3 = edge;
                } else if (edge4 != null && edge4.blueEdge != null) {
                    object = edge4.blueEdge;
                    edge3 = edge4;
                    edge4 = edge;
                }
                if (edge3 == null) continue;
                edge3.pos = ((Width)object).fit;
                edge3.flags |= 4;
                if (edge4 != null && edge4.blueEdge == null) {
                    this.alignLinkedEdge(glyphHints, n, edge3, edge4);
                    edge4.flags |= 4;
                }
                if (edge2 != null) continue;
                edge2 = edge;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            edge = edgeArray[n2];
            if ((edge.flags & 4) != 0) continue;
            object = edge.link;
            if (object == null) {
                ++n4;
                continue;
            }
            if (((Edge)object).blueEdge != null || axisHints.getEdgeIndex((Edge)object) < n2) {
                this.alignLinkedEdge(glyphHints, n, (Edge)object, edge);
                edge.flags |= 4;
                continue;
            }
            if (edge2 == null) {
                n13 = ((Edge)object).opos - edge.opos;
                n12 = this.computeStemWidth(glyphHints, n, n13, edge.flags, ((Edge)object).flags);
                if (n12 <= 64) {
                    n11 = 32;
                    n10 = 32;
                } else {
                    n11 = 38;
                    n10 = 26;
                }
                if (n12 < 96) {
                    n9 = edge.opos + (n13 >> 1);
                    n8 = Utils.pixRound(n9);
                    n7 = n9 - (n8 - n11);
                    if (n7 < 0) {
                        n7 = -n7;
                    }
                    if ((n6 = n9 - (n8 + n10)) < 0) {
                        n6 = -n6;
                    }
                    n8 = n7 < n6 ? (n8 -= n11) : (n8 += n10);
                    edge.pos = n8 - n12 / 2;
                    ((Edge)object).pos = n8 + n12 / 2;
                } else {
                    edge.pos = Utils.pixRound(edge.opos);
                }
                edge2 = edge;
                edge.flags |= 4;
                this.alignLinkedEdge(glyphHints, n, edge, (Edge)object);
                continue;
            }
            n13 = edge.opos - edge2.opos;
            n12 = edge2.pos + n13;
            n11 = ((Edge)object).opos - edge.opos;
            n10 = n12 + (n11 >> 1);
            n9 = this.computeStemWidth(glyphHints, n, n11, edge.flags, ((Edge)object).flags);
            if (n9 < 96) {
                int n14;
                n6 = Utils.pixRound(n10);
                if (n9 <= 64) {
                    n8 = 32;
                    n7 = 32;
                } else {
                    n8 = 38;
                    n7 = 26;
                }
                n5 = n10 - (n6 - n8);
                if (n5 < 0) {
                    n5 = -n5;
                }
                if ((n14 = n10 - (n6 + n7)) < 0) {
                    n14 = -n14;
                }
                n6 = n5 < n14 ? (n6 -= n8) : (n6 += n7);
                edge.pos = n6 - n9 / 2;
                ((Edge)object).pos = n6 + n9 / 2;
            } else {
                n12 = edge2.pos + (edge.opos - edge2.opos);
                n11 = ((Edge)object).opos - edge.opos;
                n10 = n12 + (n11 >> 1);
                n9 = this.computeStemWidth(glyphHints, n, n11, edge.flags, ((Edge)object).flags);
                n8 = Utils.pixRound(n12);
                n7 = n8 + (n9 >> 1) - n10;
                if (n7 < 0) {
                    n7 = -n7;
                }
                if ((n5 = (n6 = Utils.pixRound(n12 + n11) - n9) + (n9 >> 1) - n10) < 0) {
                    n5 = -n5;
                }
                edge.pos = n7 < n5 ? n8 : n6;
                ((Edge)object).pos = edge.pos + n9;
            }
            edge.flags |= 4;
            ((Edge)object).flags |= 4;
            if (n2 <= 0 || edge.pos >= edgeArray[n2 - 1].pos) continue;
            edge.pos = edgeArray[n2 - 1].pos;
        }
        if (n4 > 0 || edge2 == null) {
            for (n2 = 0; n2 < n3; ++n2) {
                edge = edgeArray[n2];
                if ((edge.flags & 4) != 0) continue;
                if (edge.serif != null) {
                    this.alignSerifEdge(glyphHints, edge.serif, edge);
                } else if (edge2 == null) {
                    edge.pos = Utils.pixRound(edge.opos);
                    edge2 = edge;
                } else {
                    edge.pos = edge2.pos + Utils.pixRound(edge.opos - edge2.opos);
                }
                edge.flags |= 4;
                if (n2 > 0 && edge.pos < edgeArray[n2 - 1].pos) {
                    edge.pos = edgeArray[n2 - 1].pos;
                }
                if (n2 + 1 >= n3 || (edgeArray[n2 + 1].flags & 4) == 0 || edge.pos <= edgeArray[n2 + 1].pos) continue;
                edge.pos = edgeArray[n2 + 1].pos;
            }
        }
    }

    private void alignSerifEdge(GlyphHints glyphHints, Edge edge, Edge edge2) {
        edge2.pos = edge.pos + (edge2.opos - edge.opos);
    }

    private int computeStemWidth(GlyphHints glyphHints, int n, int n2, int n3, int n4) {
        boolean bl;
        LatinMetrics latinMetrics = (LatinMetrics)glyphHints.metrics;
        LatinAxis latinAxis = latinMetrics.axis[n];
        int n5 = n2;
        int n6 = 0;
        boolean bl2 = bl = n == 1;
        if (!this.doStemAdjust(glyphHints)) {
            return n2;
        }
        if (n5 < 0) {
            n5 = -n2;
            n6 = 1;
        }
        if (bl && !this.doVertSnap(glyphHints) || !bl && !this.doHorzSnap(glyphHints)) {
            if ((n4 & 2) != 0 && bl && n5 < 192) {
                return this.doneWidth(n5, n6);
            }
            if ((n3 & 1) != 0) {
                if (n5 < 80) {
                    n5 = 64;
                }
            } else if (n5 < 56) {
                n5 = 56;
            }
            if (latinAxis.widthCount > 0) {
                int n7;
                if (latinAxis.widthCount > 0) {
                    n7 = n5 - latinAxis.widths[0].cur;
                    if (n7 < 0) {
                        n7 = -n7;
                    }
                    if (n7 < 40) {
                        n5 = latinAxis.widths[0].cur;
                        if (n5 < 48) {
                            n5 = 48;
                        }
                        return this.doneWidth(n5, n6);
                    }
                }
                if (n5 < 192) {
                    n7 = n5 & 0x3F;
                    n5 &= 0xFFFFFFC0;
                    n5 = n7 < 10 ? (n5 += n7) : (n7 < 32 ? (n5 += 10) : (n7 < 54 ? (n5 += 54) : (n5 += n7)));
                } else {
                    n5 = n5 + 32 & 0xFFFFFFC0;
                }
            }
        } else {
            n5 = this.snapWidth(latinAxis.widths, latinAxis.widthCount, n5);
            n5 = bl ? (n5 >= 64 ? n5 + 16 & 0xFFFFFFC0 : 64) : (this.doMono(glyphHints) ? (n5 < 64 ? 64 : n5 + 32 & 0xFFFFFFC0) : (n5 < 48 ? n5 + 64 >> 1 : (n5 < 128 ? n5 + 22 & 0xFFFFFFC0 : n5 + 32 & 0xFFFFFFC0)));
        }
        return this.doneWidth(n5, n6);
    }

    private boolean doMono(GlyphHints glyphHints) {
        return true;
    }

    private int snapWidth(Width[] widthArray, int n, int n2) {
        int n3;
        int n4 = 98;
        int n5 = n2;
        for (n3 = 0; n3 < n; ++n3) {
            int n6 = widthArray[n3].cur;
            int n7 = n2 - n6;
            if (n7 < 0) {
                n7 = -n7;
            }
            if (n7 >= n4) continue;
            n4 = n7;
            n5 = n6;
        }
        n3 = Utils.pixRound(n5);
        if (n2 >= n5) {
            if (n2 < n3 + 48) {
                n2 = n5;
            }
        } else if (n2 > n3 + 48) {
            n2 = n5;
        }
        return n2;
    }

    private int doneWidth(int n, int n2) {
        if (n2 == 1) {
            n = -n;
        }
        return n;
    }

    private boolean doVertSnap(GlyphHints glyphHints) {
        return true;
    }

    private boolean doHorzSnap(GlyphHints glyphHints) {
        return true;
    }

    private boolean doStemAdjust(GlyphHints glyphHints) {
        return true;
    }

    private void alignLinkedEdge(GlyphHints glyphHints, int n, Edge edge, Edge edge2) {
        int n2 = edge2.opos - edge.opos;
        int n3 = this.computeStemWidth(glyphHints, n, n2, edge.flags, edge2.flags);
        edge2.pos = edge.pos + n3;
    }

    public void doneMetrics(ScriptMetrics scriptMetrics) {
    }

    public void initHints(GlyphHints glyphHints, ScriptMetrics scriptMetrics) {
        glyphHints.rescale(scriptMetrics);
        LatinMetrics latinMetrics = (LatinMetrics)scriptMetrics;
        glyphHints.xScale = latinMetrics.axis[0].scale;
        glyphHints.xDelta = latinMetrics.axis[0].delta;
        glyphHints.yScale = latinMetrics.axis[1].scale;
        glyphHints.yDelta = latinMetrics.axis[1].delta;
    }

    public void initMetrics(ScriptMetrics scriptMetrics, OpenTypeFont openTypeFont) {
        assert (scriptMetrics instanceof LatinMetrics);
        LatinMetrics latinMetrics = (LatinMetrics)scriptMetrics;
        latinMetrics.unitsPerEm = openTypeFont.unitsPerEm;
        this.initWidths(latinMetrics, openTypeFont, 'o');
        this.initBlues(latinMetrics, openTypeFont);
    }

    public void scaleMetrics(ScriptMetrics scriptMetrics, HintScaler hintScaler) {
        LatinMetrics latinMetrics = (LatinMetrics)scriptMetrics;
        latinMetrics.scaler.renderMode = hintScaler.renderMode;
        latinMetrics.scaler.face = hintScaler.face;
        this.scaleMetricsDim(latinMetrics, hintScaler, 0);
        this.scaleMetricsDim(latinMetrics, hintScaler, 1);
    }

    private void scaleMetricsDim(LatinMetrics latinMetrics, HintScaler hintScaler, int n) {
        int n2;
        int n3;
        int n4;
        if (n == 0) {
            n4 = hintScaler.xScale;
            n3 = hintScaler.xDelta;
        } else {
            n4 = hintScaler.yScale;
            n3 = hintScaler.yDelta;
        }
        LatinAxis latinAxis = latinMetrics.axis[n];
        if (latinAxis.orgScale == n4 && latinAxis.orgDelta == n3) {
            return;
        }
        latinAxis.orgScale = n4;
        latinAxis.orgDelta = n3;
        LatinAxis latinAxis2 = latinMetrics.axis[1];
        LatinBlue latinBlue = null;
        latinAxis.scale = n4;
        latinAxis.delta = n3;
        if (n == 0) {
            latinMetrics.scaler.xScale = n4;
            latinMetrics.scaler.xDelta = n3;
        } else {
            latinMetrics.scaler.yScale = n4;
            latinMetrics.scaler.yDelta = n3;
        }
        for (n2 = 0; n2 < latinAxis.widthCount; ++n2) {
            Width width = latinAxis.widths[n2];
            width.fit = width.cur = Fixed.mul16(width.org, n4);
        }
        if (n == 1) {
            for (n2 = 0; n2 < latinAxis.blueCount; ++n2) {
                int n5;
                latinBlue = latinAxis.blues[n2];
                latinBlue.ref.fit = latinBlue.ref.cur = Fixed.mul16(latinBlue.ref.org, n4) + n3;
                latinBlue.shoot.cur = Fixed.mul16(latinBlue.ref.org, n4) + n3;
                latinBlue.flags &= 0xFFFFFFFE;
                int n6 = Fixed.mul16(latinBlue.ref.org - latinBlue.shoot.org, n4);
                if (n6 > 48 || n6 < -48) continue;
                int n7 = n5 = latinBlue.shoot.org - latinBlue.ref.org;
                if (n5 < 0) {
                    n7 = -n7;
                }
                n7 = (n7 = Fixed.mul16(n7, n4)) < 32 ? 0 : (n7 < 64 ? 32 + (n7 - 32 + 16 & 0xFFFFFFE0) : Utils.pixRound(n7));
                if (n5 < 0) {
                    n7 = -n7;
                }
                latinBlue.ref.fit = Utils.pixRound(latinBlue.ref.cur);
                latinBlue.shoot.fit = latinBlue.ref.fit + n7;
                latinBlue.flags |= 1;
            }
        }
    }

    private void initWidths(LatinMetrics latinMetrics, OpenTypeFont openTypeFont, char c) {
        LatinAxis latinAxis;
        int n;
        GlyphHints glyphHints = new GlyphHints();
        latinMetrics.axis[0].widthCount = 0;
        latinMetrics.axis[1].widthCount = 0;
        int n2 = openTypeFont.getGlyph(c);
        Zone zone = openTypeFont.getRawGlyphOutline(n2, IDENTITY);
        LatinMetrics latinMetrics2 = new LatinMetrics();
        HintScaler hintScaler = latinMetrics2.scaler;
        latinMetrics2.unitsPerEm = latinMetrics.unitsPerEm;
        hintScaler.yScale = 10000;
        hintScaler.xScale = 10000;
        hintScaler.yDelta = 0;
        hintScaler.xDelta = 0;
        hintScaler.face = openTypeFont;
        glyphHints.rescale(latinMetrics2);
        glyphHints.reload(zone);
        for (n = 0; n < 2; ++n) {
            latinAxis = latinMetrics.axis[n];
            AxisHints axisHints = glyphHints.axis[n];
            int n3 = 0;
            this.computeSegments(glyphHints, n);
            this.linkSegments(glyphHints, n);
            Segment[] segmentArray = axisHints.segments;
            HashSet<Segment> hashSet = new HashSet<Segment>();
            for (int i = 0; i < segmentArray.length; ++i) {
                Segment segment = segmentArray[i];
                Segment segment2 = segment.link;
                if (segment2 != null && segment2.link == segment && !hashSet.contains(segment2)) {
                    int n4 = Math.abs(segment.pos - segment2.pos);
                    if (n3 < 16) {
                        latinAxis.widths[n3++] = new Width(n4);
                    }
                }
                hashSet.add(segment);
            }
            Utils.sort(n3, latinAxis.widths);
            latinAxis.widthCount = n3;
        }
        for (n = 0; n < 2; ++n) {
            latinAxis = latinMetrics.axis[n];
            int n5 = latinAxis.widthCount > 0 ? latinAxis.widths[0].org : this.constant(latinMetrics, 50);
            latinAxis.edgeDistanceTreshold = n5 / 5;
        }
    }

    void linkSegments(GlyphHints glyphHints, int n) {
        Segment segment;
        int n2;
        AxisHints axisHints = glyphHints.axis[n];
        Segment[] segmentArray = axisHints.segments;
        int n3 = axisHints.numSegments;
        int n4 = axisHints.majorDir;
        int n5 = this.constant((LatinMetrics)glyphHints.metrics, 8);
        n5 = Math.min(1, n5);
        int n6 = this.constant((LatinMetrics)glyphHints.metrics, 3000);
        for (n2 = 0; n2 < n3; ++n2) {
            segment = segmentArray[n2];
            if (segment.first == segment.last || segment.dir != n4) continue;
            for (int i = 0; i < n3; ++i) {
                int n7;
                int n8;
                Segment segment2 = segmentArray[i];
                if (segment2 == segment || segment.dir + segment2.dir != 0) continue;
                int n9 = segment.pos;
                int n10 = segment2.pos;
                int n11 = n8 = n == 1 ? n9 - n10 : n10 - n9;
                if (n8 < 0) continue;
                int n12 = segment.minPos;
                int n13 = segment.maxPos;
                if (n12 < segment2.minPos) {
                    n12 = segment2.minPos;
                }
                if (n13 > segment2.maxPos) {
                    n13 = segment2.maxPos;
                }
                if ((n7 = n13 - n12) <= n5) continue;
                int n14 = n8 + n6 / n7;
                if (n14 < segment.score) {
                    segment.score = n14;
                    segment.link = segment2;
                }
                if (n14 >= segment2.score) continue;
                segment2.score = n14;
                segment2.link = segment;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            segment = segmentArray[n2];
            Segment segment3 = segment.link;
            if (segment3 == null) continue;
            ++segment3.numLinked;
            if (segment3.link == segment) continue;
            segment.link = null;
            segment.serif = segment3.link;
        }
    }

    private void initBlues(LatinMetrics latinMetrics, OpenTypeFont openTypeFont) {
        int[] nArray = new int[12];
        int[] nArray2 = new int[12];
        LatinAxis latinAxis = latinMetrics.axis[1];
        for (int i = 0; i < 6; ++i) {
            int n;
            int n2;
            String string = TEST_CHARS[i];
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < string.length(); ++n2) {
                boolean bl;
                int n5;
                int n6;
                int n7;
                n = openTypeFont.getGlyph(string.charAt(n2));
                Zone zone = openTypeFont.getRawGlyphOutline(n, IDENTITY);
                int n8 = zone.getSize() - 4;
                Point[] pointArray = zone.getPoints();
                Point point = pointArray[0];
                int n9 = 0;
                if (this.isTopBlue(i)) {
                    for (n7 = 1; n7 < n8; ++n7) {
                        point = pointArray[n7];
                        if (point.getOrigY() >= pointArray[n9].getOrigY()) continue;
                        n9 = n7;
                    }
                } else {
                    while (n7 < n8) {
                        point = pointArray[n7];
                        if (point.getOrigY() > pointArray[n9].getOrigY()) {
                            n9 = n7;
                        }
                        ++n7;
                    }
                }
                int n10 = n9;
                int n11 = -1;
                int n12 = 0;
                for (int j = 0; j < zone.getNumContours(); ++j) {
                    int n13 = zone.getContourEnd(j);
                    if (n13 >= n10) {
                        n11 = n13;
                        break;
                    }
                    n12 = n13 + 1;
                }
                assert (n11 >= 0);
                int n14 = n6 = n10;
                do {
                    if (n6 > n12) {
                        --n6;
                        continue;
                    }
                    n6 = n11;
                } while ((n5 = pointArray[n6].getOrigY() - pointArray[n9].getOrigY()) >= -5 && n5 <= 5 && n6 != n10);
                do {
                    if (n14 < n11) {
                        ++n14;
                        continue;
                    }
                    n14 = n12;
                } while ((n5 = pointArray[n14].getOrigY() - pointArray[n9].getOrigY()) >= -5 && n5 <= 5 && n14 != n10);
                boolean bl2 = bl = pointArray[n6].isControlPoint() || pointArray[n14].isControlPoint();
                if (bl) {
                    nArray2[n4++] = pointArray[n9].getOrigY();
                    continue;
                }
                nArray[n3++] = pointArray[n9].getOrigY();
            }
            Utils.sort(n4, nArray2);
            Utils.sort(n3, nArray);
            LatinBlue latinBlue = latinAxis.blues[latinAxis.blueCount] = new LatinBlue();
            ++latinAxis.blueCount;
            if (n3 == 0) {
                latinBlue.ref = latinBlue.shoot = new Width(nArray2[n4 / 2]);
            } else if (n4 == 0) {
                latinBlue.ref = latinBlue.shoot = new Width(nArray[n3 / 2]);
            } else {
                latinBlue.ref = new Width(nArray[n3 / 2]);
                latinBlue.shoot = new Width(nArray2[n4 / 2]);
            }
            if (latinBlue.shoot != latinBlue.ref) {
                boolean bl;
                n = latinBlue.shoot.org;
                n2 = latinBlue.ref.org;
                boolean bl3 = bl = n < n2;
                if (this.isTopBlue(i) ^ bl) {
                    latinBlue.shoot = latinBlue.ref = new Width((n + n2) / 2);
                }
            }
            latinBlue.flags = 0;
            if (this.isTopBlue(i)) {
                latinBlue.flags |= 2;
            }
            if (i != 3) continue;
            latinBlue.flags |= 4;
        }
    }

    private int constant(LatinMetrics latinMetrics, int n) {
        return n * (latinMetrics.unitsPerEm / 2048);
    }

    private void computeSegments(GlyphHints glyphHints, int n) {
        int n2;
        int n3;
        Point[] pointArray = glyphHints.points;
        if (n == 0) {
            for (n3 = 0; n3 < glyphHints.numPoints; ++n3) {
                pointArray[n3].setU(pointArray[n3].getOrigX());
                pointArray[n3].setV(pointArray[n3].getOrigY());
            }
        } else {
            for (n3 = 0; n3 < glyphHints.numPoints; ++n3) {
                pointArray[n3].setU(pointArray[n3].getOrigY());
                pointArray[n3].setV(pointArray[n3].getOrigX());
            }
        }
        AxisHints axisHints = glyphHints.axis[n];
        int n4 = n2 = Math.abs(axisHints.majorDir);
        Point[] pointArray2 = glyphHints.contours;
        int n5 = glyphHints.numContours;
        Segment segment = null;
        block2: for (int i = 0; i < n5; ++i) {
            int n6 = 32000;
            int n7 = -32000;
            Point point = pointArray2[i];
            Point point2 = point.getPrev();
            if (point == point2) continue;
            if (Math.abs(point2.getOutDir()) == n2 && Math.abs(point.getOutDir()) == n2) {
                point2 = point;
                do {
                    if (Math.abs((point = point.getPrev()).getOutDir()) == n2) continue;
                    point = point.getNext();
                    break;
                } while (point != point2);
            }
            point2 = point;
            boolean bl = false;
            boolean bl2 = false;
            while (true) {
                if (bl2) {
                    int n8 = point.getU();
                    if (n8 < n6) {
                        n6 = n8;
                    }
                    if (n8 > n7) {
                        n7 = n8;
                    }
                    if (point.getOutDir() != n4 || point == point2) {
                        segment.last = point;
                        segment.pos = n6 + n7 >> 1;
                        if (segment.first.isControlPoint() || point.isControlPoint()) {
                            segment.flags |= 1;
                        }
                        n6 = n7 = point.getV();
                        int n9 = segment.first.getV();
                        if (n9 < n6) {
                            n6 = n9;
                        }
                        if (n9 > n7) {
                            n7 = n9;
                        }
                        segment.minPos = n6;
                        segment.maxPos = n7;
                        bl2 = false;
                        segment = null;
                    }
                }
                if (point == point2) {
                    if (bl) continue block2;
                    bl = true;
                }
                if (!bl2 && Math.abs(point.getOutDir()) == n2) {
                    n4 = point.getOutDir();
                    segment = axisHints.newSegment();
                    segment.dir = n4;
                    segment.flags = 0;
                    n6 = n7 = point.getU();
                    segment.first = point;
                    segment.last = point;
                    segment.contour = pointArray2[i];
                    segment.score = 32000;
                    segment.len = 0;
                    segment.link = null;
                    bl2 = true;
                }
                point = point.getNext();
            }
        }
    }

    private boolean isTopBlue(int n) {
        return n == 0 || n == 2 || n == 3;
    }

    private void detectFeatures(GlyphHints glyphHints, int n) {
        this.computeSegments(glyphHints, n);
        this.linkSegments(glyphHints, n);
        this.computeEdges(glyphHints, n);
    }

    private void computeEdges(GlyphHints glyphHints, int n) {
        int n2;
        Edge edge;
        Segment segment;
        int n3;
        AxisHints axisHints = glyphHints.axis[n];
        LatinAxis latinAxis = ((LatinMetrics)glyphHints.metrics).axis[n];
        Segment[] segmentArray = axisHints.segments;
        int n4 = axisHints.numSegments;
        axisHints.numEdges = 0;
        int n5 = n == 0 ? glyphHints.xScale : glyphHints.yScale;
        int n6 = n == 0 ? 2 : 1;
        int n7 = Fixed.mul16(latinAxis.edgeDistanceTreshold, n5);
        if (n7 > 16) {
            n7 = 16;
        }
        n7 = Fixed.div16(n7, n5);
        for (n3 = 0; n3 < n4; ++n3) {
            segment = segmentArray[n3];
            edge = null;
            for (int i = 0; i < axisHints.numEdges; ++i) {
                Edge edge2 = axisHints.edges[i];
                n2 = segment.pos - edge2.fpos;
                if (n2 < 0) {
                    n2 = -n2;
                }
                if (n2 >= n7) continue;
                edge = edge2;
                break;
            }
            if (edge == null) {
                Edge edge3 = axisHints.newEdge(segment.pos);
                edge3.first = segment;
                edge3.last = segment;
                edge3.fpos = segment.pos;
                edge3.opos = edge3.pos = Fixed.mul16(segment.pos, n5);
                segment.edgeNext = segment;
                segment.edge = edge3;
                continue;
            }
            segment.edgeNext = edge.first;
            edge.last.edgeNext = segment;
            edge.last = segment;
            segment.edge = edge;
        }
        for (n3 = 0; n3 < axisHints.numEdges; ++n3) {
            edge = axisHints.edges[n3];
            int n8 = 0;
            int n9 = 0;
            n2 = 0;
            int n10 = 0;
            segment = edge.first;
            do {
                boolean bl;
                if ((segment.flags & 1) != 0) {
                    ++n8;
                } else {
                    ++n9;
                }
                if (segment.dir == n6) {
                    n2 += segment.maxPos - segment.minPos;
                } else {
                    n10 += segment.maxPos - segment.minPos;
                }
                boolean bl2 = bl = segment.serif != null && segment.serif.edge != edge;
                if (segment.link == null && !bl) continue;
                Edge edge4 = edge.link;
                Segment segment2 = segment.link;
                if (bl) {
                    segment2 = segment.serif;
                    edge4 = edge.serif;
                }
                if (edge4 != null) {
                    int n11;
                    int n12 = edge.fpos - edge4.fpos;
                    if (n12 < 0) {
                        n12 = -n12;
                    }
                    if ((n11 = segment.pos - segment2.pos) < 0) {
                        n11 = -n11;
                    }
                    if (n11 < n12) {
                        edge4 = segment2.edge;
                    }
                } else {
                    edge4 = segment2.edge;
                }
                if (bl) {
                    edge.serif = edge4;
                    edge4.flags |= 2;
                    continue;
                }
                edge.link = edge4;
            } while ((segment = segment.edgeNext) != edge.first);
            edge.flags = 0;
            if (n8 > 0 && n8 > n9) {
                edge.flags |= 1;
            }
            edge.dir = 0;
            if (n2 > n10) {
                edge.dir = n6;
            } else if (n2 < n10) {
                edge.dir = -n6;
            } else if (n2 == n10) {
                edge.dir = 0;
            }
            if (edge.serif == null || edge.link == null) continue;
            edge.serif = null;
        }
    }

    private void computeBlueEdges(GlyphHints glyphHints, LatinMetrics latinMetrics) {
        AxisHints axisHints = glyphHints.axis[1];
        Edge[] edgeArray = axisHints.edges;
        int n = axisHints.numEdges;
        LatinAxis latinAxis = latinMetrics.axis[1];
        int n2 = latinAxis.scale;
        for (int i = 0; i < n; ++i) {
            Edge edge = edgeArray[i];
            Width width = null;
            int n3 = Fixed.mul16(latinMetrics.unitsPerEm / 40, n2);
            if (n3 > 32) {
                n3 = 32;
            }
            for (int j = 0; j < 6; ++j) {
                boolean bl;
                boolean bl2;
                LatinBlue latinBlue = latinAxis.blues[j];
                if ((latinBlue.flags & 1) == 0) continue;
                boolean bl3 = (latinBlue.flags & 2) != 0;
                boolean bl4 = bl2 = edge.dir == axisHints.majorDir;
                if (!(bl3 ^ bl2)) continue;
                int n4 = edge.fpos - latinBlue.ref.org;
                if (n4 < 0) {
                    n4 = -n4;
                }
                if ((n4 = Fixed.mul16(n4, n2)) < n3) {
                    n3 = n4;
                    width = latinBlue.ref;
                }
                if ((edge.flags & 1) == 0 || n4 == 0) continue;
                boolean bl5 = bl = edge.fpos > latinBlue.ref.org;
                if (!(bl3 ^ bl)) continue;
                latinBlue = latinAxis.blues[j];
                n4 = edge.fpos - latinBlue.shoot.org;
                if (n4 < 0) {
                    n4 = -n4;
                }
                if ((n4 = Fixed.mul16(n4, n2)) >= n3) continue;
                n3 = n4;
                width = latinBlue.shoot;
            }
            if (width == null) continue;
            edge.blueEdge = width;
        }
    }
}

