/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.AxisHints;
import gnu.java.awt.font.autofit.Constants;
import gnu.java.awt.font.autofit.Edge;
import gnu.java.awt.font.autofit.ScriptMetrics;
import gnu.java.awt.font.autofit.Segment;
import gnu.java.awt.font.autofit.Utils;
import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Point;
import gnu.java.awt.font.opentype.truetype.Zone;

class GlyphHints
implements Constants {
    int xScale;
    int xDelta;
    int yScale;
    int yDelta;
    AxisHints[] axis = new AxisHints[2];
    Point[] points;
    int numPoints;
    int maxPoints;
    Point[] contours;
    int numContours;
    int maxContours;
    ScriptMetrics metrics;
    int flags;

    GlyphHints() {
        this.axis[1] = new AxisHints();
        this.axis[0] = new AxisHints();
        this.xScale = 64;
        this.yScale = 64;
    }

    void rescale(ScriptMetrics scriptMetrics) {
        this.metrics = scriptMetrics;
    }

    void reload(Zone zone) {
        int n;
        Object object;
        this.numPoints = 0;
        this.numContours = 0;
        this.axis[0].numSegments = 0;
        this.axis[0].numEdges = 0;
        this.axis[1].numSegments = 0;
        this.axis[1].numEdges = 0;
        int n2 = zone.getNumContours();
        if (n2 > this.maxContours || this.contours == null) {
            n2 = n2 + 3 & 0xFFFFFFFC;
            object = new Point[n2];
            if (this.contours != null) {
                System.arraycopy(this.contours, 0, object, 0, this.maxContours);
            }
            this.contours = object;
            this.maxContours = n2;
        }
        if ((n2 = zone.getSize() + 2) > this.maxPoints || this.points == null) {
            n2 = n2 + 2 + 7 & 0xFFFFFFF8;
            object = new Point[n2];
            if (this.points != null) {
                System.arraycopy(this.points, 0, object, 0, this.maxPoints);
            }
            this.points = object;
            this.maxPoints = n2;
        }
        this.numPoints = zone.getSize() - 4;
        this.numContours = zone.getNumContours();
        this.axis[0].majorDir = 2;
        this.axis[1].majorDir = -1;
        this.xScale = Fixed.valueOf16(zone.scaleX * 64.0);
        this.yScale = Fixed.valueOf16(zone.scaleY * 64.0);
        System.arraycopy(zone.getPoints(), 0, this.points, 0, this.numPoints);
        this.contours = new Point[this.numContours];
        object = this.points[0];
        int n3 = 0;
        for (n = 0; n < this.numPoints; ++n) {
            if (zone.isContourEnd(n)) {
                this.points[n].setNext((Point)object);
                ((Point)object).setPrev(this.points[n]);
                this.contours[n3] = object;
                ++n3;
                object = n < this.numPoints - 1 ? this.points[n + 1] : null;
                continue;
            }
            this.points[n].setNext(this.points[n + 1]);
            this.points[n + 1].setPrev(this.points[n]);
        }
        for (n = 0; n < this.numPoints; ++n) {
            Point point = this.points[n];
            Point point2 = point.getPrev();
            int n4 = point.getOrigX() - point2.getOrigX();
            int n5 = point.getOrigY() - point2.getOrigY();
            point.setInDir(Utils.computeDirection(n4, n5));
            Point point3 = point.getNext();
            int n6 = point3.getOrigX() - point.getOrigX();
            int n7 = point3.getOrigY() - point.getOrigY();
            point.setOutDir(Utils.computeDirection(n6, n7));
            if (point.isControlPoint()) {
                this.setWeakPoint(point);
                continue;
            }
            if (point.getOutDir() == point.getInDir()) {
                int n8;
                if (point.getOutDir() != 0) {
                    this.setWeakPoint(point);
                    continue;
                }
                int n9 = Utils.atan(n5, n4);
                int n10 = Utils.angleDiff(n9, n8 = Utils.atan(n7, n6));
                if (n10 >= 2 || n10 <= -2) continue;
                this.setWeakPoint(point);
                continue;
            }
            if (point.getInDir() != -point.getOutDir()) continue;
            this.setWeakPoint(point);
        }
        this.computeInflectionPoints();
    }

    private void setWeakPoint(Point point) {
        point.setFlags((byte)(point.getFlags() | 0x10));
    }

    private void computeInflectionPoints() {
        block0: for (int i = 0; i < this.contours.length; ++i) {
            Point point;
            Point point2 = point = this.contours[i];
            Point point3 = point;
            Point point4 = point;
            while ((point4 = point4.getNext()) != point2) {
                int n;
                if (point4.getOrigX() == point2.getOrigX() && point4.getOrigY() == point2.getOrigY()) continue;
                Point point5 = point3;
                int n2 = Utils.atan(point4.getOrigX() - point3.getOrigX(), point4.getOrigY() - point3.getOrigY());
                do {
                    point3 = point5;
                    if ((point5 = point5.getPrev()) == point2) continue block0;
                } while (point5.getOrigX() == point3.getOrigX() && point5.getOrigY() == point3.getOrigY() || (n = Utils.atan(point3.getOrigX() - point5.getOrigX(), point3.getOrigY() - point5.getOrigY())) == n2);
                point2 = point3;
                int n3 = Utils.angleDiff(n, n2);
                boolean bl = false;
                do {
                    int n4;
                    Point point6 = point4;
                    do {
                        point4 = point6;
                        if ((point6 = point6.getNext()) != point2) continue;
                        bl = true;
                    } while (point4.getOrigX() == point6.getOrigX() && point4.getOrigY() == point6.getOrigY() || (n4 = Utils.atan(point6.getOrigX() - point4.getOrigX(), point6.getOrigY() - point4.getOrigY())) == n2);
                    int n5 = Utils.angleDiff(n2, n4);
                    if ((n3 ^ n5) < 0) {
                        do {
                            point3.addFlags((short)32);
                        } while ((point3 = point3.getNext()) != point4);
                        point3.addFlags((short)32);
                    }
                    point3 = point4;
                    point4 = point6;
                    n2 = n4;
                    n3 = n5;
                } while (!bl);
            }
        }
    }

    boolean doHorizontal() {
        return (this.flags & 2) == 0;
    }

    boolean doVertical() {
        return (this.flags & 4) == 0;
    }

    void alignWeakPoints(int n) {
        Point point;
        int n2;
        int n3;
        if (n == 0) {
            n3 = 64;
            for (n2 = 0; n2 < this.numPoints; ++n2) {
                point = this.points[n2];
                point.setU(point.getX());
                point.setV(point.getScaledX());
            }
        } else {
            n3 = 128;
            for (n2 = 0; n2 < this.numPoints; ++n2) {
                point = this.points[n2];
                point.setU(point.getY());
                point.setV(point.getScaledY());
            }
        }
        point = this.points[0];
        for (n2 = 0; n2 < this.numContours; ++n2) {
            point = this.contours[n2];
            int n4 = this.getPointIndex(point);
            Point point2 = point.getPrev();
            int n5 = this.getPointIndex(point2);
            int n6 = n4;
            while (n4 <= n5 && (point.getFlags() & n3) == 0) {
                point = this.points[++n4];
            }
            if (n4 > n5) continue;
            int n7 = n4;
            int n8 = n4++;
            point = this.points[n4];
            while (n4 <= n5) {
                if ((point.getFlags() & n3) != 0) {
                    this.iupInterp(n8 + 1, n4 - 1, n8, n4);
                    n8 = n4;
                }
                point = this.points[++n4];
            }
            if (n8 == n7) {
                this.iupShift(n6, n5, n8);
                continue;
            }
            this.iupInterp(n8 + 1, n5, n8, n7);
            if (n7 <= 0) continue;
            this.iupInterp(n6, n7 - 1, n8, n7);
        }
        if (n == 0) {
            for (n2 = 0; n2 < this.numPoints; ++n2) {
                point = this.points[n2];
                point.setX(point.getU());
            }
        } else {
            for (n2 = 0; n2 < this.numPoints; ++n2) {
                point = this.points[n2];
                point.setY(point.getU());
            }
        }
    }

    private void iupShift(int n, int n2, int n3) {
        int n4;
        int n5 = this.points[n3].getU() - this.points[n3].getV();
        for (n4 = n; n4 < n3; ++n4) {
            this.points[n4].setU(this.points[n4].getV() + n5);
        }
        for (n4 = n3 + 1; n4 <= n2; ++n4) {
            this.points[n4].setU(this.points[n4].getV() + n5);
        }
    }

    private void iupInterp(int n, int n2, int n3, int n4) {
        int n5 = this.points[n3].getV();
        int n6 = this.points[n4].getV();
        int n7 = this.points[n3].getU() - n5;
        int n8 = this.points[n4].getU() - n6;
        if (n > n2) {
            return;
        }
        if (n5 == n6) {
            for (int i = n; i <= n2; ++i) {
                int n9 = this.points[i].getV();
                n9 = n9 <= n5 ? (n9 += n7) : (n9 += n8);
                this.points[i].setU(n9);
            }
        } else if (n5 < n6) {
            for (int i = n; i <= n2; ++i) {
                int n10 = this.points[i].getV();
                n10 = n10 <= n5 ? (n10 += n7) : (n10 >= n6 ? (n10 += n8) : this.points[n3].getU() + Utils.mulDiv(n10 - n5, this.points[n4].getU() - this.points[n3].getU(), n6 - n5));
                this.points[i].setU(n10);
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                int n11 = this.points[i].getV();
                n11 = n11 <= n6 ? (n11 += n8) : (n11 >= n5 ? (n11 += n7) : this.points[n3].getU() + Utils.mulDiv(n11 - n5, this.points[n4].getU() - this.points[n3].getU(), n6 - n5));
                this.points[i].setU(n11);
            }
        }
    }

    void alignStrongPoints(int n) {
        AxisHints axisHints = this.axis[n];
        Edge[] edgeArray = axisHints.edges;
        int n2 = axisHints.numEdges;
        short s = n == 0 ? (short)64 : 128;
        if (n2 > 0) {
            for (int i = 0; i < this.numPoints; ++i) {
                int n3;
                int n4;
                Point point = this.points[i];
                if ((point.getFlags() & s) != 0 || (point.getFlags() & 0x10) != 0 && (point.getFlags() & 0x20) == 0) continue;
                if (n == 1) {
                    n4 = point.getOrigY();
                    n3 = point.getScaledY();
                } else {
                    n4 = point.getOrigX();
                    n3 = point.getScaledX();
                }
                int n5 = n4;
                Edge edge = edgeArray[0];
                int n6 = edge.fpos - n4;
                if (n6 >= 0) {
                    n4 = edge.pos - (edge.opos - n3);
                    this.storePoint(point, n4, n, s);
                    continue;
                }
                edge = edgeArray[n2 - 1];
                n6 = n4 - edge.fpos;
                if (n6 >= 0) {
                    n4 = edge.pos + (n3 - edge.opos);
                    this.storePoint(point, n4, n, s);
                    continue;
                }
                int n7 = 0;
                int n8 = n2;
                boolean bl = false;
                while (n7 < n8) {
                    int n9 = (n8 + n7) / 2;
                    edge = edgeArray[n9];
                    int n10 = edge.fpos;
                    if (n4 < n10) {
                        n8 = n9;
                        continue;
                    }
                    if (n4 > n10) {
                        n7 = n9 + 1;
                        continue;
                    }
                    n4 = edge.pos;
                    this.storePoint(point, n4, n, s);
                    bl = true;
                    break;
                }
                if (!bl) {
                    Edge edge2 = edgeArray[n7 - 1];
                    Edge edge3 = edgeArray[n7];
                    if (edge2.scale == 0) {
                        edge2.scale = Fixed.div16(edge3.pos - edge2.pos, edge3.fpos - edge2.fpos);
                    }
                    n4 = edge2.pos + Fixed.mul16(n5 - edge2.fpos, edge2.scale);
                }
                this.storePoint(point, n4, n, s);
            }
        }
    }

    private void storePoint(Point point, int n, int n2, short s) {
        if (n2 == 0) {
            point.setX(n);
        } else {
            point.setY(n);
        }
        point.addFlags(s);
    }

    void alignEdgePoints(int n) {
        AxisHints axisHints = this.axis[n];
        Edge[] edgeArray = axisHints.edges;
        int n2 = axisHints.numEdges;
        for (int i = 0; i < n2; ++i) {
            Edge edge = edgeArray[i];
            Segment segment = edge.first;
            block1: do {
                Point point = segment.first;
                while (true) {
                    if (n == 0) {
                        point.setX(edge.pos);
                        point.addFlags((short)64);
                    } else {
                        point.setY(edge.pos);
                        point.addFlags((short)128);
                    }
                    if (point == segment.last) continue block1;
                    point = point.getNext();
                }
            } while ((segment = segment.edgeNext) != edge.first);
        }
    }

    private int getPointIndex(Point point) {
        int n = -1;
        for (int i = 0; i < this.numPoints; ++i) {
            if (point != this.points[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean doAlignEdgePoints() {
        return (this.flags & 8) == 0;
    }

    public boolean doAlignStrongPoints() {
        return (this.flags & 0x10) == 0;
    }

    public boolean doAlignWeakPoints() {
        return (this.flags & 0x20) == 0;
    }
}

