/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.Edge;
import gnu.java.awt.font.autofit.Segment;

class AxisHints {
    Segment[] segments = new Segment[4];
    int majorDir;
    int numSegments;
    int numEdges;
    Edge[] edges = new Edge[4];

    AxisHints() {
    }

    Segment newSegment() {
        Segment segment;
        if (this.numSegments >= this.segments.length) {
            int n = this.segments.length;
            n += (n >> 2) + 4;
            Segment[] segmentArray = new Segment[n];
            System.arraycopy(this.segments, 0, segmentArray, 0, this.numSegments);
            this.segments = segmentArray;
        }
        this.segments[this.numSegments] = segment = new Segment();
        ++this.numSegments;
        return segment;
    }

    public Edge newEdge(int n) {
        Edge[] edgeArray;
        int n2;
        if (this.numEdges >= this.edges.length) {
            n2 = this.edges.length;
            n2 += (n2 >> 2) + 4;
            edgeArray = new Edge[n2];
            System.arraycopy(this.edges, 0, edgeArray, 0, this.numEdges);
            this.edges = edgeArray;
        }
        this.edges[n2] = new Edge();
        edgeArray = this.edges[n2];
        for (n2 = this.numEdges; n2 > 0 && this.edges[n2 - 1].fpos > n; --n2) {
            this.edges[n2] = this.edges[n2 - 1];
        }
        this.edges[n2] = edgeArray;
        ++this.numEdges;
        edgeArray.fpos = n;
        return edgeArray;
    }

    int getEdgeIndex(Edge edge) {
        int n = -1;
        for (int i = 0; i < this.numEdges; ++i) {
            if (this.edges[i] != edge) continue;
            n = i;
            break;
        }
        return n;
    }
}

