/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

class SocketTransport
implements ITransport {
    public static final String NAME = "dt_socket";
    private static final String _PROPERTY_ADDRESS = "address";
    private static final String _PROPERTY_SERVER = "server";
    private int _port;
    private String _host;
    private boolean _server = false;
    private Socket _socket;

    SocketTransport() {
    }

    public void configure(HashMap hashMap) throws TransportException {
        String string = (String)hashMap.get(_PROPERTY_SERVER);
        if (string != null && string.toLowerCase().equals("y")) {
            this._server = true;
        }
        if ((string = (String)hashMap.get(_PROPERTY_ADDRESS)) != null) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 1) {
                this._port = Integer.parseInt(stringArray[0]);
                this._host = "localhost";
            } else {
                this._host = stringArray[0].length() == 0 ? "localhost" : stringArray[0];
                this._port = Integer.parseInt(stringArray[1]);
            }
        }
    }

    public void initialize() throws TransportException {
        try {
            if (this._server) {
                ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
                ServerSocket serverSocket = serverSocketFactory.createServerSocket(this._port, 1);
                this._socket = serverSocket.accept();
            } else {
                SocketFactory socketFactory = SocketFactory.getDefault();
                this._socket = socketFactory.createSocket(this._host, this._port);
            }
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
    }

    public void shutdown() {
        try {
            this._socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        return this._socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._socket.getOutputStream();
    }
}

