/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.transport.JdwpCommandPacket;
import gnu.classpath.jdwp.transport.JdwpReplyPacket;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class JdwpPacket {
    protected static int _last_id = 0;
    protected static final int JDWP_FLAG_REPLY = 128;
    protected static final int MINIMUM_SIZE = 9;
    protected int _id;
    protected byte _flags;
    protected byte[] _data;

    public JdwpPacket() {
    }

    public JdwpPacket(JdwpPacket jdwpPacket) {
        this._id = jdwpPacket.getId();
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public byte getFlags() {
        return this._flags;
    }

    public void setFlags(byte by) {
        this._flags = by;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] byArray) {
        this._data = byArray;
    }

    public int getLength() {
        return 9 + (this._data == null ? 0 : this._data.length);
    }

    protected abstract int myFromBytes(byte[] var1, int var2);

    public static JdwpPacket fromBytes(byte[] byArray) {
        int n = 0;
        int n2 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n3 = 0;
        byte by = 0;
        if (byArray.length == n2) {
            n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            by = byArray[n++];
            Class clazz = null;
            if (by == 0) {
                clazz = JdwpCommandPacket.class;
            } else if ((by & 0x80) != 0) {
                clazz = JdwpReplyPacket.class;
            } else {
                return null;
            }
            JdwpPacket jdwpPacket = null;
            try {
                jdwpPacket = (JdwpPacket)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            jdwpPacket.setId(n3);
            jdwpPacket.setFlags(by);
            n += jdwpPacket.myFromBytes(byArray, n);
            byte[] byArray2 = new byte[n2 - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            jdwpPacket.setData(byArray2);
            return jdwpPacket;
        }
        return null;
    }

    protected abstract void myWrite(DataOutputStream var1) throws IOException;

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.getLength();
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.getId());
        dataOutputStream.writeByte(this.getFlags());
        this.myWrite(dataOutputStream);
        byte[] byArray = this.getData();
        if (byArray != null && byArray.length > 0) {
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }
}

