/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.value.ObjectValue;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StackFrameCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        boolean bl = true;
        try {
            switch (by) {
                case 1: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeThisObject(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executePopFrames(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Stack Frame Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        long l = byteBuffer.getLong();
        VMFrame vMFrame = VMVirtualMachine.getFrame(thread, l);
        int n = byteBuffer.getInt();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            Value value = vMFrame.getValue(n2, by);
            value.writeTagged(dataOutputStream);
        }
    }

    private void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        long l = byteBuffer.getLong();
        VMFrame vMFrame = VMVirtualMachine.getFrame(thread, l);
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            Value value = ValueFactory.createFromTagged(byteBuffer);
            vMFrame.setValue(n2, value);
        }
    }

    private void executeThisObject(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        long l = byteBuffer.getLong();
        VMFrame vMFrame = VMVirtualMachine.getFrame(thread, l);
        ObjectValue objectValue = new ObjectValue(vMFrame.getObject());
        objectValue.writeTagged(dataOutputStream);
    }

    private void executePopFrames(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        String string = "popping frames is unsupported";
        throw new NotImplementedException(string);
    }
}

