/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ObjectReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeReferenceType(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeMonitorInfo(byteBuffer, dataOutputStream);
                    break;
                }
                case 6: {
                    this.executeInvokeMethod(byteBuffer, dataOutputStream);
                    break;
                }
                case 7: {
                    this.executeDisableCollection(byteBuffer, dataOutputStream);
                    break;
                }
                case 8: {
                    this.executeEnableCollection(byteBuffer, dataOutputStream);
                    break;
                }
                case 9: {
                    this.executeIsCollected(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ObjectReference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeReferenceType(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        Class<? extends Object> clazz = object.getClass();
        ReferenceTypeId referenceTypeId = this.idMan.getReferenceTypeId(clazz);
        referenceTypeId.writeTagged(dataOutputStream);
    }

    private void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Field field = (Field)this.idMan.readObjectId(byteBuffer).getObject();
            try {
                field.setAccessible(true);
                Object object2 = field.get(object);
                Value value = ValueFactory.createFromObject(object2, field.getType());
                value.writeTagged(dataOutputStream);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFieldException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JdwpInternalErrorException(illegalAccessException);
            }
        }
    }

    private void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)this.idMan.readObjectId(byteBuffer).getObject();
            Object object2 = Value.getUntaggedObject(byteBuffer, field.getType());
            try {
                field.setAccessible(true);
                field.set(object, object2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFieldException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JdwpInternalErrorException(illegalAccessException);
            }
        }
    }

    private void executeMonitorInfo(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        String string = "getting monitor info not supported";
        throw new NotImplementedException(string);
    }

    private void executeInvokeMethod(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        int n;
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        ObjectId objectId2 = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId2.getObject();
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        VMMethod vMMethod = VMMethod.readId(clazz, byteBuffer);
        int n2 = byteBuffer.getInt();
        Value[] valueArray = new Value[n2];
        for (n = 0; n < n2; ++n) {
            valueArray[n] = ValueFactory.createFromTagged(byteBuffer);
        }
        n = byteBuffer.getInt();
        MethodResult methodResult = VMVirtualMachine.executeMethod(object, thread, clazz, vMMethod, valueArray, n);
        Throwable throwable = methodResult.getThrownException();
        ObjectId objectId3 = this.idMan.getObjectId(throwable);
        methodResult.getReturnedValue().writeTagged(dataOutputStream);
        objectId3.writeTagged(dataOutputStream);
    }

    private void executeDisableCollection(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        objectId.disableCollection();
    }

    private void executeEnableCollection(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        objectId.enableCollection();
    }

    private void executeIsCollected(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        boolean bl = objectId.getReference().get() == null;
        dataOutputStream.writeBoolean(bl);
    }
}

