/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.value.ObjectValue;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ClassTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeSuperclass(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeInvokeMethod(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeNewInstance(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ClassType Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeSuperclass(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            dataOutputStream.writeLong(0L);
        } else {
            ReferenceTypeId referenceTypeId2 = this.idMan.getReferenceTypeId(clazz2);
            referenceTypeId2.write(dataOutputStream);
        }
    }

    private void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            ObjectId objectId = this.idMan.readObjectId(byteBuffer);
            Field field = (Field)objectId.getObject();
            Object object = Value.getUntaggedObject(byteBuffer, field.getType());
            try {
                field.setAccessible(true);
                field.set(null, object);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFieldException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JdwpInternalErrorException(illegalAccessException);
            }
        }
    }

    private void executeInvokeMethod(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        MethodResult methodResult = this.invokeMethod(byteBuffer);
        Throwable throwable = methodResult.getThrownException();
        ObjectId objectId = this.idMan.getObjectId(throwable);
        methodResult.getReturnedValue().writeTagged(dataOutputStream);
        objectId.writeTagged(dataOutputStream);
    }

    private void executeNewInstance(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        MethodResult methodResult = this.invokeMethod(byteBuffer);
        Throwable throwable = methodResult.getThrownException();
        if (throwable == null && !(methodResult.getReturnedValue() instanceof ObjectValue)) {
            throw new JdwpInternalErrorException("new instance returned non-object");
        }
        ObjectValue objectValue = (ObjectValue)methodResult.getReturnedValue();
        ObjectId objectId = this.idMan.getObjectId(objectValue.getValue());
        ObjectId objectId2 = this.idMan.getObjectId(throwable);
        objectId.writeTagged(dataOutputStream);
        objectId2.writeTagged(dataOutputStream);
    }

    private MethodResult invokeMethod(ByteBuffer byteBuffer) throws JdwpException, IOException {
        int n;
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId.getObject();
        VMMethod vMMethod = VMMethod.readId(clazz, byteBuffer);
        int n2 = byteBuffer.getInt();
        Value[] valueArray = new Value[n2];
        for (n = 0; n < n2; ++n) {
            valueArray[n] = ValueFactory.createFromTagged(byteBuffer);
        }
        n = byteBuffer.getInt();
        MethodResult methodResult = VMVirtualMachine.executeMethod(null, thread, clazz, vMMethod, valueArray, n);
        return methodResult;
    }
}

