/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class ArrayReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeLength(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Array Reference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeLength(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws InvalidObjectException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        dataOutputStream.writeInt(Array.getLength(object));
    }

    private void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            dataOutputStream.writeByte(66);
        } else if (clazz == Character.TYPE) {
            dataOutputStream.writeByte(67);
        } else if (clazz == Float.TYPE) {
            dataOutputStream.writeByte(70);
        } else if (clazz == Double.TYPE) {
            dataOutputStream.writeByte(68);
        } else if (clazz == Integer.TYPE) {
            dataOutputStream.writeByte(66);
        } else if (clazz == Long.TYPE) {
            dataOutputStream.writeByte(74);
        } else if (clazz == Short.TYPE) {
            dataOutputStream.writeByte(83);
        } else if (clazz == Void.TYPE) {
            dataOutputStream.writeByte(86);
        } else if (clazz == Boolean.TYPE) {
            dataOutputStream.writeByte(90);
        } else if (clazz.isArray()) {
            dataOutputStream.writeByte(91);
        } else if (String.class.isAssignableFrom(clazz)) {
            dataOutputStream.writeByte(115);
        } else if (Thread.class.isAssignableFrom(clazz)) {
            dataOutputStream.writeByte(116);
        } else if (ThreadGroup.class.isAssignableFrom(clazz)) {
            dataOutputStream.writeByte(103);
        } else if (ClassLoader.class.isAssignableFrom(clazz)) {
            dataOutputStream.writeByte(108);
        } else if (Class.class.isAssignableFrom(clazz)) {
            dataOutputStream.writeByte(99);
        } else {
            dataOutputStream.writeByte(76);
        }
        for (int i = n; i < n + n2; ++i) {
            Value value = ValueFactory.createFromObject(Array.get(object, i), clazz);
            if (clazz.isPrimitive()) {
                value.writeUntagged(dataOutputStream);
                continue;
            }
            value.writeTagged(dataOutputStream);
        }
    }

    private void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws IOException, JdwpException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        Class<?> clazz = object.getClass().getComponentType();
        for (int i = n; i < n + n2; ++i) {
            Object object2 = Value.getUntaggedObject(byteBuffer, clazz);
            Array.set(object, i, object2);
        }
    }
}

