/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.id.ArrayId;
import gnu.classpath.jdwp.id.ArrayReferenceTypeId;
import gnu.classpath.jdwp.id.ClassLoaderId;
import gnu.classpath.jdwp.id.ClassObjectId;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.id.InterfaceReferenceTypeId;
import gnu.classpath.jdwp.id.NullObjectId;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.id.StringId;
import gnu.classpath.jdwp.id.ThreadGroupId;
import gnu.classpath.jdwp.id.ThreadId;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;

public class VMIdManager {
    private static VMIdManager _idm = new VMIdManager();
    private ReferenceQueue _refQueue = new ReferenceQueue();
    private Hashtable _oidTable = new Hashtable(50);
    private Hashtable _idTable = new Hashtable(50);
    private Hashtable _classTable = new Hashtable(20);
    private Hashtable _ridTable = new Hashtable(20);

    public static VMIdManager getDefault() {
        return _idm;
    }

    private VMIdManager() {
    }

    private void _update() {
        Reference reference;
        while ((reference = this._refQueue.poll()) != null) {
            ObjectId objectId = (ObjectId)this._oidTable.get(reference);
            this._oidTable.remove(reference);
            this._idTable.remove(new Long(objectId.getId()));
        }
    }

    public ObjectId getObjectId(Object object) {
        if (object == null) {
            return new NullObjectId();
        }
        ReferenceKey referenceKey = new ReferenceKey(object, this._refQueue);
        ObjectId objectId = (ObjectId)this._oidTable.get(referenceKey);
        if (objectId == null) {
            this._update();
            objectId = IdFactory.newObjectId(referenceKey);
            this._oidTable.put(referenceKey, objectId);
            this._idTable.put(new Long(objectId.getId()), objectId);
        }
        return objectId;
    }

    public ObjectId get(long l) throws InvalidObjectException {
        if (l == 0L) {
            return new NullObjectId();
        }
        ObjectId objectId = (ObjectId)this._idTable.get(new Long(l));
        if (objectId == null) {
            throw new InvalidObjectException(l);
        }
        return objectId;
    }

    public ObjectId readObjectId(ByteBuffer byteBuffer) throws InvalidObjectException {
        long l = byteBuffer.getLong();
        return this.get(l);
    }

    public ReferenceTypeId getReferenceTypeId(Class clazz) {
        ReferenceKey referenceKey = new ReferenceKey(clazz);
        ReferenceTypeId referenceTypeId = (ReferenceTypeId)this._classTable.get(referenceKey);
        if (referenceTypeId == null) {
            referenceTypeId = IdFactory.newReferenceTypeId(referenceKey);
            this._classTable.put(referenceKey, referenceTypeId);
            this._ridTable.put(new Long(referenceTypeId.getId()), referenceTypeId);
        }
        return referenceTypeId;
    }

    public ReferenceTypeId getReferenceType(long l) throws InvalidClassException {
        ReferenceTypeId referenceTypeId = (ReferenceTypeId)this._ridTable.get(new Long(l));
        if (referenceTypeId == null) {
            throw new InvalidClassException(l);
        }
        return referenceTypeId;
    }

    public ReferenceTypeId readReferenceTypeId(ByteBuffer byteBuffer) throws InvalidClassException {
        long l = byteBuffer.getLong();
        return this.getReferenceType(l);
    }

    class ReferenceKey
    extends SoftReference {
        private int _hash;

        public ReferenceKey(Object object) {
            super(object);
            this._hash = object.hashCode();
        }

        public ReferenceKey(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this._hash = object.hashCode();
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ReferenceKey) {
                ReferenceKey referenceKey = (ReferenceKey)object;
                if (this == object) {
                    return true;
                }
                return referenceKey.get() == this.get();
            }
            return false;
        }
    }

    private static class IdFactory {
        private static Object _idLock = new Object();
        private static Object _ridLock = new Object();
        private static long _lastId = 0L;
        private static long _lastRid = 0L;
        private static HashMap _idList = new HashMap();

        private IdFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectId newObjectId(SoftReference softReference) {
            Class clazz;
            ObjectId objectId = null;
            Object t = softReference.get();
            if (t.getClass().isArray()) {
                objectId = new ArrayId();
            } else {
                for (clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    Class clazz2 = (Class)_idList.get(clazz);
                    if (clazz2 == null) continue;
                    try {
                        objectId = (ObjectId)clazz2.newInstance();
                        Object object = _idLock;
                        synchronized (object) {
                            objectId.setId(++_lastId);
                        }
                        objectId.setReference(softReference);
                        return objectId;
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RuntimeException("cannot create new ID", instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException("illegal access of ID", illegalAccessException);
                    }
                }
                objectId = new ObjectId();
            }
            clazz = _idLock;
            synchronized (clazz) {
                objectId.setId(++_lastId);
            }
            objectId.setReference(softReference);
            return objectId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ReferenceTypeId newReferenceTypeId(SoftReference softReference) {
            Class clazz = (Class)softReference.get();
            if (clazz == null) {
                return null;
            }
            ReferenceTypeId referenceTypeId = clazz.isArray() ? new ArrayReferenceTypeId() : (clazz.isInterface() ? new InterfaceReferenceTypeId() : new ClassReferenceTypeId());
            referenceTypeId.setReference(softReference);
            Object object = _ridLock;
            synchronized (object) {
                referenceTypeId.setId(++_lastRid);
            }
            return referenceTypeId;
        }

        static {
            _idList.put(ClassLoaderId.typeClass, ClassLoaderId.class);
            _idList.put(ClassObjectId.typeClass, ClassObjectId.class);
            _idList.put(StringId.typeClass, StringId.class);
            _idList.put(ThreadId.typeClass, ThreadId.class);
            _idList.put(ThreadGroupId.typeClass, ThreadGroupId.class);
        }
    }
}

