/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.processor.PacketProcessor;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpConnection;
import gnu.classpath.jdwp.transport.TransportException;
import gnu.classpath.jdwp.transport.TransportFactory;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;

public class Jdwp
extends Thread {
    private static Jdwp _instance = null;
    public static boolean isDebugging = false;
    private PacketProcessor _packetProcessor;
    private Thread _ppThread;
    private HashMap _properties;
    private static final String _PROPERTY_SUSPEND = "suspend";
    private JdwpConnection _connection;
    private boolean _shutdown = false;
    private ThreadGroup _group;
    private Object _initLock = new Object();
    private int _initCount = 0;

    public Jdwp() {
        _instance = this;
    }

    public static Jdwp getDefault() {
        return _instance;
    }

    public ThreadGroup getJdwpThreadGroup() {
        return this._group;
    }

    public static boolean suspendOnStartup() {
        String string;
        Jdwp jdwp = Jdwp.getDefault();
        return jdwp != null && (string = (String)jdwp._properties.get(_PROPERTY_SUSPEND)) != null && string.equals("y");
    }

    public void configure(String string) {
        this._processConfigury(string);
    }

    private void _doInitialization() throws TransportException {
        this._group = new ThreadGroup("JDWP threads");
        ITransport iTransport = TransportFactory.newInstance(this._properties);
        this._connection = new JdwpConnection(this._group, iTransport);
        this._connection.initialize();
        this._connection.start();
        this._packetProcessor = new PacketProcessor(this._connection);
        this._ppThread = new Thread(this._group, new Runnable(){

            public void run() {
                AccessController.doPrivileged(Jdwp.this._packetProcessor);
            }
        }, "packet processor");
        this._ppThread.start();
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._packetProcessor.shutdown();
            this._ppThread.interrupt();
            this._connection.shutdown();
            this._shutdown = true;
            isDebugging = false;
            this.interrupt();
        }
    }

    public static void notify(Event event) {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            EventManager eventManager = EventManager.getDefault();
            EventRequest[] eventRequestArray = eventManager.getEventRequests(event);
            for (int i = 0; i < eventRequestArray.length; ++i) {
                try {
                    Jdwp.sendEvent(eventRequestArray[i], event);
                    jdwp._enforceSuspendPolicy(eventRequestArray[i].getSuspendPolicy());
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Jdwp.notify: caught exception: " + exception);
                }
            }
        }
    }

    public static void notify(Event[] eventArray) {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            EventRequest[] eventRequestArray;
            byte by = 0;
            EventManager eventManager = EventManager.getDefault();
            ArrayList<Event> arrayList = new ArrayList<Event>();
            ArrayList<EventRequest> arrayList2 = new ArrayList<EventRequest>();
            for (int i = 0; i < eventArray.length; ++i) {
                eventRequestArray = eventManager.getEventRequests(eventArray[i]);
                for (int j = 0; j < eventRequestArray.length; ++j) {
                    arrayList.add(eventArray[i]);
                    arrayList2.add(eventRequestArray[j]);
                    if (eventRequestArray[j].getSuspendPolicy() <= by) continue;
                    by = eventRequestArray[j].getSuspendPolicy();
                }
            }
            try {
                Event[] eventArray2 = new Event[arrayList.size()];
                arrayList.toArray(eventArray2);
                eventRequestArray = new EventRequest[arrayList2.size()];
                arrayList2.toArray(eventRequestArray);
                Jdwp.sendEvents(eventRequestArray, eventArray2, by);
                jdwp._enforceSuspendPolicy(by);
            }
            catch (Exception exception) {
                System.out.println("Jdwp.notify: caught exception: " + exception);
            }
        }
    }

    public static void sendEvent(EventRequest eventRequest, Event event) throws IOException {
        Jdwp.sendEvents(new EventRequest[]{eventRequest}, new Event[]{event}, eventRequest.getSuspendPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEvents(EventRequest[] eventRequestArray, Event[] eventArray, byte by) throws IOException {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            JdwpConnection jdwpConnection = jdwp._connection;
            synchronized (jdwpConnection) {
                jdwp._connection.sendEvents(eventRequestArray, eventArray, by);
            }
        }
    }

    private void _enforceSuspendPolicy(byte by) throws JdwpException {
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                VMVirtualMachine.suspendThread(Thread.currentThread());
                break;
            }
            case 2: {
                VMVirtualMachine.suspendAllThreads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subcomponentInitialized() {
        Object object = this._initLock;
        synchronized (object) {
            ++this._initCount;
            this._initLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._doInitialization();
            Object object = this._initLock;
            synchronized (object) {
                while (this._initCount != 2) {
                    this._initLock.wait();
                }
            }
            this._initLock = null;
        }
        catch (Throwable throwable) {
            System.out.println("Exception in JDWP back-end: " + throwable);
            System.exit(1);
        }
        EventManager.getDefault();
        isDebugging = true;
    }

    private void _processConfigury(String string) {
        this._properties = new HashMap();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) continue;
            this._properties.put(stringArray2[0], stringArray2[1]);
        }
    }
}

