/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.Connected_objects;
import gnu.CORBA.IOR;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.Poa.ORB_1_4;
import java.applet.Applet;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;

public class OrbFocused
extends ORB_1_4 {
    public static final String LISTENER_PORT = "gnu.CORBA.ListenerPort";
    int m_ports_from = -1;
    int m_ports_to = -1;
    static final int PARALLEL = 0;
    static final int SEQUENTIAL = 1;
    Random m_random = new Random();

    public void setPortRange(String string) {
        try {
            int n;
            int n2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " -");
            if (stringTokenizer.countTokens() == 1) {
                n = n2 = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                this.m_random = new Random();
            }
            this.setPortRange(n, n2);
        }
        catch (Exception exception) {
            throw new BAD_PARAM("Unable to parse port range '" + string + "'");
        }
    }

    public void setPortRange(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < n) {
            throw new BAD_PARAM("Invalid range");
        }
        this.m_ports_from = n;
        this.m_ports_to = n2;
    }

    int getPortFromRange(int n) {
        if (this.m_ports_from == this.m_ports_to) {
            return this.m_ports_from;
        }
        if (this.m_ports_to - this.m_ports_from < RANDOM_PORT_ATTEMPTS) {
            return this.m_ports_from + n % (this.m_ports_to - this.m_ports_from + 1);
        }
        return this.m_random.nextInt(this.m_ports_to - this.m_ports_from + 1) + this.m_ports_from;
    }

    protected OrbFunctional.portServer getPortServer(int n) {
        int n2 = this.m_ports_from < this.m_ports_to ? RANDOM_PORT_ATTEMPTS : 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getPortFromRange(i);
            for (int j = 0; j < this.portServers.size(); ++j) {
                OrbFunctional.portServer portServer2 = (OrbFunctional.portServer)this.portServers.get(j);
                if (portServer2.s_port != n3) continue;
                return portServer2;
            }
            try {
                OrbFunctional.portServer portServer3;
                ServerSocket serverSocket = this.socketFactory.createServerSocket(n3);
                serverSocket.close();
                switch (n) {
                    case 0: {
                        portServer3 = new OrbFunctional.portServer(this, n3);
                        break;
                    }
                    case 1: {
                        portServer3 = new OrbFunctional.sharedPortServer(this, n3);
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid server type " + n);
                    }
                }
                this.portServers.add(portServer3);
                if (this.running) {
                    portServer3.start();
                }
                return portServer3;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NO_RESOURCES("No free port available at " + this.m_ports_from + "-" + this.m_ports_to, 1195573268, CompletionStatus.COMPLETED_NO);
    }

    public void run() {
        if (this.m_ports_from < 0 || this.m_ports_to < 0) {
            throw new BAD_INV_ORDER("For " + this.getClass().getName() + " " + LISTENER_PORT + " property must be set");
        }
        this.running = true;
        Iterator iterator = this.portServers.iterator();
        while (iterator.hasNext()) {
            OrbFunctional.portServer portServer2 = (OrbFunctional.portServer)iterator.next();
            if (portServer2.isAlive()) continue;
            if (!iterator.hasNext()) {
                iterator = null;
                portServer2.run();
                return;
            }
            portServer2.start();
        }
    }

    public int getFreePort() throws BAD_OPERATION {
        OrbFunctional.portServer portServer2 = this.getPortServer(0);
        return portServer2.s_port;
    }

    public void connect_1_thread(Object object, byte[] byArray, java.lang.Object object2) {
        OrbFunctional.sharedPortServer sharedPortServer2 = (OrbFunctional.sharedPortServer)this.identities.get(object2);
        if (sharedPortServer2 == null) {
            sharedPortServer2 = (OrbFunctional.sharedPortServer)this.getPortServer(1);
            this.identities.put(object2, sharedPortServer2);
            if (this.running) {
                sharedPortServer2.start();
            }
        }
        Connected_objects.cObject cObject2 = this.connected_objects.add(byArray, object, sharedPortServer2.s_port, object2);
        IOR iOR = this.createIOR(cObject2);
        this.prepareObject(object, iOR);
    }

    public void startService(IOR iOR) {
    }

    protected void set_parameters(Applet applet, Properties properties) {
        super.set_parameters(applet, properties);
        String string = applet.getParameter(LISTENER_PORT);
        if (string != null) {
            this.setPortRange(string);
        }
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        super.set_parameters(stringArray, properties);
        String string = null;
        String string2 = "-gnu.CORBA.ListenerPort";
        if (stringArray != null && stringArray.length >= 2) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                string = stringArray[i + 1];
            }
        }
        if (string != null) {
            this.setPortRange(string);
        }
    }

    protected void useProperties(Properties properties) {
        super.useProperties(properties);
        String string = properties.getProperty(LISTENER_PORT);
        if (string != null) {
            this.setPortRange(string);
        }
    }
}

