/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.NamingService.NameValidator;
import gnu.java.lang.CPStringBuilder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.omg.CORBA.IntHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class NameTransformer {
    public static final String ESCAPE = "\\";

    public NameComponent[] toName(String string) throws InvalidName {
        ArrayList<NameComponent> arrayList = new ArrayList<NameComponent>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./\\", true);
        String[] stringArray = new String[stringTokenizer.countTokens() + 1];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        IntHolder intHolder = new IntHolder();
        NameComponent nameComponent = this.readNode(intHolder, stringArray);
        while (nameComponent != null) {
            arrayList.add(nameComponent);
            nameComponent = this.readNode(intHolder, stringArray);
        }
        NameComponent[] nameComponentArray = new NameComponent[arrayList.size()];
        for (int i = 0; i < nameComponentArray.length; ++i) {
            nameComponentArray[i] = (NameComponent)arrayList.get(i);
        }
        NameValidator.check(nameComponentArray);
        return nameComponentArray;
    }

    public String toString(NameComponent[] nameComponentArray) throws InvalidName {
        NameValidator.check(nameComponentArray);
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < nameComponentArray.length; ++i) {
            NameComponent nameComponent = nameComponentArray[i];
            this.appEscaping(cPStringBuilder, nameComponent.id);
            if (nameComponent.kind.length() > 0) {
                cPStringBuilder.append('.');
                this.appEscaping(cPStringBuilder, nameComponent.kind);
            }
            if (i >= nameComponentArray.length - 1) continue;
            cPStringBuilder.append('/');
        }
        return cPStringBuilder.toString();
    }

    private void appEscaping(CPStringBuilder cPStringBuilder, String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '.': 
                case '/': 
                case '\\': {
                    cPStringBuilder.append('\\');
                    cPStringBuilder.append(c);
                    continue block3;
                }
                default: {
                    cPStringBuilder.append(c);
                }
            }
        }
    }

    private void assertEndOfNode(IntHolder intHolder, String[] stringArray) throws InvalidName {
        if (stringArray[intHolder.value] != null && !stringArray[intHolder.value].equals("/")) {
            throw new InvalidName("End of node expected at token " + intHolder.value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NameComponent readNode(IntHolder intHolder, String[] stringArray) throws InvalidName {
        if (stringArray[intHolder.value] == null) {
            return null;
        }
        NameComponent nameComponent = new NameComponent();
        if (stringArray[intHolder.value].equals(".")) {
            nameComponent.id = "";
            ++intHolder.value;
            nameComponent.kind = this.readPart(intHolder, stringArray);
            this.assertEndOfNode(intHolder, stringArray);
            if (stringArray[intHolder.value] == null) return nameComponent;
            ++intHolder.value;
            return nameComponent;
        } else {
            if (stringArray[intHolder.value].equals("/")) {
                throw new InvalidName("Unexpected '/' token " + intHolder.value);
            }
            nameComponent.id = this.readPart(intHolder, stringArray);
            if (stringArray[intHolder.value] != null) {
                if (stringArray[intHolder.value].equals(".")) {
                    ++intHolder.value;
                    nameComponent.kind = this.readPart(intHolder, stringArray);
                    this.assertEndOfNode(intHolder, stringArray);
                    if (stringArray[intHolder.value] == null) return nameComponent;
                    ++intHolder.value;
                    return nameComponent;
                } else {
                    if (!stringArray[intHolder.value].equals("/")) throw new InvalidName("Unexpected '" + stringArray[intHolder.value] + "' at token " + intHolder.value);
                    nameComponent.kind = "";
                    ++intHolder.value;
                }
                return nameComponent;
            } else {
                nameComponent.kind = "";
            }
        }
        return nameComponent;
    }

    private String readPart(IntHolder intHolder, String[] stringArray) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (stringArray[intHolder.value] != null && !stringArray[intHolder.value].equals(".") && !stringArray[intHolder.value].equals("/")) {
            if (stringArray[intHolder.value].equals(ESCAPE)) {
                ++intHolder.value;
                cPStringBuilder.append(stringArray[intHolder.value]);
            } else {
                cPStringBuilder.append(stringArray[intHolder.value]);
            }
            ++intHolder.value;
        }
        return cPStringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        NameComponent nameComponent = new NameComponent("a", "ak");
        NameComponent nameComponent2 = new NameComponent("b/z", "b.k");
        NameComponent nameComponent3 = new NameComponent("c", "");
        NameTransformer nameTransformer = new NameTransformer();
        try {
            String string = nameTransformer.toString(new NameComponent[]{nameComponent, nameComponent2, nameComponent3});
            System.out.println(string);
            NameComponent[] nameComponentArray = nameTransformer.toName(string);
            System.out.println("ToString");
            for (int i = 0; i < nameComponentArray.length; ++i) {
                System.out.println(nameComponentArray[i].id + ":" + nameComponentArray[i].kind);
            }
        }
        catch (InvalidName invalidName) {
            invalidName.printStackTrace();
        }
    }
}

