/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Adler32;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ULongSeqHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHelper;

public class IOR {
    public static final int FAILED = 10;
    public Internet_profile Internet = new Internet_profile();
    public String Id;
    public byte[] key;
    ArrayList profiles = new ArrayList();
    public boolean Big_Endian = true;

    public static IOR parse(String string) throws BAD_PARAM {
        try {
            if (!string.startsWith("IOR:")) {
                throw new BAD_PARAM("The string refernce must start with IOR:", 10, CompletionStatus.COMPLETED_NO);
            }
            IOR iOR = new IOR();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string2 = string;
            string2 = string2.substring(string2.indexOf(":") + 1);
            for (int i = 0; i < string2.length(); i += 2) {
                char c = (char)Integer.parseInt(string2.substring(i, i + 2), 16);
                byteArrayOutputStream.write(c);
            }
            BufferredCdrInput bufferredCdrInput = new BufferredCdrInput(byteArrayOutputStream.toByteArray());
            iOR._read(bufferredCdrInput);
            return iOR;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BAD_PARAM(exception + " while parsing " + string, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    public void _read(AbstractCdrInput abstractCdrInput) throws IOException, BAD_PARAM {
        int n = abstractCdrInput.read_long();
        if (n != 0) {
            this.Big_Endian = false;
            abstractCdrInput.setBigEndian(false);
        }
        this._read_no_endian(abstractCdrInput);
    }

    public void _read_no_endian(AbstractCdrInput abstractCdrInput) throws IOException, BAD_PARAM {
        this.Id = abstractCdrInput.read_string();
        int n = abstractCdrInput.read_long();
        if (n == 0) {
            this.Id = null;
            this.Internet = null;
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = abstractCdrInput.read_long();
            BufferredCdrInput bufferredCdrInput = abstractCdrInput.read_encapsulation();
            if (n2 == 0) {
                this.Internet = new Internet_profile();
                this.Internet.version = Version.read_version(bufferredCdrInput);
                this.Internet.host = bufferredCdrInput.read_string();
                this.Internet.port = bufferredCdrInput.gnu_read_ushort();
                this.key = bufferredCdrInput.read_sequence();
                int n3 = 0;
                try {
                    if (this.Internet.version.since_inclusive(1, 1)) {
                        n3 = bufferredCdrInput.read_long();
                    }
                    for (int j = 0; j < n3; ++j) {
                        int n4 = bufferredCdrInput.read_long();
                        if (n4 == 1) {
                            this.Internet.CodeSets.read(bufferredCdrInput);
                            continue;
                        }
                        TaggedComponent taggedComponent = new TaggedComponent();
                        taggedComponent.tag = n4;
                        taggedComponent.component_data = bufferredCdrInput.read_sequence();
                        this.Internet.components.add(taggedComponent);
                    }
                    continue;
                }
                catch (Unexpected unexpected) {
                    unexpected.printStackTrace();
                    continue;
                }
            }
            TaggedProfile taggedProfile = new TaggedProfile();
            taggedProfile.tag = n2;
            taggedProfile.profile_data = bufferredCdrInput.buffer.getBuffer();
            this.profiles.add(taggedProfile);
        }
    }

    public void _write(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write(0);
        this._write_no_endian(abstractCdrOutput);
    }

    public static void write_null(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write_string("");
        abstractCdrOutput.write_long(0);
    }

    public void _write_no_endian(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write_string(this.Id);
        abstractCdrOutput.write_long(1 + this.profiles.size());
        abstractCdrOutput.write_long(0);
        this.Internet.write(abstractCdrOutput);
        for (int i = 0; i < this.profiles.size(); ++i) {
            TaggedProfile taggedProfile = (TaggedProfile)this.profiles.get(i);
            TaggedProfileHelper.write(abstractCdrOutput, taggedProfile);
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(this.Id);
        cPStringBuilder.append(" at ");
        cPStringBuilder.append(this.Internet);
        if (!this.Big_Endian) {
            cPStringBuilder.append(" (Little endian) ");
        }
        cPStringBuilder.append(" Key ");
        for (int i = 0; i < this.key.length; ++i) {
            cPStringBuilder.append(Integer.toHexString(this.key[i] & 0xFF));
        }
        cPStringBuilder.append(" ");
        cPStringBuilder.append(this.Internet.CodeSets);
        return cPStringBuilder.toString();
    }

    public String toStringFormatted() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append("\nObject Id:\n  ");
        cPStringBuilder.append(this.Id);
        cPStringBuilder.append("\nObject is accessible at:\n  ");
        cPStringBuilder.append(this.Internet);
        if (this.Big_Endian) {
            cPStringBuilder.append("\n  Big endian encoding");
        } else {
            cPStringBuilder.append("\n  Little endian encoding.");
        }
        cPStringBuilder.append("\nObject Key\n  ");
        for (int i = 0; i < this.key.length; ++i) {
            cPStringBuilder.append(Integer.toHexString(this.key[i] & 0xFF));
        }
        cPStringBuilder.append("\nSupported code sets:");
        cPStringBuilder.append("\n Wide:");
        cPStringBuilder.append(this.Internet.CodeSets.wide.toStringFormatted());
        cPStringBuilder.append(" Narrow:");
        cPStringBuilder.append(this.Internet.CodeSets.wide.toStringFormatted());
        return cPStringBuilder.toString();
    }

    public String toStringifiedReference() {
        BufferedCdrOutput bufferedCdrOutput = new BufferedCdrOutput();
        this._write(bufferedCdrOutput);
        CPStringBuilder cPStringBuilder = new CPStringBuilder("IOR:");
        byte[] byArray = bufferedCdrOutput.buffer.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                cPStringBuilder.append('0');
            }
            cPStringBuilder.append(string);
        }
        return cPStringBuilder.toString();
    }

    public void add_ior_component(TaggedComponent taggedComponent) {
        this.Internet.components.add(taggedComponent);
        for (int i = 0; i < this.profiles.size(); ++i) {
            TaggedProfile taggedProfile = (TaggedProfile)this.profiles.get(i);
            IOR.addComponentTo(taggedProfile, taggedComponent);
        }
    }

    public void add_ior_component_to_profile(TaggedComponent taggedComponent, int n) {
        if (n == 0) {
            this.Internet.components.add(taggedComponent);
        } else {
            for (int i = 0; i < this.profiles.size(); ++i) {
                TaggedProfile taggedProfile = (TaggedProfile)this.profiles.get(i);
                if (taggedProfile.tag != n) continue;
                IOR.addComponentTo(taggedProfile, taggedComponent);
            }
        }
    }

    private static void addComponentTo(TaggedProfile taggedProfile, TaggedComponent taggedComponent) {
        Closeable closeable;
        if (taggedProfile.tag == 1) {
            int n;
            TaggedComponent[] taggedComponentArray;
            if (taggedProfile.profile_data.length > 0) {
                closeable = new BufferredCdrInput(taggedProfile.profile_data);
                taggedComponentArray = new TaggedComponent[((AbstractCdrInput)closeable).read_long()];
                for (n = 0; n < taggedComponentArray.length; ++n) {
                    taggedComponentArray[n] = TaggedComponentHelper.read((InputStream)closeable);
                }
            } else {
                taggedComponentArray = new TaggedComponent[]{};
            }
            closeable = new BufferedCdrOutput(taggedProfile.profile_data.length + taggedComponent.component_data.length + 8);
            ((AbstractCdrOutput)closeable).write_long(taggedComponentArray.length + 1);
            for (n = 0; n < taggedComponentArray.length; ++n) {
                TaggedComponentHelper.write((org.omg.CORBA.portable.OutputStream)closeable, taggedComponentArray[n]);
            }
            TaggedComponentHelper.write((org.omg.CORBA.portable.OutputStream)closeable, taggedComponent);
            try {
                ((OutputStream)closeable).close();
            }
            catch (IOException iOException) {
                throw new Unexpected(iOException);
            }
        } else {
            throw new BAD_PARAM("Unsupported profile type " + taggedProfile.tag);
        }
        taggedProfile.profile_data = ((BufferedCdrOutput)closeable).buffer.toByteArray();
    }

    public boolean equals(Object object) {
        if (object instanceof IOR) {
            boolean bl;
            boolean bl2 = true;
            IOR iOR = (IOR)object;
            if (this.Internet == null || iOR.Internet == null) {
                return this.Internet == iOR.Internet;
            }
            if (this.key != null && iOR.key != null) {
                bl = Arrays.equals(this.key, iOR.key);
            } else {
                boolean bl3 = bl = this.key == iOR.key;
            }
            if (this.Internet != null && this.Internet.host != null && iOR.Internet != null && iOR.Internet.host != null) {
                bl2 = iOR.Internet.host.equals(this.Internet.host);
            }
            return bl & bl2 && this.Internet.port == iOR.Internet.port;
        }
        return false;
    }

    public int hashCode() {
        Adler32 adler32 = new Adler32();
        if (this.key != null) {
            adler32.update(this.key);
        }
        if (this.Internet != null) {
            if (this.Internet.host != null) {
                adler32.update(this.Internet.host.getBytes());
            }
            adler32.update(this.Internet.port);
        }
        return (int)adler32.getValue();
    }

    public class Internet_profile {
        public static final int TAG_INTERNET_IOP = 0;
        public String host;
        public Version version = new Version(1, 2);
        public int port;
        public CodeSets_profile CodeSets = new CodeSets_profile();
        ArrayList components = new ArrayList();

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            cPStringBuilder.append(this.host);
            cPStringBuilder.append(":");
            cPStringBuilder.append(this.port);
            cPStringBuilder.append(" (v");
            cPStringBuilder.append(this.version);
            cPStringBuilder.append(")");
            if (this.components.size() > 0) {
                cPStringBuilder.append(" " + this.components.size() + " extra components.");
            }
            return cPStringBuilder.toString();
        }

        public void write(AbstractCdrOutput abstractCdrOutput) {
            try {
                AbstractCdrOutput abstractCdrOutput2 = abstractCdrOutput.createEncapsulation();
                this.version.write(abstractCdrOutput2);
                abstractCdrOutput2.write_string(this.host);
                abstractCdrOutput2.write_ushort((short)(this.port & 0xFFFF));
                abstractCdrOutput2.write_long(IOR.this.key.length);
                abstractCdrOutput2.write(IOR.this.key);
                abstractCdrOutput2.write_long(1 + this.components.size());
                abstractCdrOutput2.write_long(1);
                this.CodeSets.write(abstractCdrOutput2);
                for (int i = 0; i < this.components.size(); ++i) {
                    TaggedComponent taggedComponent = (TaggedComponent)this.components.get(i);
                    TaggedComponentHelper.write(abstractCdrOutput2, taggedComponent);
                }
                abstractCdrOutput2.close();
            }
            catch (Exception exception) {
                MARSHAL mARSHAL = new MARSHAL("Unable to write Internet profile.");
                mARSHAL.minor = 1195573273;
                mARSHAL.initCause(exception);
                throw mARSHAL;
            }
        }
    }

    public static class CodeSets_profile {
        public static final int TAG_CODE_SETS = 1;
        public CodeSet_component narrow = new CodeSet_component();
        public CodeSet_component wide = new CodeSet_component();
        public CodeSetServiceContext negotiated;

        public CodeSets_profile() {
            int[] nArray = CharSets_OSF.getSupportedCharSets();
            this.narrow.native_set = 65537;
            this.narrow.conversion = nArray;
            this.wide.native_set = 65801;
            this.wide.conversion = nArray;
        }

        public void read(AbstractCdrInput abstractCdrInput) {
            BufferredCdrInput bufferredCdrInput = abstractCdrInput.read_encapsulation();
            this.narrow.read(bufferredCdrInput);
            this.wide.read(bufferredCdrInput);
        }

        public String toString() {
            return "Narrow char: " + this.narrow + ", Wide char: " + this.wide;
        }

        public void write(AbstractCdrOutput abstractCdrOutput) {
            AbstractCdrOutput abstractCdrOutput2 = abstractCdrOutput.createEncapsulation();
            this.narrow.write(abstractCdrOutput2);
            this.wide.write(abstractCdrOutput2);
            try {
                abstractCdrOutput2.close();
            }
            catch (IOException iOException) {
                throw new InternalError();
            }
        }

        public static class CodeSet_component {
            public int[] conversion;
            public int native_set;

            public void read(InputStream inputStream) {
                this.native_set = inputStream.read_ulong();
                this.conversion = ULongSeqHelper.read(inputStream);
            }

            public String toString() {
                CPStringBuilder cPStringBuilder = new CPStringBuilder();
                cPStringBuilder.append("native " + this.name(this.native_set));
                if (this.conversion != null && this.conversion.length > 0) {
                    cPStringBuilder.append(" conversion ");
                    for (int i = 0; i < this.conversion.length; ++i) {
                        cPStringBuilder.append(this.name(this.conversion[i]));
                        cPStringBuilder.append(' ');
                    }
                }
                cPStringBuilder.append(' ');
                return cPStringBuilder.toString();
            }

            public String toStringFormatted() {
                CPStringBuilder cPStringBuilder = new CPStringBuilder();
                cPStringBuilder.append("\n  Native set " + this.name(this.native_set));
                if (this.conversion != null && this.conversion.length > 0) {
                    cPStringBuilder.append("\n  Other supported sets:\n    ");
                    for (int i = 0; i < this.conversion.length; ++i) {
                        cPStringBuilder.append(this.name(this.conversion[i]));
                        cPStringBuilder.append(' ');
                    }
                }
                cPStringBuilder.append("\n");
                return cPStringBuilder.toString();
            }

            public void write(org.omg.CORBA.portable.OutputStream outputStream) {
                outputStream.write_long(this.native_set);
                ULongSeqHelper.write(outputStream, this.conversion);
            }

            private String name(int n) {
                return "0x" + Integer.toHexString(n) + " (" + CharSets_OSF.getName(n) + ") ";
            }
        }
    }
}

