/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedLineString;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;
import org.locationtech.jts.noding.SegmentStringUtil;

class PreparedLineStringIntersects {
    protected PreparedLineString prepLine;

    public static boolean intersects(PreparedLineString prep, Geometry geom) {
        PreparedLineStringIntersects op = new PreparedLineStringIntersects(prep);
        return op.intersects(geom);
    }

    public PreparedLineStringIntersects(PreparedLineString prepLine) {
        this.prepLine = prepLine;
    }

    public boolean intersects(Geometry geom) {
        boolean segsIntersect;
        List lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        if (lineSegStr.size() > 0 && (segsIntersect = this.prepLine.getIntersectionFinder().intersects(lineSegStr))) {
            return true;
        }
        if (geom.getDimension() == 1) {
            return false;
        }
        if (geom.getDimension() == 2 && this.prepLine.isAnyTargetComponentInTest(geom)) {
            return true;
        }
        if (geom.getDimension() == 0) {
            return this.isAnyTestPointInTarget(geom);
        }
        return false;
    }

    protected boolean isAnyTestPointInTarget(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p : coords) {
            if (!locator.intersects(p, this.prepLine.getGeometry())) continue;
            return true;
        }
        return false;
    }
}

