/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.list.SimpleListProperty;

public class SimplePropertyObservableList<S, E>
extends AbstractObservableList<E>
implements IPropertyObservable<SimpleListProperty<S, E>> {
    private S source;
    private SimpleListProperty<S, E> property;
    private volatile boolean updating = false;
    private volatile int simplePropertyModCount = 0;
    private INativePropertyListener<S> listener;
    private List<E> cachedList;
    private boolean stale;

    public SimplePropertyObservableList(Realm realm, S source, SimpleListProperty<S, E> property) {
        super(realm);
        this.source = source;
        this.property = property;
    }

    protected void firstListenerAdded() {
        if (!this.isDisposed() && this.listener == null) {
            this.listener = this.property.adaptListener(event -> {
                if (!this.isDisposed() && !this.updating) {
                    this.getRealm().exec(() -> {
                        if (simplePropertyEvent.type == SimplePropertyEvent.CHANGE) {
                            ++this.simplePropertyModCount;
                            this.notifyIfChanged((ListDiff)simplePropertyEvent.diff);
                        } else if (simplePropertyEvent.type == SimplePropertyEvent.STALE && !this.stale) {
                            this.stale = true;
                            this.fireStale();
                        }
                    });
                }
            });
        }
        this.getRealm().exec(() -> {
            this.cachedList = new ArrayList<E>(this.getList());
            this.stale = false;
            if (this.listener != null) {
                this.listener.addTo(this.source);
            }
        });
    }

    protected void lastListenerRemoved() {
        if (this.listener != null) {
            this.listener.removeFrom(this.source);
        }
        this.cachedList = null;
        this.stale = false;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public Object getElementType() {
        return this.property.getElementType();
    }

    private List<E> getList() {
        return this.property.getList(this.source);
    }

    protected int doGetSize() {
        return this.getList().size();
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return this.getList().contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        this.getterCalled();
        return this.getList().containsAll(c);
    }

    public E get(int index) {
        this.getterCalled();
        return this.getList().get(index);
    }

    public int indexOf(Object o) {
        this.getterCalled();
        return this.getList().indexOf(o);
    }

    public boolean isEmpty() {
        this.getterCalled();
        return this.getList().isEmpty();
    }

    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.getList().lastIndexOf(o);
    }

    public Object[] toArray() {
        this.getterCalled();
        return this.getList().toArray();
    }

    public <T> T[] toArray(T[] a) {
        this.getterCalled();
        return this.getList().toArray(a);
    }

    private void updateList(List<E> list, ListDiff<E> diff) {
        if (!diff.isEmpty()) {
            boolean wasUpdating = this.updating;
            this.updating = true;
            try {
                this.property.updateList(this.source, diff);
                ++this.simplePropertyModCount;
            }
            finally {
                this.updating = wasUpdating;
            }
            this.notifyIfChanged(null);
        }
    }

    public boolean add(E o) {
        this.checkRealm();
        List<E> list = this.getList();
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)list.size(), (boolean)true, o));
        this.updateList(list, diff);
        return true;
    }

    public void add(int index, E o) {
        this.checkRealm();
        List<E> list = this.getList();
        if (index < 0 || index > list.size()) {
            throw new IndexOutOfBoundsException();
        }
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, o));
        this.updateList(list, diff);
    }

    public Iterator<E> iterator() {
        this.getterCalled();
        return new Iterator<E>(){
            int expectedModCount;
            List<E> list;
            ListIterator<E> iterator;
            E lastElement;
            int lastIndex;
            {
                this.expectedModCount = SimplePropertyObservableList.this.simplePropertyModCount;
                this.list = new ArrayList(SimplePropertyObservableList.this.getList());
                this.iterator = this.list.listIterator();
                this.lastElement = null;
                this.lastIndex = -1;
            }

            @Override
            public boolean hasNext() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                this.lastElement = this.iterator.next();
                Object next = this.lastElement;
                this.lastIndex = this.iterator.previousIndex();
                return next;
            }

            @Override
            public void remove() {
                SimplePropertyObservableList.this.checkRealm();
                this.checkForComodification();
                if (this.lastIndex == -1) {
                    throw new IllegalStateException();
                }
                this.iterator.remove();
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)false, this.lastElement));
                SimplePropertyObservableList.this.updateList(this.list, diff);
                this.lastElement = null;
                this.lastIndex = -1;
                this.expectedModCount = SimplePropertyObservableList.this.simplePropertyModCount;
            }

            private void checkForComodification() {
                if (this.expectedModCount != SimplePropertyObservableList.this.simplePropertyModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public E move(int oldIndex, int newIndex) {
        this.checkRealm();
        List<E> list = this.getList();
        int size = list.size();
        if (oldIndex < 0 || oldIndex >= size || newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (oldIndex == newIndex) {
            return list.get(oldIndex);
        }
        E element = list.get(oldIndex);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)oldIndex, (boolean)false, element), (ListDiffEntry)Diffs.createListDiffEntry((int)newIndex, (boolean)true, element));
        this.updateList(list, diff);
        return element;
    }

    public boolean remove(Object o) {
        this.checkRealm();
        List<E> list = this.getList();
        int index = list.indexOf(o);
        if (index == -1) {
            return false;
        }
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, (Object)o));
        this.updateList(list, diff);
        return true;
    }

    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        return new ListIterator<E>(index){
            int expectedModCount;
            List<E> list;
            ListIterator<E> iterator;
            E lastElement;
            int lastIndex;
            {
                this.expectedModCount = SimplePropertyObservableList.this.simplePropertyModCount;
                this.list = new ArrayList(SimplePropertyObservableList.this.getList());
                this.iterator = this.list.listIterator(n);
                this.lastElement = null;
                this.lastIndex = -1;
            }

            @Override
            public boolean hasNext() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                return this.iterator.hasNext();
            }

            @Override
            public int nextIndex() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                return this.iterator.nextIndex();
            }

            @Override
            public E next() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                this.lastElement = this.iterator.next();
                this.lastIndex = this.iterator.previousIndex();
                return this.lastElement;
            }

            @Override
            public boolean hasPrevious() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                return this.iterator.hasPrevious();
            }

            @Override
            public int previousIndex() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                return this.iterator.previousIndex();
            }

            @Override
            public E previous() {
                SimplePropertyObservableList.this.getterCalled();
                this.checkForComodification();
                this.lastElement = this.iterator.previous();
                this.lastIndex = this.iterator.nextIndex();
                return this.lastElement;
            }

            @Override
            public void add(E o) {
                SimplePropertyObservableList.this.checkRealm();
                this.checkForComodification();
                int index = this.iterator.nextIndex();
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, o));
                SimplePropertyObservableList.this.updateList(this.list, diff);
                this.iterator.add(o);
                this.lastElement = null;
                this.lastIndex = -1;
                this.expectedModCount = SimplePropertyObservableList.this.simplePropertyModCount;
            }

            @Override
            public void set(E o) {
                SimplePropertyObservableList.this.checkRealm();
                this.checkForComodification();
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)false, this.lastElement), (ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)true, o));
                SimplePropertyObservableList.this.updateList(this.list, diff);
                this.iterator.set(o);
                this.lastElement = o;
                this.expectedModCount = SimplePropertyObservableList.this.simplePropertyModCount;
            }

            @Override
            public void remove() {
                SimplePropertyObservableList.this.checkRealm();
                this.checkForComodification();
                if (this.lastIndex == -1) {
                    throw new IllegalStateException();
                }
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)false, this.lastElement));
                SimplePropertyObservableList.this.updateList(this.list, diff);
                this.iterator.remove();
                this.lastElement = null;
                this.lastIndex = -1;
                this.expectedModCount = SimplePropertyObservableList.this.simplePropertyModCount;
            }

            private void checkForComodification() {
                if (this.expectedModCount != SimplePropertyObservableList.this.simplePropertyModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public E remove(int index) {
        this.checkRealm();
        List<E> list = this.getList();
        E element = list.get(index);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, element));
        this.updateList(list, diff);
        return element;
    }

    public E set(int index, E o) {
        this.checkRealm();
        List<E> list = this.getList();
        E oldElement = list.get(index);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, oldElement), (ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, o));
        this.updateList(list, diff);
        return oldElement;
    }

    public List<E> subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return Collections.unmodifiableList(this.getList().subList(fromIndex, toIndex));
    }

    public boolean addAll(Collection<? extends E> c) {
        this.checkRealm();
        if (c.isEmpty()) {
            return false;
        }
        List<E> list = this.getList();
        return this.addAll(list, list.size(), c);
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkRealm();
        if (c.isEmpty()) {
            return false;
        }
        return this.addAll(this.getList(), index, c);
    }

    private boolean addAll(List<E> list, int index, Collection<? extends E> c) {
        if (index < 0 || index > list.size()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>(c.size());
        int offsetIndex = 0;
        for (E element : c) {
            entries.add(Diffs.createListDiffEntry((int)(index + offsetIndex), (boolean)true, element));
            ++offsetIndex;
        }
        ListDiff diff = Diffs.createListDiff(entries);
        this.updateList(list, diff);
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        this.checkRealm();
        if (c.isEmpty()) {
            return false;
        }
        List<E> list = this.getList();
        if (list.isEmpty()) {
            return false;
        }
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>();
        ListIterator<E> it = list.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex() - entries.size();
            E element = it.next();
            if (!c.contains(element)) continue;
            entries.add(Diffs.createListDiffEntry((int)index, (boolean)false, element));
        }
        if (entries.isEmpty()) {
            return false;
        }
        ListDiff diff = Diffs.createListDiff(entries);
        this.updateList(list, diff);
        return true;
    }

    public boolean retainAll(Collection<?> c) {
        this.checkRealm();
        List<E> list = this.getList();
        if (list.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>();
        ListIterator<E> it = list.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex() - entries.size();
            E element = it.next();
            if (c.contains(element)) continue;
            entries.add(Diffs.createListDiffEntry((int)index, (boolean)false, element));
        }
        if (entries.isEmpty()) {
            return false;
        }
        ListDiff diff = Diffs.createListDiff(entries);
        this.updateList(list, diff);
        return true;
    }

    public void clear() {
        this.checkRealm();
        List<E> list = this.getList();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>();
        ListIterator<E> it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            int index = it.previousIndex();
            E element = it.previous();
            entries.add(Diffs.createListDiffEntry((int)index, (boolean)false, element));
        }
        ListDiff diff = Diffs.createListDiff(entries);
        this.updateList(list, diff);
    }

    private void notifyIfChanged(ListDiff<E> diff) {
        if (this.hasListeners()) {
            List<E> oldList = this.cachedList;
            this.cachedList = new ArrayList<E>(this.getList());
            ArrayList<E> newList = this.cachedList;
            if (diff == null) {
                diff = Diffs.computeListDiff(oldList, newList);
            }
            if (!diff.isEmpty() || this.stale) {
                this.stale = false;
                this.fireListChange(diff);
            }
        }
    }

    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    public boolean equals(Object o) {
        this.getterCalled();
        return this.getList().equals(o);
    }

    public int hashCode() {
        this.getterCalled();
        return this.getList().hashCode();
    }

    public Object getObserved() {
        return this.source;
    }

    @Override
    public SimpleListProperty<S, E> getProperty() {
        return this.property;
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            if (this.listener != null) {
                this.listener.removeFrom(this.source);
            }
            this.property = null;
            this.source = null;
            this.listener = null;
            this.stale = false;
        }
        super.dispose();
    }
}

