/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;

public class EditorAccessibleAdapter
extends AccessibleControlAdapter
implements AccessibleListener {
    private static final String ACTIVE_NAME_EDITOR = "editor %s %s";
    private static final String ACTIVE_NAME_TAB = "active tab %s %s of %s";
    private static final String ACTIVE_NAME_TAB_NO_TITLE = "active tab %s of %s";
    private final Control composite;

    EditorAccessibleAdapter(@NotNull Control composite) {
        this.composite = composite;
    }

    public void getName(AccessibleEvent e) {
        if (this.composite != null) {
            e.result = EditorAccessibleAdapter.composeActiveEditorTabName(this.composite);
        }
    }

    public void getValue(AccessibleControlEvent e) {
        if (this.composite != null) {
            e.result = EditorAccessibleAdapter.composeActiveEditorTabName(this.composite);
        }
    }

    public void getHelp(AccessibleEvent e) {
    }

    public void getKeyboardShortcut(AccessibleEvent e) {
    }

    public void getDescription(AccessibleEvent e) {
    }

    @NotNull
    private static String composeActiveEditorTabName(@NotNull Control context) {
        String msg = "";
        Composite parentTab = context.getParent();
        if (parentTab instanceof CTabFolder) {
            CTabFolder tabFoler = (CTabFolder)parentTab;
            if (tabFoler.getSelection() == null) {
                return msg;
            }
            String text = tabFoler.getSelection().getText();
            msg = text != null ? String.format(ACTIVE_NAME_TAB, text, tabFoler.getSelectionIndex() + 1, tabFoler.getItemCount()) : String.format(ACTIVE_NAME_TAB_NO_TITLE, tabFoler.getSelectionIndex() + 1, tabFoler.getItemCount());
            Composite parentEditor = parentTab.getParent();
            if (parentEditor != null && !parentEditor.isDisposed() && (parentEditor = parentEditor.getParent()) != null && !parentEditor.isDisposed() && (parentEditor = parentEditor.getParent()) != null && !parentEditor.isDisposed() && parentEditor instanceof CTabFolder) {
                CTabFolder parentEditorFolder = (CTabFolder)parentEditor;
                msg = String.format(ACTIVE_NAME_EDITOR, parentEditorFolder.getSelection().getText(), msg);
            }
        }
        return msg;
    }
}

